/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.grid;

import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;

public class GridCountValueAndCoupleKernel
extends GridLandscapeMetricKernel {
    private final int nbValues;
    private int[][] mapCouples;
    private int[] mapValues;

    public GridCountValueAndCoupleKernel(int gridSize, int noDataValue, int[] values) {
        super(gridSize, noDataValue);
        this.nbValues = values.length;
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
        this.mapCouples = new int[values.length][values.length];
        int index = 0;
        for (int v : values) {
            this.mapCouples[this.mapValues[v]][this.mapValues[v]] = index++;
        }
        for (int v1 : values) {
            for (int v2 : values) {
                if (v1 >= v2) continue;
                this.mapCouples[this.mapValues[v1]][this.mapValues[v2]] = index;
                this.mapCouples[this.mapValues[v2]][this.mapValues[v1]] = index++;
            }
        }
    }

    @Override
    protected void processGrid(int x, int theY) {
        this.outDatas()[x][0] = 1.0;
        for (int i = 1; i < this.outDatas()[0].length; ++i) {
            this.outDatas()[x][i] = 0.0;
        }
        for (int y = 0; y < this.gridSize(); ++y) {
            if (theY + y >= this.height()) continue;
            for (int lx = 0; lx < this.gridSize(); ++lx) {
                int mv;
                if (x * this.gridSize() + lx >= this.width()) continue;
                short v = (short)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx)];
                double[] dArray = this.outDatas()[x];
                dArray[2] = dArray[2] + 1.0;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas()[x];
                    dArray2[3] = dArray2[3] + 1.0;
                } else if (v == 0) {
                    double[] dArray3 = this.outDatas()[x];
                    dArray3[4] = dArray3[4] + 1.0;
                } else {
                    mv = this.mapValues[v];
                    double[] dArray4 = this.outDatas()[x];
                    int n = mv + 5;
                    dArray4[n] = dArray4[n] + 1.0;
                }
                if (y > 0) {
                    short v_V = (short)this.inDatas()[(theY + y - 1) * this.width() + (x * this.gridSize() + lx)];
                    double[] dArray5 = this.outDatas()[x];
                    int n = this.nbValues + 5;
                    dArray5[n] = dArray5[n] + 1.0;
                    if (v == this.noDataValue() || v_V == this.noDataValue()) {
                        double[] dArray6 = this.outDatas()[x];
                        int n2 = this.nbValues + 6;
                        dArray6[n2] = dArray6[n2] + 1.0;
                    } else if (v == 0 || v_V == 0) {
                        double[] dArray7 = this.outDatas()[x];
                        int n3 = this.nbValues + 7;
                        dArray7[n3] = dArray7[n3] + 1.0;
                    } else {
                        mv = this.mapCouples[this.mapValues[v]][this.mapValues[v_V]];
                        double[] dArray8 = this.outDatas()[x];
                        int n4 = this.nbValues + mv + 8;
                        dArray8[n4] = dArray8[n4] + 1.0;
                    }
                }
                if (lx <= 0) continue;
                short v_H = (short)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx - 1)];
                double[] dArray9 = this.outDatas()[x];
                int n = this.nbValues + 5;
                dArray9[n] = dArray9[n] + 1.0;
                if (v == this.noDataValue() || v_H == this.noDataValue()) {
                    double[] dArray10 = this.outDatas()[x];
                    int n5 = this.nbValues + 6;
                    dArray10[n5] = dArray10[n5] + 1.0;
                    continue;
                }
                if (v == 0 || v_H == 0) {
                    double[] dArray11 = this.outDatas()[x];
                    int n6 = this.nbValues + 7;
                    dArray11[n6] = dArray11[n6] + 1.0;
                    continue;
                }
                mv = this.mapCouples[this.mapValues[v]][this.mapValues[v_H]];
                double[] dArray12 = this.outDatas()[x];
                int n7 = this.nbValues + mv + 8;
                dArray12[n7] = dArray12[n7] + 1.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCouples = null;
        this.mapValues = null;
    }
}

