/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.kernel.grid;

import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;

public class GridCountCoupleKernel
extends GridLandscapeMetricKernel {
    private int[][] mapCouples;
    private int[] mapValues;

    public GridCountCoupleKernel(int gridSize, int noDataValue, int[] values) {
        super(gridSize, noDataValue);
        int maxV = 0;
        for (int v : values) {
            maxV = Math.max(v, maxV);
        }
        this.mapValues = new int[++maxV];
        for (int i = 0; i < values.length; ++i) {
            this.mapValues[values[i]] = i;
        }
        this.mapCouples = new int[values.length][values.length];
        int index = 0;
        for (int v : values) {
            this.mapCouples[this.mapValues[v]][this.mapValues[v]] = index++;
        }
        for (int v1 : values) {
            for (int v2 : values) {
                if (v1 >= v2) continue;
                this.mapCouples[this.mapValues[v1]][this.mapValues[v2]] = index;
                this.mapCouples[this.mapValues[v2]][this.mapValues[v1]] = index++;
            }
        }
    }

    @Override
    protected void processGrid(int x, int theY) {
        this.outDatas()[x][0] = 1.0;
        for (int i = 1; i < this.outDatas()[0].length; ++i) {
            this.outDatas()[x][i] = 0.0;
        }
        for (int y = 0; y < this.gridSize(); ++y) {
            if (theY + y >= this.height()) continue;
            for (int lx = 0; lx < this.gridSize(); ++lx) {
                int mc;
                if (x * this.gridSize() + lx >= this.width()) continue;
                short v = (short)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx)];
                double[] dArray = this.outDatas()[x];
                dArray[2] = dArray[2] + 1.0;
                if (v == this.noDataValue()) {
                    double[] dArray2 = this.outDatas()[x];
                    dArray2[3] = dArray2[3] + 1.0;
                }
                if (y > 0) {
                    short v_V = (short)this.inDatas()[(theY + y - 1) * this.width() + (x * this.gridSize() + lx)];
                    double[] dArray3 = this.outDatas()[x];
                    dArray3[4] = dArray3[4] + 1.0;
                    if (v == this.noDataValue() || v_V == this.noDataValue()) {
                        double[] dArray4 = this.outDatas()[x];
                        dArray4[5] = dArray4[5] + 1.0;
                    } else if (v == 0 || v_V == 0) {
                        double[] dArray5 = this.outDatas()[x];
                        dArray5[6] = dArray5[6] + 1.0;
                    } else {
                        mc = this.mapCouples[this.mapValues[v]][this.mapValues[v_V]];
                        double[] dArray6 = this.outDatas()[x];
                        int n = mc + 7;
                        dArray6[n] = dArray6[n] + 1.0;
                    }
                }
                if (lx <= 0) continue;
                short v_H = (short)this.inDatas()[(theY + y) * this.width() + (x * this.gridSize() + lx - 1)];
                double[] dArray7 = this.outDatas()[x];
                dArray7[4] = dArray7[4] + 1.0;
                if (v == this.noDataValue() || v_H == this.noDataValue()) {
                    double[] dArray8 = this.outDatas()[x];
                    dArray8[5] = dArray8[5] + 1.0;
                    continue;
                }
                if (v == 0 || v_H == 0) {
                    double[] dArray9 = this.outDatas()[x];
                    dArray9[6] = dArray9[6] + 1.0;
                    continue;
                }
                mc = this.mapCouples[this.mapValues[v]][this.mapValues[v_H]];
                double[] dArray10 = this.outDatas()[x];
                int n = mc + 7;
                dArray10[n] = dArray10[n] + 1.0;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCouples = null;
        this.mapValues = null;
    }
}

