/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCountingInterface;
import java.util.HashMap;
import java.util.Map;

public class ValueCounting
extends Counting
implements ValueCountingInterface {
    private Map<Integer, Double> countValues;
    private int[] values;
    private double totalCountValues;
    private int countClass;

    public ValueCounting(double resolution, int[] values, double theoreticalSize) {
        super(resolution, theoreticalSize);
        this.values = values;
        this.countValues = new HashMap<Integer, Double>();
    }

    public ValueCounting(double resolution, int[] values) {
        this(resolution, values, 0.0);
    }

    @Override
    public void doSetCounts(double[] counts) {
        this.totalCountValues = this.validValues() - counts[4];
        this.countClass = 0;
        this.countValues.clear();
        for (int i = 5; i < counts.length; ++i) {
            if (counts[i] > 0.0) {
                ++this.countClass;
            }
            this.countValues.put(this.values[i - 5], counts[i]);
        }
    }

    @Override
    public double countValues() {
        return this.totalCountValues;
    }

    @Override
    public int[] values() {
        return this.values;
    }

    @Override
    public double countValue(int v) {
        return this.countValues.get(v);
    }

    @Override
    public int countClass() {
        return this.countClass;
    }
}

