/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.ValueCountingInterface;
import java.util.HashMap;
import java.util.Map;

public class ValueAndCoupleCounting
extends Counting
implements ValueCountingInterface,
CoupleCountingInterface {
    private Map<Integer, Double> countValues;
    private int[] values;
    private double totalCountValues;
    private int countClass;
    private Map<Float, Double> countCouples;
    private float[] couples;
    private double theoreticalCoupleSize;
    private double totalCouples;
    private double validCouples;
    private double totalCountCouples;
    private double homogeneousCouples;
    private double heterogeneousCouples;
    private short countCoupleClass;

    public ValueAndCoupleCounting(double resolution, int[] values, float[] couples, double theoreticalSize, double theoreticalCoupleSize) {
        super(resolution, theoreticalSize);
        this.values = values;
        this.countValues = new HashMap<Integer, Double>();
        this.couples = couples;
        this.countCouples = new HashMap<Float, Double>();
        this.theoreticalCoupleSize = theoreticalCoupleSize;
    }

    public ValueAndCoupleCounting(double resolution, int[] values, float[] couples) {
        this(resolution, values, couples, 0.0, 0.0);
    }

    @Override
    public void doSetCounts(double[] counts) {
        int i;
        this.totalCountValues = this.validValues() - counts[4];
        this.countClass = 0;
        this.countValues.clear();
        for (i = 5; i < this.values.length + 5; ++i) {
            if (counts[i] > 0.0) {
                ++this.countClass;
            }
            this.countValues.put(this.values[i - 5], counts[i]);
        }
        this.totalCouples = counts[this.values.length + 5];
        this.validCouples = this.totalCouples - counts[this.values.length + 6];
        this.totalCountCouples = this.validCouples - counts[this.values.length + 7];
        this.countCoupleClass = 0;
        this.homogeneousCouples = 0.0;
        this.heterogeneousCouples = 0.0;
        this.countCouples.clear();
        for (i = this.values.length + 8; i < this.values.length + 8 + this.couples.length; ++i) {
            if (i - (this.values.length + 8) < this.values.length) {
                this.homogeneousCouples += counts[i];
            } else {
                this.heterogeneousCouples += counts[i];
            }
            if (counts[i] > 0.0) {
                this.countCoupleClass = (short)(this.countCoupleClass + 1);
            }
            this.countCouples.put(Float.valueOf(this.couples[i - (this.values.length + 8)]), counts[i]);
        }
    }

    @Override
    public double countValues() {
        return this.totalCountValues;
    }

    @Override
    public int[] values() {
        return this.values;
    }

    @Override
    public double countValue(int v) {
        return this.countValues.get(v);
    }

    @Override
    public int countClass() {
        return this.countClass;
    }

    @Override
    public double theoreticalCoupleSize() {
        return this.theoreticalCoupleSize;
    }

    @Override
    public double totalCouples() {
        return this.totalCouples;
    }

    @Override
    public double validCouples() {
        return this.validCouples;
    }

    @Override
    public double countCouples() {
        return this.totalCountCouples;
    }

    @Override
    public float[] couples() {
        return this.couples;
    }

    @Override
    public double countCouple(float c) {
        if (this.countCouples.containsKey(Float.valueOf(c))) {
            return this.countCouples.get(Float.valueOf(c));
        }
        return 0.0;
    }

    @Override
    public short countCoupleClass() {
        return this.countCoupleClass;
    }

    @Override
    public double countHomogeneousCouples() {
        return this.homogeneousCouples;
    }

    @Override
    public double countHeterogenousCouples() {
        return this.heterogeneousCouples;
    }
}

