/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCountingInterface;

public class QuantitativeCounting
extends Counting
implements QuantitativeCountingInterface {
    private double sum;
    private double squareSum;
    private double minimum;
    private double maximum;

    public QuantitativeCounting(double resolution, double theoriticalSize) {
        super(resolution, theoriticalSize);
    }

    public QuantitativeCounting(double theoriticalSize) {
        this(1.0, theoriticalSize);
    }

    @Override
    public void doSetCounts(double[] counts) {
        this.sum = counts[4];
        this.squareSum = counts[5];
        this.minimum = counts[6];
        this.maximum = counts[7];
    }

    @Override
    public double average() {
        return (float)(this.sum / this.validValues());
    }

    @Override
    public double sum() {
        return this.sum;
    }

    @Override
    public double squareSum() {
        return this.squareSum;
    }

    @Override
    public double standardDeviation() {
        if (this.squareSum / this.validValues() - Math.pow(this.sum / this.validValues(), 2.0) < 0.0) {
            return 0.0;
        }
        return (float)Math.sqrt(this.squareSum / this.validValues() - Math.pow(this.sum / this.validValues(), 2.0));
    }

    @Override
    public double minimum() {
        return this.minimum;
    }

    @Override
    public double maximum() {
        return this.maximum;
    }
}

