/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.PatchCountingInterface;
import java.util.HashMap;
import java.util.Map;

public class PatchCounting
extends Counting
implements PatchCountingInterface {
    private int[] values;
    private double totalSurface;
    private int nbPatch;
    private double maxSurface;
    private double totalSurfaceCarre;
    private Map<Integer, Integer> nbPatches;
    private Map<Integer, Double> totalSurfaces;
    private Map<Integer, Double> maxSurfaces;
    private Map<Integer, Double> totalSurfacesCarres;

    public PatchCounting(double resolution, int[] values, double theoreticalSize) {
        super(resolution, theoreticalSize);
        this.values = values;
        this.nbPatches = new HashMap<Integer, Integer>();
        this.totalSurfaces = new HashMap<Integer, Double>();
        this.maxSurfaces = new HashMap<Integer, Double>();
        this.totalSurfacesCarres = new HashMap<Integer, Double>();
    }

    public PatchCounting(double resolution, int[] values) {
        this(resolution, values, 0.0);
    }

    @Override
    public void doSetCounts(double[] counts) {
        int i;
        this.nbPatch = (int)counts[4];
        this.totalSurface = counts[5];
        this.maxSurface = counts[6];
        this.totalSurfaceCarre = counts[7];
        for (i = 0; i < this.values.length; ++i) {
            this.nbPatches.put(this.values[i], (int)counts[i + 8]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.totalSurfaces.put(this.values[i], counts[i + 8 + this.values.length]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.maxSurfaces.put(this.values[i], counts[i + 8 + 2 * this.values.length]);
        }
        for (i = 0; i < this.values.length; ++i) {
            this.totalSurfacesCarres.put(this.values[i], counts[i + 8 + 3 * this.values.length]);
        }
    }

    @Override
    public double totalSurface() {
        return this.totalSurface;
    }

    @Override
    public int nbPatches() {
        return this.nbPatch;
    }

    @Override
    public double maxSurface() {
        return this.maxSurface;
    }

    @Override
    public double totalSurfaceCarre() {
        return this.totalSurfaceCarre;
    }

    @Override
    public int nbPatches(int v) {
        return this.nbPatches.get(v);
    }

    @Override
    public double totalSurface(int v) {
        return this.totalSurfaces.get(v);
    }

    @Override
    public double maxSurface(int v) {
        return this.maxSurfaces.get(v);
    }

    @Override
    public double totalSurfaceCarre(int v) {
        return this.totalSurfacesCarres.get(v);
    }
}

