/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCountingInterface;
import java.util.HashMap;
import java.util.Map;

public class CoupleCounting
extends Counting
implements CoupleCountingInterface {
    private Map<Float, Double> countCouples;
    private int nValues;
    private float[] couples;
    private double theoreticalCoupleSize;
    private double totalCouples;
    private double validCouples;
    private double totalCountCouples;
    private double homogeneousCouples;
    private double heterogeneousCouples;
    private short countCoupleClass;

    public CoupleCounting(double resolution, int nValues, float[] couples, double theoreticalSize, double theoreticalCoupleSize) {
        super(resolution, theoreticalSize);
        this.nValues = nValues;
        this.couples = couples;
        this.countCouples = new HashMap<Float, Double>();
        this.theoreticalCoupleSize = theoreticalCoupleSize;
    }

    public CoupleCounting(double resolution, int nValues, float[] couples) {
        this(resolution, nValues, couples, 0.0, 0.0);
    }

    @Override
    public void doSetCounts(double[] counts) {
        this.totalCouples = counts[4];
        this.validCouples = this.totalCouples - counts[5];
        this.totalCountCouples = this.validCouples - counts[6];
        this.countCoupleClass = 0;
        this.homogeneousCouples = 0.0;
        this.heterogeneousCouples = 0.0;
        this.countCouples.clear();
        for (int i = 7; i < counts.length; ++i) {
            if (i - 7 < this.nValues) {
                this.homogeneousCouples += counts[i];
            } else {
                this.heterogeneousCouples += counts[i];
            }
            if (counts[i] > 0.0) {
                this.countCoupleClass = (short)(this.countCoupleClass + 1);
            }
            this.countCouples.put(Float.valueOf(this.couples[i - 7]), counts[i]);
        }
    }

    @Override
    public double theoreticalCoupleSize() {
        return this.theoreticalCoupleSize;
    }

    @Override
    public double totalCouples() {
        return this.totalCouples;
    }

    @Override
    public double validCouples() {
        return this.validCouples;
    }

    @Override
    public double countCouples() {
        return this.totalCountCouples;
    }

    @Override
    public float[] couples() {
        return this.couples;
    }

    @Override
    public double countCouple(float c) {
        if (this.countCouples.containsKey(Float.valueOf(c))) {
            return this.countCouples.get(Float.valueOf(c));
        }
        return 0.0;
    }

    @Override
    public short countCoupleClass() {
        return this.countCoupleClass;
    }

    @Override
    public double countHomogeneousCouples() {
        return this.homogeneousCouples;
    }

    @Override
    public double countHeterogenousCouples() {
        return this.heterogeneousCouples;
    }
}

