/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.counting;

import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.counting.BasicCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.ContinuityCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.DegatErosionCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.PatchCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.SlopeCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.SourceErosionCountingInterface;
import fr.inrae.act.bagap.chloe.window.counting.ValueCountingInterface;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class Counting
implements BasicCountingInterface,
ValueCountingInterface,
CoupleCountingInterface,
QuantitativeCountingInterface,
PatchCountingInterface,
SlopeCountingInterface,
ContinuityCountingInterface,
SourceErosionCountingInterface,
DegatErosionCountingInterface {
    private static double minRate = 0.0;
    private boolean validCounting;
    private double resolution;
    private double theoreticalSize;
    private double centralValue;
    private double totalValues;
    private double validValues;
    private Set<Metric> metrics;
    private Set<CountingObserver> observers;

    public Counting(double resolution, double theoreticalSize) {
        this.resolution = resolution;
        this.theoreticalSize = theoreticalSize;
        this.metrics = new TreeSet<Metric>();
        this.observers = new HashSet<CountingObserver>();
    }

    public void setCounts(double[] counts) {
        if (counts[0] == 1.0) {
            this.totalValues = counts[2];
            this.validValues = this.totalValues - counts[3];
            if (!(this.validValues / this.theoreticalSize >= minRate)) {
                this.setValidCounting(false);
                return;
            }
            this.setValidCounting(true);
            this.doSetCounts(counts);
            this.centralValue = counts[1];
        } else {
            this.setValidCounting(false);
        }
    }

    public abstract void doSetCounts(double[] var1);

    public void addMetric(Metric m) {
        this.metrics.add(m);
    }

    public Set<Metric> metrics() {
        return this.metrics;
    }

    public Set<CountingObserver> observers() {
        return this.observers;
    }

    public void init() {
        for (CountingObserver co : this.observers) {
            co.init(this, this.metrics());
        }
    }

    public void close() {
        for (CountingObserver co : this.observers) {
            co.close(this, this.metrics());
        }
    }

    public void addObserver(CountingObserver co) {
        this.observers.add(co);
    }

    public static void setMinRate(double min) {
        minRate = min;
    }

    public void calculate() {
        for (CountingObserver co : this.observers) {
            co.prerun(this);
        }
        this.doCalculate();
    }

    private void doCalculate() {
        if (this.validCounting()) {
            for (Metric m : this.metrics()) {
                m.calculate(this, "");
            }
        } else {
            for (Metric m : this.metrics()) {
                m.unCalculate("");
            }
        }
    }

    public void export(int x, int y) {
        for (CountingObserver co : this.observers) {
            co.postrun(this, x, y, this.metrics);
        }
    }

    public void export(Pixel p) {
        for (CountingObserver co : this.observers) {
            co.postrun(this, p, this.metrics);
        }
    }

    public void export(int id) {
        for (CountingObserver co : this.observers) {
            co.postrun(this, id, this.metrics);
        }
    }

    @Override
    public boolean validCounting() {
        return this.validCounting;
    }

    public void setValidCounting(boolean vc) {
        this.validCounting = vc;
    }

    public double resolution() {
        return this.resolution;
    }

    @Override
    public double theoreticalSize() {
        if (this.theoreticalSize == 0.0) {
            return this.totalValues;
        }
        return this.theoreticalSize;
    }

    @Override
    public double totalValues() {
        return this.totalValues;
    }

    @Override
    public double validValues() {
        return this.validValues;
    }

    @Override
    public double centralValue() {
        return this.centralValue;
    }

    @Override
    public double countValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countValue(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int countClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double theoreticalCoupleSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double totalCouples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double validCouples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countCouples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countHomogeneousCouples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countHeterogenousCouples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] couples() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countCouple(float c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double countCouple(short v1, short v2) {
        return this.countCouple(Couple.getCouple(v1, v2));
    }

    @Override
    public short countCoupleClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double average() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double standardDeviation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double sum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double squareSum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nbPatches() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double totalSurface() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maxSurface() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double totalSurfaceCarre() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nbPatches(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double totalSurface(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maxSurface(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double totalSurfaceCarre(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double slopeDirection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double slopeIntensity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double surface() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double volume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double sourceErosionEmprise() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double sourceErosionIntensity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double degatErosionEmprise() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double degatErosionIntensity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double massCumul() {
        throw new UnsupportedOperationException();
    }
}

