/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.sliding;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.SlidingLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.awt.Rectangle;

public class TinySlidingLandscapeMetricAnalysis
extends SlidingLandscapeMetricAnalysis {
    private int buffer;

    public TinySlidingLandscapeMetricAnalysis(Coverage coverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, int displacement, SlidingLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, displacement, kernel, counting);
    }

    public TinySlidingLandscapeMetricAnalysis(Coverage[] coverages, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, int displacement, SlidingLandscapeMetricKernel kernel, Counting counting) {
        super(coverages, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, displacement, kernel, counting);
    }

    @Override
    protected void doInit() {
        this.kernel().setWidth(this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax());
        this.kernel().setHeight(this.roiHeight() + this.bufferROIYMin() + this.bufferROIYMax());
        this.kernel().setBufferROIXMin(this.bufferROIXMin());
        this.kernel().setBufferROIXMax(this.bufferROIXMax());
        this.kernel().setBufferROIYMin(this.bufferROIYMin());
        this.kernel().setBufferROIYMax(this.bufferROIYMax());
        Rectangle roi = new Rectangle(this.roiX() - this.bufferROIXMin(), this.roiY() - this.bufferROIYMin(), this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax(), this.roiHeight() + this.bufferROIYMin() + this.bufferROIYMax());
        this.manageInDatas(roi);
        this.buffer = (short)Math.max(this.displacement(), LandscapeMetricAnalysis.bufferSize());
        this.kernel().setOutDatas(new double[((this.roiWidth() - 1) / this.displacement() + 1) * ((this.buffer - 1) / this.displacement() + 1)][this.nbValues()]);
        this.counting().init();
    }

    @Override
    protected void doRun() {
        int nextJ = 0;
        for (int b = 0; b < this.roiHeight(); b += this.buffer) {
            this.kernel().applySlidingWindow(b, Math.min(this.buffer, this.roiHeight() - b));
            int index = 0;
            for (int j = nextJ % this.buffer; j < Math.min(this.buffer, this.roiHeight() - b); j += this.displacement()) {
                nextJ += this.displacement();
                for (int i = 0; i < this.roiWidth(); i += this.displacement()) {
                    this.counting().setCounts(this.kernel().outDatas()[index]);
                    this.counting().calculate();
                    this.counting().export(i, j + b);
                    ++index;
                }
            }
        }
    }

    @Override
    protected void manageInDatas(Rectangle roi) {
        float[][] inDatas = new float[this.coverages().length][];
        for (int i = 0; i < this.coverages().length; ++i) {
            inDatas[i] = this.coverages()[i].getData(roi);
            this.coverages()[i].dispose();
        }
        this.kernel().setInDatas(inDatas);
    }
}

