/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.sliding;

import fr.inrae.act.bagap.apiland.analysis.combination.CombinationExpressionFactory;
import fr.inrae.act.bagap.apiland.analysis.distance.CombinationExpressionDistanceFunction;
import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.SlidingLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.BasicCounting;
import fr.inrae.act.bagap.chloe.window.counting.ContinuityCounting;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.DegatErosionCounting;
import fr.inrae.act.bagap.chloe.window.counting.PatchCounting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCounting;
import fr.inrae.act.bagap.chloe.window.counting.SlopeCounting;
import fr.inrae.act.bagap.chloe.window.counting.SourceErosionCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueAndCoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCounting;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingBasicKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingPatchKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.biodiversite.SlidingRepartitionDispersionKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.erosion.SlidingMassCumulKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.erosion.SlidingSourceErosionKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.gaussian.FastGaussianWeightedCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.gaussian.FastGaussianWeightedCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.gaussian.FastGaussianWeightedCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.gaussian.FastGaussianWeightedGrainBocagerDetectionBocageKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.gaussian.FastGaussianWeightedQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.square.FastSquareCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.square.FastSquareCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.square.FastSquareCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.square.FastSquareGrainBocagerDistanceBocageKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.fast.square.FastSquareQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalBasicKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalContinuityKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.functional.SlidingFunctionalCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.grainbocager.GrainBocagerSlidingDetectionBocageKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.grainbocager.GrainBocagerSlidingDistanceBocageKernel;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.slope.SlidingSlopeKernel;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.metric.ThematicDistanceMetric;
import fr.inrae.act.bagap.chloe.window.output.AsciiGridOutput;
import fr.inrae.act.bagap.chloe.window.output.CoverageOutput;
import fr.inrae.act.bagap.chloe.window.output.CsvOutput;
import fr.inrae.act.bagap.chloe.window.output.GeoTiffOutput;
import fr.inrae.act.bagap.chloe.window.output.InterpolateSplineGeoTiffOutput;
import fr.inrae.act.bagap.chloe.window.output.InterpolateSplineLinearAsciiGridOutput;
import fr.inrae.act.bagap.chloe.window.output.InterpolateSplineLinearCsvOutput;
import fr.inrae.act.bagap.chloe.window.output.InterpolateSplineLinearTabOutput;
import fr.inrae.act.bagap.chloe.window.output.TabOutput;
import fr.inrae.act.bagap.chloe.window.output.TileAsciiGridOutput;
import fr.inrae.act.bagap.chloe.window.output.TileGeoTiffOutput;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class SlidingLandscapeMetricAnalysisFactory {
    /*
     * WARNING - void declaration
     */
    public SlidingLandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder, Coverage coverage) throws IOException {
        int n;
        void var51_194;
        int[] nArray;
        Object metric;
        int roiHeight;
        int inWidth = coverage.width();
        int inHeight = coverage.height();
        double inMinX = coverage.minx();
        double inMinY = coverage.miny();
        double inMaxX = coverage.maxx();
        double inMaxY = coverage.maxy();
        float inCellSize = (float)coverage.cellsize();
        int displacement = builder.getDisplacement();
        int roiX = builder.getROIX();
        int roiY = builder.getROIY();
        int roiWidth = builder.getROIWidth();
        if (roiWidth == -1) {
            roiWidth = inWidth - roiX;
        }
        if ((roiHeight = builder.getROIHeight()) == -1) {
            roiHeight = inHeight - roiY;
        }
        int outWidth = (roiWidth - 1) / displacement + 1;
        int outHeight = (roiHeight - 1) / displacement + 1;
        double outCellSize = inCellSize * (float)displacement;
        double outMinX = inMinX + (double)((float)roiX * inCellSize) + (double)inCellSize / 2.0 - outCellSize / 2.0;
        double outMaxX = outMinX + (double)outWidth * outCellSize;
        double outMaxY = inMaxY - (double)((float)roiY * inCellSize) - (double)inCellSize / 2.0 + outCellSize / 2.0;
        double outMinY = outMaxY - (double)outHeight * outCellSize;
        int windowSize = -1;
        if (builder.getWindowSize() > 0) {
            windowSize = builder.getWindowSize();
        } else if (builder.getWindowRadius() > 0.0) {
            double v = 2.0 * builder.getWindowRadius() / (double)inCellSize;
            windowSize = v % 2.0 == 0.0 ? (int)(v + 1.0) : (int)v;
        } else {
            throw new IllegalArgumentException("windowSize must be defined");
        }
        int midWindowSize = windowSize / 2;
        int bufferROIXMin = Math.min(roiX, midWindowSize);
        int bufferROIXMax = Math.min(inWidth - (roiX + roiWidth), midWindowSize);
        int bufferROIYMin = Math.min(roiY, midWindowSize);
        int bufferROIYMax = Math.min(inHeight - (roiY + roiHeight), midWindowSize);
        float[] coeffs = new float[windowSize * windowSize];
        double dMax = builder.getDMax();
        if (dMax == -1.0) {
            dMax = (float)midWindowSize * inCellSize;
        }
        CombinationExpressionDistanceFunction function = null;
        if (builder.getWindowDistanceType() == WindowDistanceType.WEIGHTED) {
            function = CombinationExpressionFactory.createDistanceFunction(builder.getWindowDistanceFunction(), dMax);
        }
        double theoreticalSize = 0.0;
        double theoreticalCoupleSize = 0.0;
        if (builder.getWindowShapeType() == WindowShapeType.SQUARE || builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
            theoreticalSize = windowSize * windowSize;
            theoreticalCoupleSize = (windowSize - 1) * windowSize * 2;
            for (int s = 0; s < windowSize * windowSize; ++s) {
                coeffs[s] = 1.0f;
            }
        } else if (builder.getWindowShapeType() == WindowShapeType.CIRCLE) {
            for (int j = 0; j < windowSize; ++j) {
                for (int i = 0; i < windowSize; ++i) {
                    if (!(Util.distance(midWindowSize, midWindowSize, i, j) <= (double)midWindowSize)) continue;
                    if (j > 0 && Util.distance(midWindowSize, midWindowSize, i, j - 1) <= (double)midWindowSize) {
                        theoreticalCoupleSize += 1.0;
                    }
                    if (i > 0 && Util.distance(midWindowSize, midWindowSize, i - 1, j) <= (double)midWindowSize) {
                        theoreticalCoupleSize += 1.0;
                    }
                    if (builder.getWindowDistanceType() == WindowDistanceType.WEIGHTED) {
                        float d = (float)function.interprete(Util.distance(midWindowSize, midWindowSize, i, j) * (double)inCellSize);
                        theoreticalSize += (double)d;
                        coeffs[j * windowSize + i] = d;
                        continue;
                    }
                    if (builder.getWindowDistanceType() != WindowDistanceType.THRESHOLD) continue;
                    theoreticalSize += 1.0;
                    coeffs[j * windowSize + i] = 1.0f;
                }
            }
        }
        Set<Metric> metrics = builder.getMetrics();
        HashSet<CountingObserver> observers = new HashSet<CountingObserver>();
        if (builder.getCoverageOutputs() != null) {
            for (CoverageOutput coverageOutput : builder.getCoverageOutputs()) {
                coverageOutput.setEntete(new EnteteRaster(outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, (float)outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs()));
                observers.add(coverageOutput);
            }
        }
        if (builder.getCsv() != null) {
            if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                CsvOutput csvOutput = new CsvOutput(builder.getCsv(), outMinX, outMaxX, outMinY, outMaxY, outWidth, outHeight, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                observers.add(csvOutput);
            } else {
                InterpolateSplineLinearCsvOutput csvOutput = new InterpolateSplineLinearCsvOutput(builder.getCsv(), inMinX + (double)((float)roiX * inCellSize), inMaxX - (double)((float)(inWidth - roiX) * inCellSize) + (double)((float)roiWidth * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inMaxY - (double)((float)roiY * inCellSize), roiWidth, roiHeight, inCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs(), displacement);
                observers.add(csvOutput);
            }
        } else if (builder.getCsvFolder() != null) {
            String name = builder.getCsvFolder() + new File(builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "").toString() + ".csv";
            if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                CsvOutput csvOutput = new CsvOutput(name, outMinX, outMaxX, outMinY, outMaxY, outWidth, outHeight, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                observers.add(csvOutput);
            } else {
                InterpolateSplineLinearCsvOutput interpolateSplineLinearCsvOutput = new InterpolateSplineLinearCsvOutput(name, inMinX + (double)((float)roiX * inCellSize), inMaxX - (double)((float)(inWidth - roiX) * inCellSize) + (double)((float)roiWidth * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inMaxY - (double)((float)roiY * inCellSize), roiWidth, roiHeight, inCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs(), displacement);
                observers.add(interpolateSplineLinearCsvOutput);
            }
        }
        if (builder.getTileAsciiGridOutputs() != null) {
            for (Map.Entry<Tile, Map<String, String>> entry : builder.getTileAsciiGridOutputs().entrySet()) {
                for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                    void var51_140;
                    Object var51_141 = null;
                    for (Metric metric2 : metrics) {
                        if (!metric2.getName().equalsIgnoreCase(entry2.getKey())) continue;
                        Metric metric3 = metric2;
                        break;
                    }
                    if (var51_140 == null) continue;
                    TileAsciiGridOutput tileAsciiGridOutput = new TileAsciiGridOutput(entry2.getValue(), (Metric)var51_140, entry.getKey(), outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                    observers.add(tileAsciiGridOutput);
                }
            }
        }
        if (builder.getTileGeoTiffOutputs() != null) {
            for (Map.Entry<Tile, Map<String, String>> entry : builder.getTileGeoTiffOutputs().entrySet()) {
                for (Map.Entry<String, String> entry3 : entry.getValue().entrySet()) {
                    void var51_146;
                    Object var51_144 = null;
                    for (Metric metric4 : metrics) {
                        if (!metric4.getName().equalsIgnoreCase(entry3.getKey())) continue;
                        Metric metric5 = metric4;
                        break;
                    }
                    if (var51_146 == null) continue;
                    TileGeoTiffOutput tileGeoTiffOutput = new TileGeoTiffOutput(entry3.getValue(), (Metric)var51_146, entry.getKey(), outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                    observers.add(tileGeoTiffOutput);
                }
            }
        }
        if (builder.getAsciiOutputs(windowSize) != null) {
            for (Map.Entry<String, String> entry : builder.getAsciiOutputs(windowSize).entrySet()) {
                metric = null;
                for (Metric metric6 : metrics) {
                    if (!metric6.getName().equalsIgnoreCase(entry.getKey())) continue;
                    metric = metric6;
                    break;
                }
                if (metric == null) continue;
                if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                    AsciiGridOutput asciiGridOutput = new AsciiGridOutput(entry.getValue(), (Metric)metric, outWidth, outHeight, outMinX, outMinY, outCellSize, coverage.getEntete().noDataValue());
                    observers.add(asciiGridOutput);
                    continue;
                }
                InterpolateSplineLinearAsciiGridOutput interpolateSplineLinearAsciiGridOutput = new InterpolateSplineLinearAsciiGridOutput(entry.getValue(), (Metric)metric, roiWidth, roiHeight, inMinX + (double)((float)roiX * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inCellSize, coverage.getEntete().noDataValue(), displacement);
                observers.add(interpolateSplineLinearAsciiGridOutput);
            }
        }
        if (builder.getAsciiGridFolder() != null) {
            String asciiFolder = builder.getAsciiGridFolder();
            if (!asciiFolder.endsWith("/") && !asciiFolder.endsWith("\\")) {
                asciiFolder = asciiFolder + "/";
            }
            for (Metric metric7 : metrics) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                stringBuffer.append("_" + metric7.getName());
                stringBuffer.append("_" + builder.getWindowSize());
                stringBuffer.append(".asc");
                String string = asciiFolder + stringBuffer.toString();
                if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                    AsciiGridOutput asciiGridOutput = new AsciiGridOutput(string, metric7, outWidth, outHeight, outMinX, outMinY, outCellSize, coverage.getEntete().noDataValue());
                    observers.add(asciiGridOutput);
                    continue;
                }
                InterpolateSplineLinearAsciiGridOutput interpolateSplineLinearAsciiGridOutput = new InterpolateSplineLinearAsciiGridOutput(string, metric7, roiWidth, roiHeight, inMinX + (double)((float)roiX * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inCellSize, coverage.getEntete().noDataValue(), displacement);
                observers.add(interpolateSplineLinearAsciiGridOutput);
            }
        }
        if (builder.getGeoTiffOutputs(windowSize) != null) {
            for (Map.Entry<String, String> entry : builder.getGeoTiffOutputs(windowSize).entrySet()) {
                metric = null;
                for (Metric metric8 : metrics) {
                    if (!metric8.getName().equalsIgnoreCase(entry.getKey())) continue;
                    metric = metric8;
                    break;
                }
                if (metric == null) continue;
                if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                    GeoTiffOutput geoTiffOutput = new GeoTiffOutput(entry.getValue(), (Metric)metric, outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                    observers.add(geoTiffOutput);
                    continue;
                }
                InterpolateSplineGeoTiffOutput interpolateSplineGeoTiffOutput = new InterpolateSplineGeoTiffOutput(entry.getValue(), (Metric)metric, roiWidth, roiHeight, inMinX + (double)((float)roiX * inCellSize), inMaxX - (double)((float)(inWidth - roiX) * inCellSize) + (double)((float)roiWidth * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inMaxY - (double)((float)roiY * inCellSize), inCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs(), displacement);
                observers.add(interpolateSplineGeoTiffOutput);
            }
        }
        if (builder.getGeoTiffFolder() != null) {
            String tifFolder = builder.getGeoTiffFolder();
            if (!tifFolder.endsWith("/") && !tifFolder.endsWith("\\")) {
                tifFolder = tifFolder + "/";
            }
            for (Metric metric9 : metrics) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                stringBuffer.append("_" + metric9.getName());
                stringBuffer.append("_" + builder.getWindowSize());
                stringBuffer.append(".tif");
                String string = tifFolder + stringBuffer.toString();
                if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                    GeoTiffOutput geoTiffOutput = new GeoTiffOutput(string, metric9, outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                    observers.add(geoTiffOutput);
                    continue;
                }
                InterpolateSplineGeoTiffOutput interpolateSplineGeoTiffOutput = new InterpolateSplineGeoTiffOutput(string, metric9, roiWidth, roiHeight, inMinX + (double)((float)roiX * inCellSize), inMaxX - (double)((float)(inWidth - roiX) * inCellSize) + (double)((float)roiWidth * inCellSize), inMinY + (double)((float)(inHeight - roiY) * inCellSize) - (double)((float)roiHeight * inCellSize), inMaxY - (double)((float)roiY * inCellSize), inCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs(), displacement);
                observers.add(interpolateSplineGeoTiffOutput);
            }
        }
        if (builder.getTabOutputs(windowSize) != null) {
            for (Map.Entry<String, float[]> entry : builder.getTabOutputs(windowSize).entrySet()) {
                metric = null;
                for (Metric metric10 : metrics) {
                    if (!metric10.getName().equalsIgnoreCase(entry.getKey())) continue;
                    metric = metric10;
                    break;
                }
                if (metric == null) continue;
                if (builder.getDisplacement() == 1 || !builder.getInterpolation()) {
                    TabOutput tabOutput = new TabOutput(entry.getValue(), (Metric)metric, outWidth, displacement);
                    observers.add(tabOutput);
                    continue;
                }
                InterpolateSplineLinearTabOutput interpolateSplineLinearTabOutput = new InterpolateSplineLinearTabOutput(entry.getValue(), (Metric)metric, roiWidth, displacement, coverage.getEntete().noDataValue());
                observers.add(interpolateSplineLinearTabOutput);
            }
        }
        int[] unfilters = builder.getUnfilters();
        Object var48_71 = null;
        Counting counting = null;
        int n2 = -1;
        if (MetricManager.hasOnlyBasicMetric(metrics)) {
            System.out.println("comptage basique");
            int n3 = 5;
            counting = new BasicCounting(inCellSize, theoreticalSize);
            for (Metric metric11 : metrics) {
                counting.addMetric(metric11);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                void var51_164;
                SlidingFunctionalBasicKernel slidingFunctionalBasicKernel = new SlidingFunctionalBasicKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, inCellSize, function, dMax);
                Object var51_159 = null;
                if (builder.getRasterFile2() != null) {
                    Coverage coverage2 = CoverageManager.getCoverage(builder.getRasterFile2());
                } else if (builder.getRasterTab2() != null) {
                    TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                } else if (builder.getCoverage2() != null) {
                    Coverage coverage3 = builder.getCoverage2();
                } else if (builder.getRasterTabs() != null) {
                    TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
                } else {
                    throw new IllegalArgumentException("no raster2 declared");
                }
                return this.createMultiple(new Coverage[]{coverage, var51_164}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n3, displacement, slidingFunctionalBasicKernel, counting);
            }
            SlidingBasicKernel slidingBasicKernel = new SlidingBasicKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), unfilters);
            return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n3, displacement, slidingBasicKernel, counting);
        }
        if (MetricManager.hasOnlySlopeMetric(metrics)) {
            int n4 = 6;
            SlidingSlopeKernel slidingSlopeKernel = new SlidingSlopeKernel(coverage.getEntete().noDataValue(), inCellSize);
            counting = new SlopeCounting(inCellSize, theoreticalSize);
            for (Metric metric12 : metrics) {
                counting.addMetric(metric12);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n4, displacement, slidingSlopeKernel, counting);
        }
        if (MetricManager.hasOnlyQuantitativeMetric(metrics)) {
            void var48_84;
            int n5 = 8;
            if (metrics.size() == 1 && metrics.iterator().next().getName().equalsIgnoreCase("MD")) {
                SlidingQuantitativeKernel slidingQuantitativeKernel = new SlidingQuantitativeKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), 100.0f, unfilters);
            } else {
                if (metrics.size() == 1 && metrics.iterator().next().getName().equalsIgnoreCase("GBDistance")) {
                    void var48_78;
                    void var51_172;
                    if (builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
                        FastSquareGrainBocagerDistanceBocageKernel fastSquareGrainBocagerDistanceBocageKernel = new FastSquareGrainBocagerDistanceBocageKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, 5.0f, 3.0f, 30.0f);
                    } else {
                        GrainBocagerSlidingDistanceBocageKernel grainBocagerSlidingDistanceBocageKernel = new GrainBocagerSlidingDistanceBocageKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), unfilters, 5.0f, 3.0f, 30.0f);
                    }
                    Object var51_167 = null;
                    if (builder.getRasterFile2() != null) {
                        Coverage coverage4 = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else if (builder.getCoverage2() != null) {
                        Coverage coverage5 = builder.getCoverage2();
                    } else if (builder.getRasterTabs() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster 'type de boisement' declared");
                    }
                    counting = new QuantitativeCounting(inCellSize, theoreticalSize);
                    for (Metric metric13 : metrics) {
                        counting.addMetric(metric13);
                    }
                    for (CountingObserver countingObserver : observers) {
                        counting.addObserver(countingObserver);
                    }
                    return this.createMultiple(new Coverage[]{coverage, var51_172}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n5, displacement, (SlidingLandscapeMetricKernel)var48_78, counting);
                }
                if (metrics.size() == 1 && metrics.iterator().next().getName().equalsIgnoreCase("GBBocage")) {
                    if (builder.getWindowDistanceType() == WindowDistanceType.FAST_GAUSSIAN) {
                        FastGaussianWeightedGrainBocagerDetectionBocageKernel fastGaussianWeightedGrainBocagerDetectionBocageKernel = new FastGaussianWeightedGrainBocagerDetectionBocageKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, 3.0f);
                    } else {
                        GrainBocagerSlidingDetectionBocageKernel grainBocagerSlidingDetectionBocageKernel = new GrainBocagerSlidingDetectionBocageKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), unfilters, 3.0f);
                    }
                } else if (builder.getWindowDistanceType() == WindowDistanceType.FAST_GAUSSIAN) {
                    FastGaussianWeightedQuantitativeKernel fastGaussianWeightedQuantitativeKernel = new FastGaussianWeightedQuantitativeKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters);
                } else if (builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
                    FastSquareQuantitativeKernel fastSquareQuantitativeKernel = new FastSquareQuantitativeKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters);
                } else {
                    SlidingQuantitativeKernel slidingQuantitativeKernel = new SlidingQuantitativeKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), unfilters);
                }
            }
            counting = new QuantitativeCounting(inCellSize, theoreticalSize);
            for (Metric metric14 : metrics) {
                counting.addMetric(metric14);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n5, displacement, (SlidingLandscapeMetricKernel)var48_84, counting);
        }
        if (MetricManager.hasOnlyContinuityMetric(metrics) && builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
            void var51_182;
            int n6 = 6;
            SlidingFunctionalContinuityKernel slidingFunctionalContinuityKernel = new SlidingFunctionalContinuityKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, inCellSize, function, dMax);
            counting = new ContinuityCounting(inCellSize, theoreticalSize);
            for (Metric metric15 : metrics) {
                counting.addMetric(metric15);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            Object var51_177 = null;
            if (builder.getRasterFile2() != null) {
                Coverage coverage6 = CoverageManager.getCoverage(builder.getRasterFile2());
            } else if (builder.getRasterTab2() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
            } else if (builder.getCoverage2() != null) {
                Coverage coverage7 = builder.getCoverage2();
            } else if (builder.getRasterTabs() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
            } else {
                throw new IllegalArgumentException("no raster2 declared");
            }
            return this.createMultiple(new Coverage[]{coverage, var51_182}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n6, displacement, slidingFunctionalContinuityKernel, counting);
        }
        if (MetricManager.hasOnlyDispersalMetric(metrics) && builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
            void var53_247;
            void var52_230;
            void var51_185;
            int n7 = 6;
            Object var51_183 = null;
            Object var52_228 = null;
            Object var53_245 = null;
            if (builder.getTabOutputs(windowSize) != null) {
                float[] fArray = builder.getTabOutputs(windowSize).get("jeunes");
                float[] fArray2 = builder.getTabOutputs(windowSize).get("vieilles");
                float[] fArray3 = builder.getTabOutputs(windowSize).get("meres");
            }
            EnteteRaster enteteRaster = new EnteteRaster(outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, (float)outCellSize, coverage.getEntete().noDataValue());
            SlidingRepartitionDispersionKernel slidingRepartitionDispersionKernel = new SlidingRepartitionDispersionKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, coverage.getEntete(), enteteRaster, (float[])var51_185, (float[])var52_230, (float[])var53_247, function, (float)dMax);
            counting = new ContinuityCounting(inCellSize, theoreticalSize);
            for (Metric metric16 : metrics) {
                counting.addMetric(metric16);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            Object var55_310 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster2 declared");
            }
            TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
            Object var56_345 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster3 declared");
            }
            TabCoverage tabCoverage2 = new TabCoverage(builder.getRasterTabs()[2], coverage.getEntete());
            TabCoverage coverageRugosite = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster4 declared");
            }
            coverageRugosite = new TabCoverage(builder.getRasterTabs()[3], coverage.getEntete());
            TabCoverage coverageQualite = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster5 declared");
            }
            coverageQualite = new TabCoverage(builder.getRasterTabs()[4], coverage.getEntete());
            return this.createMultiple(new Coverage[]{coverage, tabCoverage, tabCoverage2, coverageRugosite, coverageQualite}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n7, displacement, slidingRepartitionDispersionKernel, counting);
        }
        if (MetricManager.hasOnlySourceErosionMetric(metrics)) {
            void var55_320;
            void var54_268;
            void var52_233;
            void var51_188;
            int n8 = 6;
            Object var51_186 = null;
            Object var52_231 = null;
            if (builder.getGeoTiffOutputs(windowSize) != null) {
                String string = builder.getGeoTiffOutputs(windowSize).get("degat-erosion-intensity");
                String string2 = builder.getGeoTiffOutputs(windowSize).get("depot-erosion-intensity");
            }
            EnteteRaster enteteRaster = new EnteteRaster(outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, (float)outCellSize, coverage.getEntete().noDataValue());
            SlidingSourceErosionKernel slidingSourceErosionKernel = new SlidingSourceErosionKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, coverage.getEntete(), enteteRaster, builder.getInterpolation(), (String)var51_188, (String)var52_233);
            counting = new SourceErosionCounting(inCellSize, theoreticalSize);
            for (Metric metric17 : metrics) {
                counting.addMetric(metric17);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            Object var54_263 = null;
            if (builder.getRasterFile2() != null) {
                Coverage coverage8 = CoverageManager.getCoverage(builder.getRasterFile2());
            } else if (builder.getRasterTab2() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
            } else if (builder.getCoverage2() != null) {
                Coverage coverage9 = builder.getCoverage2();
            } else if (builder.getRasterTabs() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
            } else {
                throw new IllegalArgumentException("no raster2 declared");
            }
            Object var55_315 = null;
            if (builder.getRasterFile3() != null) {
                Coverage coverage10 = CoverageManager.getCoverage(builder.getRasterFile3());
            } else if (builder.getRasterTab3() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab3(), coverage.getEntete());
            } else if (builder.getCoverage3() != null) {
                Coverage coverage11 = builder.getCoverage3();
            } else if (builder.getRasterTabs() != null) {
                TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[2], coverage.getEntete());
            } else {
                throw new IllegalArgumentException("no raster3 declared");
            }
            Object var56_347 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster4 declared");
            }
            TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[3], coverage.getEntete());
            return this.createMultiple(new Coverage[]{coverage, var54_268, var55_320, tabCoverage}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n8, displacement, slidingSourceErosionKernel, counting);
        }
        if (MetricManager.hasOnlyDegatErosionMetric(metrics)) {
            void var51_191;
            int n9 = 6;
            Object var51_189 = null;
            Object var52_234 = null;
            if (builder.getGeoTiffOutputs(windowSize) != null) {
                String string = builder.getGeoTiffOutputs(windowSize).get("degat-mass-cumul");
                String string3 = builder.getGeoTiffOutputs(windowSize).get("depot-mass-cumul");
            }
            counting = new DegatErosionCounting(inCellSize, theoreticalSize);
            for (Metric metric18 : metrics) {
                counting.addMetric(metric18);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            EnteteRaster enteteRaster = new EnteteRaster(outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, (float)outCellSize, coverage.getEntete().noDataValue());
            SlidingMassCumulKernel slidingMassCumulKernel = new SlidingMassCumulKernel(windowSize, displacement, coverage.getEntete().noDataValue(), unfilters, coverage.getEntete(), enteteRaster, (String)var51_191);
            Object var54_272 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster2 declared");
            }
            TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
            Object var55_321 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster3 declared");
            }
            TabCoverage tabCoverage3 = new TabCoverage(builder.getRasterTabs()[2], coverage.getEntete());
            Object var56_349 = null;
            if (builder.getRasterTabs() == null) {
                throw new IllegalArgumentException("no raster4 declared");
            }
            TabCoverage tabCoverage4 = new TabCoverage(builder.getRasterTabs()[3], coverage.getEntete());
            return this.createMultiple(new Coverage[]{coverage, tabCoverage, tabCoverage3, tabCoverage4}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n9, displacement, slidingMassCumulKernel, counting);
        }
        int[] nArray2 = builder.getValues();
        if (nArray2 == null) {
            int[] nArray3 = this.readValues(coverage, new Rectangle(roiX, roiY, roiWidth, roiHeight), coverage.getEntete().noDataValue());
        }
        if ((nArray = builder.getFilters()) != null) {
            void var56_357;
            void var56_354;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            if (unfilters != null) {
                void var56_352;
                int[] nArray4 = unfilters;
                int n10 = nArray4.length;
                boolean bl = false;
                while (var56_352 < n10) {
                    int uf = nArray4[var56_352];
                    treeSet.add(uf);
                    ++var56_352;
                }
            }
            void var54_275 = var51_194;
            int n11 = ((void)var54_275).length;
            boolean bl = false;
            while (var56_354 < n11) {
                void v = var54_275[var56_354];
                boolean ok = false;
                for (int f : nArray) {
                    if (v != f) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    treeSet.add((int)v);
                }
                ++var56_354;
            }
            boolean bl2 = false;
            int[] nArray5 = nArray;
            int n12 = nArray5.length;
            for (n = 0; n < n12; ++n) {
                int f = nArray5[n];
                if (coverage.getEntete().noDataValue() == f) {
                    boolean bl3 = true;
                    break;
                }
                if (bl2) continue;
                treeSet.add(coverage.getEntete().noDataValue());
            }
            unfilters = new int[treeSet.size()];
            Iterator iterator = treeSet.iterator();
            boolean bl4 = false;
            while (var56_357 < treeSet.size()) {
                unfilters[var56_357] = (Integer)iterator.next();
                ++var56_357;
            }
        }
        if (MetricManager.hasOnlyQualitativeMetric(metrics)) {
            void var48_103;
            void var53_257;
            for (Metric metric19 : metrics) {
                if (!(metric19 instanceof ThematicDistanceMetric)) continue;
                MetricManager.initThematicDistanceMetric(builder.getThematicDistanceFile(), (ThematicDistanceMetric)((Object)metric19), (int[])var51_194);
            }
            Object var53_255 = null;
            if (MetricManager.hasCoupleMetric(metrics)) {
                float[] fArray = new float[(((void)var51_194).length * ((void)var51_194).length - ((void)var51_194).length) / 2 + ((void)var51_194).length];
                boolean bl = false;
                void var55_327 = var51_194;
                int n13 = ((void)var55_327).length;
                for (n = 0; n < n13; ++n) {
                    void s1 = var55_327[n];
                    fArray[++var54_280] = Couple.getCouple((int)s1, (int)s1);
                }
                for (void s1 : var51_194) {
                    for (int s2 : var51_194) {
                        if (s1 >= s2) continue;
                        fArray[++var54_281] = Couple.getCouple((int)s1, s2);
                    }
                }
            }
            if (MetricManager.hasOnlyValueMetric(metrics)) {
                void var48_93;
                System.out.println("comptage des valeurs");
                int n14 = 5 + ((void)var51_194).length;
                counting = new ValueCounting(inCellSize, (int[])var51_194, theoreticalSize);
                for (Metric metric20 : metrics) {
                    counting.addMetric(metric20);
                }
                for (CountingObserver countingObserver : observers) {
                    counting.addObserver(countingObserver);
                }
                if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                    void var54_289;
                    SlidingFunctionalCountValueKernel slidingFunctionalCountValueKernel = new SlidingFunctionalCountValueKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters, (double)inCellSize, (DistanceFunction)function, dMax);
                    Object var54_284 = null;
                    if (builder.getRasterFile2() != null) {
                        Coverage coverage12 = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else if (builder.getCoverage2() != null) {
                        Coverage coverage13 = builder.getCoverage2();
                    } else if (builder.getRasterTabs() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster2 declared");
                    }
                    return this.createMultiple(new Coverage[]{coverage, var54_289}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n14, displacement, slidingFunctionalCountValueKernel, counting);
                }
                if (builder.getWindowDistanceType() == WindowDistanceType.FAST_GAUSSIAN) {
                    FastGaussianWeightedCountValueKernel fastGaussianWeightedCountValueKernel = new FastGaussianWeightedCountValueKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                } else if (builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
                    FastSquareCountValueKernel fastSquareCountValueKernel = new FastSquareCountValueKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                } else {
                    SlidingCountValueKernel slidingCountValueKernel = new SlidingCountValueKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                }
                return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n14, displacement, (SlidingLandscapeMetricKernel)var48_93, counting);
            }
            if (MetricManager.hasOnlyCoupleMetric(metrics)) {
                void var48_98;
                System.out.println("comptage des couples");
                int n15 = 7 + ((void)var53_257).length;
                counting = new CoupleCounting(inCellSize, ((void)var51_194).length, (float[])var53_257, theoreticalSize, theoreticalCoupleSize);
                for (Metric metric21 : metrics) {
                    counting.addMetric(metric21);
                }
                for (CountingObserver countingObserver : observers) {
                    counting.addObserver(countingObserver);
                }
                if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                    void var54_297;
                    SlidingFunctionalCountCoupleKernel slidingFunctionalCountCoupleKernel = new SlidingFunctionalCountCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters, (double)inCellSize, (DistanceFunction)function, dMax);
                    Object var54_292 = null;
                    if (builder.getRasterFile2() != null) {
                        Coverage coverage14 = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else if (builder.getCoverage2() != null) {
                        Coverage coverage15 = builder.getCoverage2();
                    } else if (builder.getRasterTabs() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster2 declared");
                    }
                    return this.createMultiple(new Coverage[]{coverage, var54_297}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n15, displacement, slidingFunctionalCountCoupleKernel, counting);
                }
                if (builder.getWindowDistanceType() == WindowDistanceType.FAST_GAUSSIAN) {
                    FastGaussianWeightedCountCoupleKernel fastGaussianWeightedCountCoupleKernel = new FastGaussianWeightedCountCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                } else if (builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
                    FastSquareCountCoupleKernel fastSquareCountCoupleKernel = new FastSquareCountCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                } else {
                    SlidingCountCoupleKernel slidingCountCoupleKernel = new SlidingCountCoupleKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
                }
                return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n15, displacement, (SlidingLandscapeMetricKernel)var48_98, counting);
            }
            System.out.println("comptage des valeurs et des couples");
            int n16 = 5 + ((void)var51_194).length + 3 + ((void)var53_257).length;
            counting = new ValueAndCoupleCounting(inCellSize, (int[])var51_194, (float[])var53_257, theoreticalSize, theoreticalCoupleSize);
            for (Metric metric22 : metrics) {
                counting.addMetric(metric22);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                void var54_305;
                SlidingFunctionalCountValueAndCoupleKernel slidingFunctionalCountValueAndCoupleKernel = new SlidingFunctionalCountValueAndCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters, (double)inCellSize, (DistanceFunction)function, dMax);
                Object var54_300 = null;
                if (builder.getRasterFile2() != null) {
                    Coverage coverage16 = CoverageManager.getCoverage(builder.getRasterFile2());
                } else if (builder.getRasterTab2() != null) {
                    TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                } else if (builder.getCoverage2() != null) {
                    Coverage coverage17 = builder.getCoverage2();
                } else if (builder.getRasterTabs() != null) {
                    TabCoverage tabCoverage = new TabCoverage(builder.getRasterTabs()[1], coverage.getEntete());
                } else {
                    throw new IllegalArgumentException("no raster2 declared");
                }
                return this.createMultiple(new Coverage[]{coverage, var54_305}, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n16, displacement, slidingFunctionalCountValueAndCoupleKernel, counting);
            }
            if (builder.getWindowDistanceType() == WindowDistanceType.FAST_GAUSSIAN) {
                FastGaussianWeightedCountValueAndCoupleKernel fastGaussianWeightedCountValueAndCoupleKernel = new FastGaussianWeightedCountValueAndCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
            } else if (builder.getWindowDistanceType() == WindowDistanceType.FAST_SQUARE) {
                FastSquareCountValueAndCoupleKernel fastSquareCountValueAndCoupleKernel = new FastSquareCountValueAndCoupleKernel(windowSize, displacement, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
            } else {
                SlidingCountValueAndCoupleKernel slidingCountValueAndCoupleKernel = new SlidingCountValueAndCoupleKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), (int[])var51_194, unfilters);
            }
            return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n16, displacement, (SlidingLandscapeMetricKernel)var48_103, counting);
        }
        if (MetricManager.hasOnlyPatchMetric(metrics)) {
            System.out.println("comptage des patchs");
            int n17 = 8 + 4 * ((void)var51_194).length;
            SlidingPatchKernel slidingPatchKernel = new SlidingPatchKernel(windowSize, displacement, coeffs, coverage.getEntete().noDataValue(), (int[])var51_194, inCellSize, unfilters);
            counting = new PatchCounting(inCellSize, (int[])var51_194, theoreticalSize);
            for (Metric metric23 : metrics) {
                counting.addMetric(metric23);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, n17, displacement, slidingPatchKernel, counting);
        }
        return null;
    }

    protected abstract int[] readValues(Coverage var1, Rectangle var2, int var3);

    protected abstract SlidingLandscapeMetricAnalysis createSingle(Coverage var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, SlidingLandscapeMetricKernel var12, Counting var13);

    protected abstract SlidingLandscapeMetricAnalysis createMultiple(Coverage[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, SlidingLandscapeMetricKernel var12, Counting var13);
}

