/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.sliding;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.SpatialCsvManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.MultipleLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipleSlidingLandscapeMetricAnalysis
extends MultipleLandscapeMetricAnalysis {
    private Set<Metric> totalMetrics;
    private String totalCsvOutput;
    private String csvFolder;
    private Set<Integer> coherences;
    private Map<String, List<String>> csvOutputs;
    private Map<String, List<String>> suffixMetrics;

    public MultipleSlidingLandscapeMetricAnalysis(LandscapeMetricAnalysisBuilder builder) {
        super(builder);
    }

    @Override
    protected void doInit() {
        try {
            this.totalMetrics = this.builder.getMetrics();
            this.totalCsvOutput = this.builder.getCsv();
            String path = this.csvFolder = this.builder.getCsvFolder();
            if (this.totalCsvOutput != null || this.csvFolder != null) {
                if (path == null) {
                    path = new File(this.totalCsvOutput).getParent();
                }
                this.csvOutputs = new LinkedHashMap<String, List<String>>();
                this.suffixMetrics = new LinkedHashMap<String, List<String>>();
            }
            this.coherences = MetricManager.getCoherences(this.totalMetrics);
            if (this.builder.getRasterFiles().size() <= 1) {
                String rasterFile = this.builder.getRasterFile();
                if (this.totalCsvOutput != null || this.csvFolder != null) {
                    this.csvOutputs.put(rasterFile, new ArrayList());
                    this.suffixMetrics.put(rasterFile, new ArrayList());
                }
                for (int ws : this.builder.getWindowSizes()) {
                    this.builder.setWindowSize(ws);
                    for (int coherence : this.coherences) {
                        HashSet<Metric> metrics = new HashSet<Metric>();
                        metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                        if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                        this.builder.setMetrics(metrics);
                        if (this.totalCsvOutput != null || this.csvFolder != null) {
                            this.builder.addCsvOutput(path + "/sliding_" + coherence + "_" + ws + ".csv");
                            this.csvOutputs.get(rasterFile).add(path + "/sliding_" + coherence + "_" + ws + ".csv");
                            this.suffixMetrics.get(rasterFile).add("_" + ws);
                        }
                        this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                    }
                }
            } else {
                for (String rasterFile : this.builder.getRasterFiles()) {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    this.builder.setRasterFile(rasterFile);
                    if (this.totalCsvOutput != null || this.csvFolder != null) {
                        this.csvOutputs.put(rasterFile, new ArrayList());
                        this.suffixMetrics.put(rasterFile, new ArrayList());
                    }
                    for (int ws : this.builder.getWindowSizes()) {
                        this.builder.setWindowSize(ws);
                        for (int coherence : this.coherences) {
                            HashSet<Metric> metrics = new HashSet<Metric>();
                            metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                            if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                            this.builder.setMetrics(metrics);
                            if (this.totalCsvOutput != null || this.csvFolder != null) {
                                this.builder.addCsvOutput(path + "/" + name + "_sliding_" + coherence + "_" + ws + ".csv");
                                this.csvOutputs.get(rasterFile).add(path + "/" + name + "_sliding_" + coherence + "_" + ws + ".csv");
                                this.suffixMetrics.get(rasterFile).add("_" + ws);
                            }
                            this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        if (this.totalCsvOutput != null || this.csvFolder != null) {
            if (this.builder.getRasterFiles().size() <= 1) {
                String localCsvOutput;
                String rasterFile = this.builder.getRasterFile();
                if (this.totalCsvOutput != null) {
                    localCsvOutput = this.totalCsvOutput;
                } else {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    localCsvOutput = this.csvFolder + name + ".csv";
                }
                EnteteRaster entete = EnteteRaster.read(this.csvOutputs.get(rasterFile).iterator().next().replace(".csv", "_header.txt"));
                SpatialCsvManager.mergeXY(localCsvOutput, this.csvOutputs.get(rasterFile).toArray(new String[this.csvOutputs.get(rasterFile).size()]), this.suffixMetrics.get(rasterFile).toArray(new String[this.suffixMetrics.get(rasterFile).size()]), "X", "Y", entete);
                for (String csvOut : this.csvOutputs.get(rasterFile)) {
                    new File(csvOut).delete();
                    Tool.copy(csvOut.replace(".csv", "_header.txt"), localCsvOutput.replace(".csv", "_header.txt"));
                    new File(csvOut.replace(".csv", "_header.txt")).delete();
                }
            } else {
                HashSet<String> localCsv = new HashSet<String>();
                for (String rasterFile : this.builder.getRasterFiles()) {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    String localCsvOutput = this.totalCsvOutput != null ? this.totalCsvOutput.replace(".csv", "") + "_" + name + ".csv" : this.csvFolder + name + ".csv";
                    EnteteRaster entete = EnteteRaster.read(this.csvOutputs.get(rasterFile).iterator().next().replace(".csv", "_header.txt"));
                    SpatialCsvManager.mergeXY(localCsvOutput, this.csvOutputs.get(rasterFile).toArray(new String[this.csvOutputs.get(rasterFile).size()]), this.suffixMetrics.get(rasterFile).toArray(new String[this.suffixMetrics.get(rasterFile).size()]), "X", "Y", entete);
                    for (String csvOut : this.csvOutputs.get(rasterFile)) {
                        new File(csvOut).delete();
                        Tool.copy(csvOut.replace(".csv", "_header.txt"), localCsvOutput.replace(".csv", "_header.txt"));
                        new File(csvOut.replace(".csv", "_header.txt")).delete();
                    }
                    localCsv.add(localCsvOutput);
                }
            }
        }
        this.totalMetrics = null;
        this.coherences = null;
        this.csvOutputs = null;
    }
}

