/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.sliding;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.SlidingLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.sliding.SlidingLandscapeMetricKernel;
import java.awt.Rectangle;

public class HugeSlidingLandscapeMetricAnalysis
extends SlidingLandscapeMetricAnalysis {
    private int buffer;

    public HugeSlidingLandscapeMetricAnalysis(Coverage coverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, int displacement, SlidingLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, displacement, kernel, counting);
    }

    public HugeSlidingLandscapeMetricAnalysis(Coverage[] coverages, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, int displacement, SlidingLandscapeMetricKernel kernel, Counting counting) {
        super(coverages, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, displacement, kernel, counting);
    }

    @Override
    protected void doInit() {
        LandscapeMetricAnalysis.setTileYSize(LandscapeMetricAnalysis.tileYSize() - LandscapeMetricAnalysis.tileYSize() % this.displacement());
        this.buffer = (short)Math.max(this.displacement(), LandscapeMetricAnalysis.bufferSize());
        this.counting().init();
    }

    @Override
    protected void doRun() {
        int midWindowSize = this.kernel().windowSize() / 2;
        for (int localROIY = this.roiY(); localROIY < this.roiY() + this.roiHeight(); localROIY += LandscapeMetricAnalysis.tileYSize()) {
            int localBufferROIYMin = Math.min(localROIY + this.bufferROIYMin(), midWindowSize);
            int localBufferROIYMax = Math.min(Math.max(this.bufferROIYMax(), this.roiHeight() + this.bufferROIYMax() - (localROIY + LandscapeMetricAnalysis.tileYSize())), midWindowSize);
            int tYs = Math.min(LandscapeMetricAnalysis.tileYSize(), this.roiHeight() + this.roiY() - localROIY);
            this.kernel().setWidth(this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax());
            this.kernel().setHeight(tYs + localBufferROIYMin + localBufferROIYMax);
            this.kernel().setBufferROIXMin(this.bufferROIXMin());
            this.kernel().setBufferROIXMax(this.bufferROIXMax());
            this.kernel().setBufferROIYMin(localBufferROIYMin);
            this.kernel().setBufferROIYMax(localBufferROIYMax);
            Rectangle roi = new Rectangle(this.roiX() - this.bufferROIXMin(), localROIY - localBufferROIYMin, this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax(), tYs + localBufferROIYMin + localBufferROIYMax);
            this.manageInDatas(roi);
            this.kernel().setOutDatas(new double[((this.roiWidth() - 1) / this.displacement() + 1) * ((this.buffer - 1) / this.displacement() + 1)][this.nbValues()]);
            int nextJ = 0;
            for (int b = 0; b < tYs; b += this.buffer) {
                this.kernel().applySlidingWindow(b, Math.min(this.buffer, tYs - b));
                int index = 0;
                for (int j = nextJ % this.buffer; j < Math.min(this.buffer, tYs - b); j += this.displacement()) {
                    nextJ += this.displacement();
                    for (int i = 0; i < this.roiWidth(); i += this.displacement()) {
                        this.counting().setCounts(this.kernel().outDatas()[index]);
                        this.counting().calculate();
                        this.counting().export(i, localROIY + j + b);
                        ++index;
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        LandscapeMetricAnalysis.setTileYSize(1000);
        for (int i = 0; i < this.coverages().length; ++i) {
            this.coverages()[i].dispose();
        }
    }

    @Override
    protected void manageInDatas(Rectangle roi) {
        float[][] inDatas = new float[this.coverages().length][];
        for (int i = 0; i < this.coverages().length; ++i) {
            inDatas[i] = this.coverages()[i].getData(roi);
        }
        this.kernel().setInDatas(inDatas);
    }
}

