/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.selected;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.analysis.selected.SelectedLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Set;

public class TinySelectedLandscapeMetricAnalysis
extends SelectedLandscapeMetricAnalysis {
    public TinySelectedLandscapeMetricAnalysis(Coverage coverage, Set<Pixel> pixels, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, SelectedLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    public TinySelectedLandscapeMetricAnalysis(Coverage[] coverages, Set<Pixel> pixels, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, SelectedLandscapeMetricKernel kernel, Counting counting) {
        super(coverages, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        this.kernel().setWidth(this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax());
        this.kernel().setHeight(this.roiHeight() + this.bufferROIYMin() + this.bufferROIYMax());
        this.kernel().setBufferROIXMin(this.bufferROIXMin());
        this.kernel().setBufferROIXMax(this.bufferROIXMax());
        this.kernel().setBufferROIYMin(this.bufferROIYMin());
        this.kernel().setBufferROIYMax(this.bufferROIYMax());
        Rectangle roi = new Rectangle(this.roiX() - this.bufferROIXMin(), this.roiY() - this.bufferROIYMin(), this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax(), this.roiHeight() + this.bufferROIYMin() + this.bufferROIYMax());
        this.manageInDatas(roi);
        HashMap<Pixel, double[]> outDatas = new HashMap<Pixel, double[]>();
        for (Pixel p : this.pixels()) {
            outDatas.put(p, new double[this.nbValues()]);
        }
        this.kernel().setOutDatas(outDatas);
        this.counting().init();
    }

    @Override
    protected void doRun() {
        this.kernel().applySelectedWindow(this.roiHeight(), 0);
        for (Pixel p : this.pixels()) {
            this.counting().setCounts(this.kernel().outDatas().get(p));
            this.counting().calculate();
            this.counting().export(p);
        }
    }

    @Override
    protected void manageInDatas(Rectangle roi) {
        float[][] inDatas = new float[this.coverages().length][];
        for (int i = 0; i < this.coverages().length; ++i) {
            inDatas[i] = this.coverages()[i].getData(roi);
            this.coverages()[i].dispose();
        }
        this.kernel().setInDatas(inDatas);
    }
}

