/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.selected;

import fr.inrae.act.bagap.apiland.analysis.combination.CombinationExpressionFactory;
import fr.inrae.act.bagap.apiland.analysis.distance.CombinationExpressionDistanceFunction;
import fr.inrae.act.bagap.apiland.analysis.distance.DistanceFunction;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.selected.SelectedLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.BasicCounting;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.PatchCounting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueAndCoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCounting;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedBasicKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedPatchKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.functional.SelectedFunctionalCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.functional.SelectedFunctionalCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.functional.SelectedFunctionalCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.selected.grainbocager.GrainBocagerSelectedDistanceBocageKernel;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.output.SelectedCsvOutput;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class SelectedLandscapeMetricAnalysisFactory {
    /*
     * WARNING - void declaration
     */
    public SelectedLandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder, Coverage coverage) throws IOException {
        int roiHeight;
        int inWidth = coverage.width();
        int inHeight = coverage.height();
        double inCellSize = coverage.cellsize();
        int roiX = builder.getROIX();
        int roiY = builder.getROIY();
        int roiWidth = builder.getROIWidth();
        if (roiWidth == -1) {
            roiWidth = inWidth - roiX;
        }
        if ((roiHeight = builder.getROIHeight()) == -1) {
            roiHeight = inHeight - roiY;
        }
        int windowSize = -1;
        if (builder.getWindowSize() > 0) {
            windowSize = builder.getWindowSize();
        } else if (builder.getWindowRadius() > 0.0) {
            double v = 2.0 * builder.getWindowRadius() / inCellSize;
            windowSize = v % 2.0 == 0.0 ? new Double(v + 1.0).intValue() : new Double(v).intValue();
        } else {
            throw new IllegalArgumentException("windowSize must be defined");
        }
        int midWindowSize = windowSize / 2;
        int bufferROIXMin = Math.min(roiX, midWindowSize);
        int bufferROIXMax = Math.min(inWidth - (roiX + roiWidth), midWindowSize);
        int bufferROIYMin = Math.min(roiY, midWindowSize);
        int bufferROIYMax = Math.min(inHeight - (roiY + roiHeight), midWindowSize);
        float[] coeffs = new float[windowSize * windowSize];
        double dMax = builder.getDMax();
        if (dMax == -1.0) {
            dMax = (double)midWindowSize * inCellSize;
        }
        CombinationExpressionDistanceFunction function = null;
        if (builder.getWindowDistanceType() == WindowDistanceType.WEIGHTED) {
            function = CombinationExpressionFactory.createDistanceFunction(builder.getWindowDistanceFunction(), dMax);
        }
        float theoreticalSize = 0.0f;
        int theoreticalCoupleSize = 0;
        if (builder.getWindowShapeType() == WindowShapeType.SQUARE) {
            theoreticalSize = windowSize * windowSize;
            theoreticalCoupleSize = (windowSize - 1) * windowSize * 2;
            for (int s = 0; s < windowSize * windowSize; ++s) {
                coeffs[s] = 1.0f;
            }
        } else if (builder.getWindowShapeType() == WindowShapeType.CIRCLE) {
            for (int j = 0; j < windowSize; ++j) {
                for (int i = 0; i < windowSize; ++i) {
                    if (!(Util.distance(midWindowSize, midWindowSize, i, j) <= (double)midWindowSize)) continue;
                    if (j > 0 && Util.distance(midWindowSize, midWindowSize, i, j - 1) <= (double)midWindowSize) {
                        ++theoreticalCoupleSize;
                    }
                    if (i > 0 && Util.distance(midWindowSize, midWindowSize, i - 1, j) <= (double)midWindowSize) {
                        ++theoreticalCoupleSize;
                    }
                    if (builder.getWindowDistanceType() == WindowDistanceType.WEIGHTED) {
                        float d = (float)function.interprete(Util.distance(midWindowSize, midWindowSize, i, j) * inCellSize);
                        theoreticalSize += d;
                        coeffs[j * windowSize + i] = d;
                        continue;
                    }
                    if (builder.getWindowDistanceType() != WindowDistanceType.THRESHOLD) continue;
                    theoreticalSize += 1.0f;
                    coeffs[j * windowSize + i] = 1.0f;
                }
            }
        }
        Set<Metric> metrics = builder.getMetrics();
        Set<Pixel> pixels = null;
        if (builder.getRefPixels() != null) {
            pixels = builder.getRefPixels();
        } else if (builder.getPixelsFilter() != null) {
            pixels = CoordinateManager.initWithPixels(builder.getPixelsFilter());
            builder.setPixelsFilter(pixels);
        } else {
            if (builder.getRefPoints() != null) {
                throw new IllegalArgumentException();
            }
            pixels = CoordinateManager.initWithPoints(builder.getPointsFilter(), coverage.getEntete());
            builder.setPixelsFilter(pixels);
        }
        HashSet<SelectedCsvOutput> observers = new HashSet<SelectedCsvOutput>();
        if (builder.getCsv() != null) {
            SelectedCsvOutput csvOutput = new SelectedCsvOutput(builder.getCsv(), pixels, coverage.getEntete());
            observers.add(csvOutput);
        } else if (builder.getCsvFolder() != null) {
            String name = builder.getCsvFolder() + new File(builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "").toString() + ".csv";
            SelectedCsvOutput csvOutput = new SelectedCsvOutput(name, pixels, coverage.getEntete());
            observers.add(csvOutput);
        }
        SelectedLandscapeMetricKernel kernel = null;
        Counting counting = null;
        int nbValues = -1;
        if (MetricManager.hasOnlyBasicMetric(metrics)) {
            nbValues = 5;
            kernel = new SelectedBasicKernel(windowSize, pixels, coeffs, coverage.getEntete(), builder.getWindowsPath());
            counting = new BasicCounting(inCellSize, theoreticalSize);
            for (Metric metric : metrics) {
                counting.addMetric(metric);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
        }
        if (MetricManager.hasOnlyQuantitativeMetric(metrics)) {
            nbValues = 8;
            if (metrics.size() == 1 && metrics.iterator().next().getName().equalsIgnoreCase("MD")) {
                kernel = new SelectedQuantitativeKernel(windowSize, pixels, coeffs, coverage.getEntete(), builder.getWindowsPath(), 100.0f);
            } else {
                if (metrics.size() == 1 && metrics.iterator().next().getName().equalsIgnoreCase("GBDistance")) {
                    kernel = new GrainBocagerSelectedDistanceBocageKernel(windowSize, pixels, coeffs, coverage.getEntete(), builder.getWindowsPath(), 3.0f, 30.0f);
                    Coverage coverageBocage = null;
                    if (builder.getRasterFile2() != null) {
                        coverageBocage = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        coverageBocage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster 'type de boisement' declared");
                    }
                    counting = new QuantitativeCounting(theoreticalSize);
                    for (Metric metric : metrics) {
                        counting.addMetric(metric);
                    }
                    for (CountingObserver countingObserver : observers) {
                        counting.addObserver(countingObserver);
                    }
                    return this.createMultiple(new Coverage[]{coverage, coverageBocage}, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
                }
                kernel = new SelectedQuantitativeKernel(windowSize, pixels, coeffs, coverage.getEntete(), builder.getWindowsPath());
            }
            counting = new QuantitativeCounting(theoreticalSize);
            for (Metric metric : metrics) {
                counting.addMetric(metric);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
        }
        int[] values = builder.getValues();
        if (values == null) {
            values = this.readValues(coverage, new Rectangle(roiX, roiY, roiWidth, roiHeight), coverage.getEntete().noDataValue());
        }
        if (MetricManager.hasOnlyQualitativeMetric(metrics)) {
            void var30_46;
            Object var30_44 = null;
            if (MetricManager.hasCoupleMetric(metrics)) {
                float[] fArray = new float[(values.length * values.length - values.length) / 2 + values.length];
                boolean bl = false;
                for (int s1 : values) {
                    fArray[++var31_53] = Couple.getCouple(s1, s1);
                }
                for (int s1 : values) {
                    for (int s2 : values) {
                        if (s1 >= s2) continue;
                        fArray[++var31_54] = Couple.getCouple(s1, s2);
                    }
                }
            }
            if (MetricManager.hasOnlyValueMetric(metrics)) {
                System.out.println("comptage des valeurs");
                nbValues = 5 + values.length;
                counting = new ValueCounting(inCellSize, values, theoreticalSize);
                for (Metric metric : metrics) {
                    counting.addMetric(metric);
                }
                for (CountingObserver countingObserver : observers) {
                    counting.addObserver(countingObserver);
                }
                if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                    void var31_60;
                    kernel = new SelectedFunctionalCountValueKernel(windowSize, pixels, coverage.getEntete(), values, (DistanceFunction)function, dMax, builder.getWindowsPath());
                    Object var31_57 = null;
                    if (builder.getRasterFile2() != null) {
                        Coverage coverage2 = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster2 declared");
                    }
                    return this.createMultiple(new Coverage[]{coverage, var31_60}, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
                }
                kernel = new SelectedCountValueKernel(windowSize, pixels, coeffs, coverage.getEntete(), values, builder.getWindowsPath());
                return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
            }
            if (MetricManager.hasOnlyCoupleMetric(metrics)) {
                System.out.println("comptage des couples");
                nbValues = 7 + ((void)var30_46).length;
                counting = new CoupleCounting(inCellSize, values.length, (float[])var30_46, theoreticalSize, theoreticalCoupleSize);
                for (Metric metric : metrics) {
                    counting.addMetric(metric);
                }
                for (CountingObserver countingObserver : observers) {
                    counting.addObserver(countingObserver);
                }
                if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                    void var31_66;
                    kernel = new SelectedFunctionalCountCoupleKernel(windowSize, pixels, coverage.getEntete(), values, (DistanceFunction)function, dMax, builder.getWindowsPath());
                    Object var31_63 = null;
                    if (builder.getRasterFile2() != null) {
                        Coverage coverage3 = CoverageManager.getCoverage(builder.getRasterFile2());
                    } else if (builder.getRasterTab2() != null) {
                        TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                    } else {
                        throw new IllegalArgumentException("no raster2 declared");
                    }
                    return this.createMultiple(new Coverage[]{coverage, var31_66}, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
                }
                kernel = new SelectedCountCoupleKernel(windowSize, pixels, coeffs, coverage.getEntete(), values, builder.getWindowsPath());
                return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
            }
            System.out.println("comptage des valeurs et des couples");
            nbValues = 5 + values.length + 3 + ((void)var30_46).length;
            counting = new ValueAndCoupleCounting(inCellSize, values, (float[])var30_46, theoreticalSize, theoreticalCoupleSize);
            for (Metric metric : metrics) {
                counting.addMetric(metric);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            if (builder.getWindowShapeType() == WindowShapeType.FUNCTIONAL) {
                void var31_72;
                kernel = new SelectedFunctionalCountValueAndCoupleKernel(windowSize, pixels, coverage.getEntete(), values, (DistanceFunction)function, dMax, builder.getWindowsPath());
                Object var31_69 = null;
                if (builder.getRasterFile2() != null) {
                    Coverage coverage4 = CoverageManager.getCoverage(builder.getRasterFile2());
                } else if (builder.getRasterTab2() != null) {
                    TabCoverage tabCoverage = new TabCoverage(builder.getRasterTab2(), coverage.getEntete());
                } else {
                    throw new IllegalArgumentException("no raster2 declared");
                }
                return this.createMultiple(new Coverage[]{coverage, var31_72}, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
            }
            kernel = new SelectedCountValueAndCoupleKernel(windowSize, pixels, coeffs, coverage.getEntete(), values, builder.getWindowsPath());
            return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
        }
        if (MetricManager.hasOnlyPatchMetric(metrics)) {
            nbValues = 8 + 4 * values.length;
            kernel = new SelectedPatchKernel(windowSize, pixels, coeffs, coverage.getEntete(), values, builder.getWindowsPath());
            counting = new PatchCounting(inCellSize, values, theoreticalSize);
            for (Metric metric : metrics) {
                counting.addMetric(metric);
            }
            for (CountingObserver countingObserver : observers) {
                counting.addObserver(countingObserver);
            }
            return this.createSingle(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
        }
        return null;
    }

    protected abstract int[] readValues(Coverage var1, Rectangle var2, int var3);

    protected abstract SelectedLandscapeMetricAnalysis createSingle(Coverage var1, Set<Pixel> var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, SelectedLandscapeMetricKernel var12, Counting var13);

    protected abstract SelectedLandscapeMetricAnalysis createMultiple(Coverage[] var1, Set<Pixel> var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, SelectedLandscapeMetricKernel var12, Counting var13);
}

