/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.selected;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.selected.SelectedLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.selected.SelectedLandscapeMetricKernel;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Set;

public class HugeSelectedLandscapeMetricAnalysis
extends SelectedLandscapeMetricAnalysis {
    public HugeSelectedLandscapeMetricAnalysis(Coverage coverage, Set<Pixel> pixels, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, SelectedLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    public HugeSelectedLandscapeMetricAnalysis(Coverage[] coverages, Set<Pixel> pixels, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, SelectedLandscapeMetricKernel kernel, Counting counting) {
        super(coverages, pixels, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        HashMap<Pixel, double[]> outDatas = new HashMap<Pixel, double[]>();
        for (Pixel p : this.pixels()) {
            outDatas.put(p, new double[this.nbValues()]);
        }
        this.kernel().setOutDatas(outDatas);
        this.counting().init();
    }

    @Override
    protected void doRun() {
        int midWindowSize = this.kernel().windowSize() / 2;
        for (int localROIY = this.roiY(); localROIY < this.roiY() + this.roiHeight(); localROIY += LandscapeMetricAnalysis.tileYSize()) {
            int localBufferROIYMin = Math.min(localROIY + this.bufferROIYMin(), midWindowSize);
            int localBufferROIYMax = Math.min(Math.max(this.bufferROIYMax(), this.roiHeight() + this.bufferROIYMax() - (localROIY + LandscapeMetricAnalysis.tileYSize())), midWindowSize);
            int tYs = Math.min(LandscapeMetricAnalysis.tileYSize(), this.roiHeight() + this.roiY() - localROIY);
            this.kernel().setWidth(this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax());
            this.kernel().setHeight(tYs + localBufferROIYMin + localBufferROIYMax);
            this.kernel().setBufferROIXMin(this.bufferROIXMin());
            this.kernel().setBufferROIXMax(this.bufferROIXMax());
            this.kernel().setBufferROIYMin(localBufferROIYMin);
            this.kernel().setBufferROIYMax(localBufferROIYMax);
            Rectangle roi = new Rectangle(this.roiX() - this.bufferROIXMin(), localROIY - localBufferROIYMin, this.roiWidth() + this.bufferROIXMin() + this.bufferROIXMax(), tYs + localBufferROIYMin + localBufferROIYMax);
            this.manageInDatas(roi);
            this.kernel().applySelectedWindow(tYs, localROIY);
        }
        for (Pixel p : this.pixels()) {
            this.counting().setCounts(this.kernel().outDatas().get(p));
            this.counting().calculate();
            this.counting().export(p);
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        for (int i = 0; i < this.coverages().length; ++i) {
            this.coverages()[i].dispose();
        }
    }

    @Override
    protected void manageInDatas(Rectangle roi) {
        float[][] inDatas = new float[this.coverages().length][];
        for (int i = 0; i < this.coverages().length; ++i) {
            inDatas[i] = this.coverages()[i].getData(roi);
        }
        this.kernel().setInDatas(inDatas);
    }
}

