/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.map;

import fr.inrae.act.bagap.apiland.util.SpatialCsvManager;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.MultipleLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultipleMapLandscapeMetricAnalysis
extends MultipleLandscapeMetricAnalysis {
    private Set<Metric> totalMetrics;
    private String totalCsvOutput;
    private String csvFolder;
    private Set<Integer> coherences;
    private List<String> csvOutputs;

    public MultipleMapLandscapeMetricAnalysis(LandscapeMetricAnalysisBuilder builder) {
        super(builder);
    }

    @Override
    protected void doInit() {
        try {
            this.totalMetrics = this.builder.getMetrics();
            this.totalCsvOutput = this.builder.getCsv();
            String path = this.csvFolder = this.builder.getCsvFolder();
            if (this.totalCsvOutput != null || this.csvFolder != null) {
                if (path == null) {
                    path = new File(this.totalCsvOutput).getParent();
                }
                this.csvOutputs = new ArrayList<String>();
            }
            this.coherences = MetricManager.getCoherences(this.totalMetrics);
            if (this.builder.getRasterFiles().size() <= 1) {
                for (int coherence : this.coherences) {
                    HashSet<Metric> metrics = new HashSet<Metric>();
                    metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                    if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                    this.builder.setMetrics(metrics);
                    if (this.totalCsvOutput != null || this.csvFolder != null) {
                        this.builder.addCsvOutput(path + "/map_" + coherence + ".csv");
                        this.csvOutputs.add(path + "/map_" + coherence + ".csv");
                    }
                    this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                }
            } else {
                for (String rasterFile : this.builder.getRasterFiles()) {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    this.builder.setRasterFile(rasterFile);
                    for (int coherence : this.coherences) {
                        HashSet<Metric> metrics = new HashSet<Metric>();
                        metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                        if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                        this.builder.setMetrics(metrics);
                        if (this.totalCsvOutput != null || this.csvFolder != null) {
                            this.builder.addCsvOutput(path + "/" + name + "_map_" + coherence + ".csv");
                            this.csvOutputs.add(path + "/" + name + "_map_" + coherence + ".csv");
                        }
                        this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        String localCsvOutput;
        if (this.totalCsvOutput != null) {
            localCsvOutput = this.totalCsvOutput;
        } else if (this.builder.getRasterFiles().size() == 1) {
            String name = new File(this.builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "");
            localCsvOutput = this.csvFolder + name + ".csv";
        } else {
            localCsvOutput = this.csvFolder + "map.csv";
        }
        SpatialCsvManager.merge(localCsvOutput, this.csvOutputs.toArray(new String[this.csvOutputs.size()]));
        for (String csvOut : this.csvOutputs) {
            new File(csvOut).delete();
        }
        this.totalMetrics = null;
        this.coherences = null;
        this.csvOutputs = null;
    }
}

