/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.map;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.map.MapLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.PatchCounting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueAndCoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCounting;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapLandscapeMetricKernel;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapPatchKernel;
import fr.inrae.act.bagap.chloe.window.kernel.map.MapQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.output.MapCsvOutput;
import fr.inrae.act.bagap.chloe.window.output.MapDataOutput;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class MapLandscapeMetricAnalysisFactory {
    public MapLandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder, Coverage coverage) throws IOException {
        String name;
        int roiHeight;
        int inWidth = coverage.width();
        int inHeight = coverage.height();
        double inCellSize = coverage.cellsize();
        int roiX = builder.getROIX();
        int roiY = builder.getROIY();
        int roiWidth = builder.getROIWidth();
        if (roiWidth == -1) {
            roiWidth = inWidth;
        }
        if ((roiHeight = builder.getROIHeight()) == -1) {
            roiHeight = inHeight;
        }
        int bufferROIXMin = 0;
        int bufferROIXMax = 0;
        int bufferROIYMin = 0;
        int bufferROIYMax = 0;
        double theoreticalSize = 0.0;
        double theoreticalCoupleSize = 0.0;
        for (int j = 0; j < roiHeight; ++j) {
            for (int i = 0; i < roiWidth; ++i) {
                theoreticalSize += 1.0;
                if (j > 0) {
                    theoreticalCoupleSize += 1.0;
                }
                if (i <= 0) continue;
                theoreticalCoupleSize += 1.0;
            }
        }
        Set<Metric> metrics = builder.getMetrics();
        HashSet<CountingObserver> observers = new HashSet<CountingObserver>();
        if (builder.getCsv() != null) {
            name = new File(builder.getRasterFile()).getName();
            MapCsvOutput csvOutput = new MapCsvOutput(builder.getCsv(), name);
            observers.add(csvOutput);
        } else if (builder.getCsvFolder() != null) {
            name = new File(builder.getRasterFile()).getName();
            String csvName = builder.getCsvFolder() + new File(builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "").toString() + ".csv";
            MapCsvOutput csvOutput = new MapCsvOutput(csvName, name);
            observers.add(csvOutput);
        }
        if (builder.getMapDataOutput() != null) {
            MapDataOutput dataOutput = new MapDataOutput(builder.getMapDataOutput());
            observers.add(dataOutput);
        }
        MapLandscapeMetricKernel kernel = null;
        Counting counting = null;
        int nbValues = -1;
        if (MetricManager.hasOnlyQuantitativeMetric(metrics)) {
            nbValues = 8;
            kernel = new MapQuantitativeKernel(Raster.getNoDataValue());
            counting = new QuantitativeCounting(theoreticalSize);
        } else {
            int[] values = builder.getValues();
            if (values == null) {
                values = this.readValues(coverage, new Rectangle(roiX, roiY, roiWidth, roiHeight), coverage.getEntete().noDataValue());
            }
            if (MetricManager.hasOnlyQualitativeMetric(metrics)) {
                float[] couples = null;
                if (MetricManager.hasCoupleMetric(metrics)) {
                    couples = new float[(values.length * values.length - values.length) / 2 + values.length];
                    int index = 0;
                    for (int s1 : values) {
                        couples[index++] = Couple.getCouple(s1, s1);
                    }
                    for (int s1 : values) {
                        for (int s2 : values) {
                            if (s1 >= s2) continue;
                            couples[index++] = Couple.getCouple(s1, s2);
                        }
                    }
                }
                if (MetricManager.hasOnlyValueMetric(metrics)) {
                    System.out.println("comptage des valeurs");
                    nbValues = 5 + values.length;
                    kernel = new MapCountValueKernel(Raster.getNoDataValue(), values);
                    counting = new ValueCounting(inCellSize, values, theoreticalSize);
                } else if (MetricManager.hasOnlyCoupleMetric(metrics)) {
                    System.out.println("comptage des couples");
                    nbValues = 7 + couples.length;
                    kernel = new MapCountCoupleKernel(Raster.getNoDataValue(), values);
                    counting = new CoupleCounting(inCellSize, values.length, couples, theoreticalSize, theoreticalCoupleSize);
                } else {
                    System.out.println("comptage des valeurs et des couples");
                    nbValues = 5 + values.length + 3 + couples.length;
                    kernel = new MapCountValueAndCoupleKernel(Raster.getNoDataValue(), values);
                    counting = new ValueAndCoupleCounting(inCellSize, values, couples, theoreticalSize, theoreticalCoupleSize);
                }
            } else if (MetricManager.hasOnlyPatchMetric(metrics)) {
                System.out.println("comptage des patchs");
                nbValues = 8 + 4 * values.length;
                kernel = new MapPatchKernel(Raster.getNoDataValue(), values, inCellSize);
                counting = new PatchCounting(inCellSize, values, theoreticalSize);
            }
        }
        for (Metric m : metrics) {
            counting.addMetric(m);
        }
        for (CountingObserver co : observers) {
            counting.addObserver(co);
        }
        return this.create(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    protected abstract int[] readValues(Coverage var1, Rectangle var2, int var3);

    protected abstract MapLandscapeMetricAnalysis create(Coverage var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, MapLandscapeMetricKernel var11, Counting var12);
}

