/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.grid;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.chloe.window.analysis.grid.GridLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;
import java.awt.Rectangle;

public class TinyGridLandscapeMetricAnalysis
extends GridLandscapeMetricAnalysis {
    private int buffer;
    private int gridWidth;

    public TinyGridLandscapeMetricAnalysis(Coverage coverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, GridLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        this.kernel().setWidth(this.roiWidth());
        this.kernel().setHeight(this.roiHeight());
        this.kernel().setBufferROIXMin(this.bufferROIXMin());
        this.kernel().setBufferROIXMax(this.bufferROIXMax());
        this.kernel().setBufferROIYMin(this.bufferROIYMin());
        this.kernel().setBufferROIYMax(this.bufferROIYMax());
        Rectangle roi = new Rectangle(this.roiX(), this.roiY(), this.roiWidth(), this.roiHeight());
        this.kernel().setInDatas(this.coverage().getData(roi));
        this.coverage().dispose();
        this.buffer = this.kernel().gridSize();
        this.gridWidth = this.roiWidth() % this.kernel().gridSize() == 0 ? this.roiWidth() / this.kernel().gridSize() : this.roiWidth() / this.kernel().gridSize() + 1;
        this.kernel().setOutDatas(new double[this.gridWidth][this.nbValues()]);
        this.counting().init();
    }

    @Override
    protected void doRun() {
        int yGrid = 0;
        int b = 0;
        while (b < this.roiHeight()) {
            this.kernel().applyGridWindow(this.gridWidth, b);
            for (int xGrid = 0; xGrid < this.gridWidth; ++xGrid) {
                this.counting().setCounts(this.kernel().outDatas()[xGrid]);
                this.counting().calculate();
                this.counting().export(xGrid, yGrid);
            }
            b += this.buffer;
            ++yGrid;
        }
    }
}

