/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.grid;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.SpatialCsvManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.MultipleLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultipleGridLandscapeMetricAnalysis
extends MultipleLandscapeMetricAnalysis {
    private Set<Metric> totalMetrics;
    private String totalCsvOutput;
    private String csvFolder;
    private Set<Integer> coherences;
    private Map<String, Map<Integer, List<String>>> csvOutputs;
    private Map<String, Map<Integer, List<String>>> suffixMetrics;

    public MultipleGridLandscapeMetricAnalysis(LandscapeMetricAnalysisBuilder builder) {
        super(builder);
    }

    @Override
    protected void doInit() {
        try {
            this.totalMetrics = this.builder.getMetrics();
            this.totalCsvOutput = this.builder.getCsv();
            String path = this.csvFolder = this.builder.getCsvFolder();
            if (this.totalCsvOutput != null || this.csvFolder != null) {
                if (path == null) {
                    path = new File(this.totalCsvOutput).getParent();
                }
                this.csvOutputs = new LinkedHashMap<String, Map<Integer, List<String>>>();
                this.suffixMetrics = new LinkedHashMap<String, Map<Integer, List<String>>>();
            }
            this.coherences = MetricManager.getCoherences(this.totalMetrics);
            if (this.builder.getRasterFiles().size() <= 1) {
                String rasterFile = this.builder.getRasterFile();
                if (this.totalCsvOutput != null || this.csvFolder != null) {
                    this.csvOutputs.put(rasterFile, new TreeMap());
                    this.suffixMetrics.put(rasterFile, new TreeMap());
                }
                for (int ws : this.builder.getWindowSizes()) {
                    this.builder.setWindowSize(ws);
                    if (this.totalCsvOutput != null || this.csvFolder != null) {
                        this.csvOutputs.get(rasterFile).put(ws, new ArrayList());
                        this.suffixMetrics.get(rasterFile).put(ws, new ArrayList());
                    }
                    for (int coherence : this.coherences) {
                        HashSet<Metric> metrics = new HashSet<Metric>();
                        metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                        if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                        this.builder.setMetrics(metrics);
                        if (this.totalCsvOutput != null || this.csvFolder != null) {
                            this.builder.addCsvOutput(path + "/grid_" + coherence + "_" + ws + ".csv");
                            this.csvOutputs.get(rasterFile).get(ws).add(path + "/grid_" + coherence + "_" + ws + ".csv");
                            this.suffixMetrics.get(rasterFile).get(ws).add("_" + ws);
                        }
                        this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                    }
                }
            } else {
                for (String rasterFile : this.builder.getRasterFiles()) {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    this.builder.setRasterFile(rasterFile);
                    if (this.totalCsvOutput != null || this.csvFolder != null) {
                        this.csvOutputs.put(rasterFile, new TreeMap());
                        this.suffixMetrics.put(rasterFile, new TreeMap());
                    }
                    for (int ws : this.builder.getWindowSizes()) {
                        this.builder.setWindowSize(ws);
                        if (this.totalCsvOutput != null || this.csvFolder != null) {
                            this.csvOutputs.get(rasterFile).put(ws, new ArrayList());
                            this.suffixMetrics.get(rasterFile).put(ws, new ArrayList());
                        }
                        for (int coherence : this.coherences) {
                            HashSet<Metric> metrics = new HashSet<Metric>();
                            metrics.addAll(MetricManager.getMetricsByCoherence(this.totalMetrics, coherence));
                            if (!MetricManager.hasOnlyBasicMetric(metrics) && coherence == 0) continue;
                            this.builder.setMetrics(metrics);
                            if (this.totalCsvOutput != null || this.csvFolder != null) {
                                this.builder.addCsvOutput(path + "/" + name + "_grid_" + coherence + "_" + ws + ".csv");
                                this.csvOutputs.get(rasterFile).get(ws).add(path + "/" + name + "_grid_" + coherence + "_" + ws + ".csv");
                                this.suffixMetrics.get(rasterFile).get(ws).add("_" + ws);
                            }
                            this.add(LandscapeMetricAnalysisFactory.create(this.builder));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        if (this.totalCsvOutput != null || this.csvFolder != null) {
            if (this.builder.getRasterFiles().size() <= 1) {
                String rasterFile = this.builder.getRasterFile();
                for (int ws : this.builder.getWindowSizes()) {
                    String localCsvOutput;
                    EnteteRaster entete = EnteteRaster.read(this.csvOutputs.get(rasterFile).get(ws).iterator().next().replace(".csv", "_header.txt"));
                    if (this.totalCsvOutput != null) {
                        localCsvOutput = this.builder.getWindowSizes().size() == 1 ? this.totalCsvOutput : this.totalCsvOutput.replace(".csv", "") + "_" + ws + ".csv";
                    } else {
                        String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                        localCsvOutput = this.csvFolder + (String)name + "_" + ws + ".csv";
                    }
                    SpatialCsvManager.mergeXY(localCsvOutput, this.getCsvOutputs(rasterFile, ws), this.getSuffixMetrics(rasterFile, ws), "X", "Y", entete);
                    for (String csvOut : this.csvOutputs.get(rasterFile).get(ws)) {
                        new File(csvOut).delete();
                        Tool.copy(csvOut.replace(".csv", "_header.txt"), localCsvOutput.replace(".csv", "_header.txt"));
                        new File(csvOut.replace(".csv", "_header.txt")).delete();
                    }
                }
            } else {
                for (String rasterFile : this.builder.getRasterFiles()) {
                    String name = new File(rasterFile).getName().replace(".tif", "").replace(".asc", "");
                    for (int ws : this.builder.getWindowSizes()) {
                        EnteteRaster entete = EnteteRaster.read(this.csvOutputs.get(rasterFile).get(ws).iterator().next().replace(".csv", "_header.txt"));
                        String localCsvOutput = this.totalCsvOutput != null ? this.totalCsvOutput.replace(".csv", "") + "_" + name + "_" + ws + ".csv" : this.csvFolder + name + "_" + ws + ".csv";
                        SpatialCsvManager.mergeXY(localCsvOutput, this.getCsvOutputs(rasterFile, ws), this.getSuffixMetrics(rasterFile, ws), "X", "Y", entete);
                        for (String csvOut : this.csvOutputs.get(rasterFile).get(ws)) {
                            new File(csvOut).delete();
                            Tool.copy(csvOut.replace(".csv", "_header.txt"), localCsvOutput.replace(".csv", "_header.txt"));
                            new File(csvOut.replace(".csv", "_header.txt")).delete();
                        }
                    }
                }
            }
        }
        this.totalMetrics = null;
        this.coherences = null;
        this.csvOutputs = null;
    }

    private String[] getCsvOutputs(String rasterFile, int ws) {
        return this.csvOutputs.get(rasterFile).get(ws).toArray(new String[this.csvOutputs.get(rasterFile).get(ws).size()]);
    }

    private String[] getSuffixMetrics(String rasterFile, int ws) {
        return this.suffixMetrics.get(rasterFile).get(ws).toArray(new String[this.suffixMetrics.get(rasterFile).get(ws).size()]);
    }
}

