/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.grid;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.grid.GridLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;
import java.awt.Rectangle;

public class HugeGridLandscapeMetricAnalysis
extends GridLandscapeMetricAnalysis {
    private int buffer;

    public HugeGridLandscapeMetricAnalysis(Coverage coverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, GridLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        LandscapeMetricAnalysis.setTileYSize(LandscapeMetricAnalysis.tileYSize() - LandscapeMetricAnalysis.tileYSize() % this.kernel().gridSize());
        this.buffer = this.kernel().gridSize();
        this.counting().init();
    }

    @Override
    protected void doRun() {
        int gridWidth = this.roiWidth() % this.kernel().gridSize() == 0 ? this.roiWidth() / this.kernel().gridSize() : this.roiWidth() / this.kernel().gridSize() + 1;
        this.kernel().setOutDatas(new double[gridWidth][this.nbValues()]);
        for (int localROIY = this.roiY(); localROIY < this.roiY() + this.roiHeight(); localROIY += LandscapeMetricAnalysis.tileYSize()) {
            int localBufferROIYMin = localROIY + this.bufferROIYMin();
            int localBufferROIYMax = Math.max(this.bufferROIYMax(), this.roiHeight() + this.bufferROIYMax() - (localROIY + LandscapeMetricAnalysis.tileYSize()));
            int tYs = Math.min(LandscapeMetricAnalysis.tileYSize(), this.roiHeight() + this.roiY() - localROIY);
            this.kernel().setWidth(this.roiWidth());
            this.kernel().setHeight(tYs);
            this.kernel().setBufferROIXMin(this.bufferROIXMin());
            this.kernel().setBufferROIXMax(this.bufferROIXMax());
            this.kernel().setBufferROIYMin(localBufferROIYMin);
            this.kernel().setBufferROIYMax(localBufferROIYMax);
            Rectangle roi = new Rectangle(this.roiX(), localROIY, this.roiWidth(), tYs);
            this.kernel().setInDatas(this.coverage().getData(roi));
            int yGrid = 0;
            int b = 0;
            while (b < tYs) {
                this.kernel().applyGridWindow(gridWidth, b);
                this.kernel().get(this.kernel().outDatas());
                for (int xGrid = 0; xGrid < gridWidth; ++xGrid) {
                    this.counting().setCounts(this.kernel().outDatas()[xGrid]);
                    this.counting().calculate();
                    this.counting().export(xGrid, yGrid);
                }
                b += this.buffer;
                ++yGrid;
            }
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.coverage().dispose();
    }
}

