/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.grid;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.grid.GridLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.PatchCounting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueAndCoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCounting;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridLandscapeMetricKernel;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridPatchKernel;
import fr.inrae.act.bagap.chloe.window.kernel.grid.GridQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.output.AsciiGridOutput;
import fr.inrae.act.bagap.chloe.window.output.CsvOutput;
import fr.inrae.act.bagap.chloe.window.output.GeoTiffOutput;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class GridLandscapeMetricAnalysisFactory {
    /*
     * WARNING - void declaration
     */
    public GridLandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder, Coverage coverage) throws IOException {
        void var37_47;
        StringBuffer sb;
        Object metric;
        int roiHeight;
        int inWidth = coverage.width();
        int inHeight = coverage.height();
        double inMinX = coverage.minx();
        double inMaxY = coverage.maxy();
        double inCellSize = coverage.cellsize();
        int roiX = builder.getROIX();
        int roiY = builder.getROIY();
        int roiWidth = builder.getROIWidth();
        if (roiWidth == -1) {
            roiWidth = inWidth;
        }
        if ((roiHeight = builder.getROIHeight()) == -1) {
            roiHeight = inHeight;
        }
        int gridSize = builder.getWindowSize();
        int outWidth = (roiWidth - 1) / gridSize + 1;
        int outHeight = (roiHeight - 1) / gridSize + 1;
        double outCellSize = (double)gridSize * inCellSize;
        double outMinX = inMinX + (double)roiX * inCellSize;
        double outMaxX = outMinX + (double)outWidth * outCellSize;
        double outMaxY = inMaxY - (double)roiY * inCellSize;
        double outMinY = outMaxY - (double)outHeight * outCellSize;
        int bufferROIXMin = roiX;
        int bufferROIXMax = inWidth - (roiX + roiWidth);
        int bufferROIYMin = roiY;
        int bufferROIYMax = inHeight - (roiY + roiHeight);
        int theoreticalSize = 0;
        int theoreticalCoupleSize = 0;
        for (int j = 0; j < gridSize; ++j) {
            for (int i = 0; i < gridSize; ++i) {
                ++theoreticalSize;
                if (j > 0) {
                    ++theoreticalCoupleSize;
                }
                if (i <= 0) continue;
                ++theoreticalCoupleSize;
            }
        }
        Set<Metric> metrics = builder.getMetrics();
        HashSet<CountingObserver> observers = new HashSet<CountingObserver>();
        if (builder.getCsv() != null) {
            CsvOutput csvOutput = new CsvOutput(builder.getCsv(), outMinX, outMaxX, outMinY, outMaxY, outWidth, outHeight, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
            observers.add(csvOutput);
        } else if (builder.getCsvFolder() != null) {
            String name = builder.getCsvFolder() + new File(builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "").toString() + ".csv";
            CsvOutput csvOutput = new CsvOutput(name, outMinX, outMaxX, outMinY, outMaxY, outWidth, outHeight, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
            observers.add(csvOutput);
        }
        if (builder.getAsciiOutputs(gridSize) != null) {
            for (Map.Entry<String, String> entry : builder.getAsciiOutputs(gridSize).entrySet()) {
                metric = null;
                for (Metric m : metrics) {
                    if (!m.getName().equalsIgnoreCase(entry.getKey())) continue;
                    metric = m;
                    break;
                }
                if (metric == null) continue;
                AsciiGridOutput asciiGridOutput = new AsciiGridOutput(entry.getValue(), (Metric)metric, outWidth, outHeight, outMinX, outMinY, outCellSize, coverage.getEntete().noDataValue());
                observers.add(asciiGridOutput);
            }
        }
        if (builder.getAsciiGridFolder() != null) {
            Object asciiFolder = builder.getAsciiGridFolder();
            if (!((String)asciiFolder).endsWith("/") && !((String)asciiFolder).endsWith("\\")) {
                asciiFolder = (String)asciiFolder + "/";
            }
            for (Metric metric2 : metrics) {
                sb = new StringBuffer();
                sb.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                sb.append("_" + metric2.getName());
                sb.append("_" + builder.getWindowSize());
                sb.append(".asc");
                String string = (String)asciiFolder + sb.toString();
                AsciiGridOutput asciiOutput = new AsciiGridOutput(string, metric2, outWidth, outHeight, outMinX, outMinY, outCellSize, coverage.getEntete().noDataValue());
                observers.add(asciiOutput);
            }
        }
        if (builder.getGeoTiffOutputs(gridSize) != null) {
            for (Map.Entry entry : builder.getGeoTiffOutputs(gridSize).entrySet()) {
                metric = null;
                for (Metric m : metrics) {
                    if (!m.getName().equalsIgnoreCase((String)entry.getKey())) continue;
                    metric = m;
                    break;
                }
                if (metric == null) continue;
                GeoTiffOutput geoTiffOutput = new GeoTiffOutput((String)entry.getValue(), (Metric)metric, outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                observers.add(geoTiffOutput);
            }
        }
        if (builder.getGeoTiffFolder() != null) {
            String tifFolder = builder.getGeoTiffFolder();
            if (!tifFolder.endsWith("/") && !tifFolder.endsWith("\\")) {
                tifFolder = tifFolder + "/";
            }
            for (Metric metric3 : metrics) {
                sb = new StringBuffer();
                sb.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                sb.append("_" + metric3.getName());
                sb.append("_" + builder.getWindowSize());
                sb.append(".tif");
                String string = tifFolder + sb.toString();
                GeoTiffOutput geotiffOutput = new GeoTiffOutput(string, metric3, outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, coverage.getEntete().noDataValue(), coverage.getEntete().crs());
                observers.add(geotiffOutput);
            }
        }
        GridLandscapeMetricKernel kernel = null;
        Object var37_40 = null;
        int nbValues = -1;
        if (MetricManager.hasOnlyQuantitativeMetric(metrics)) {
            nbValues = 8;
            kernel = new GridQuantitativeKernel(gridSize, coverage.getEntete().noDataValue());
            QuantitativeCounting quantitativeCounting = new QuantitativeCounting(theoreticalSize);
        } else {
            void var39_63;
            int[] nArray = builder.getValues();
            if (nArray == null) {
                int[] nArray2 = this.readValues(coverage, new Rectangle(roiX, roiY, roiWidth, roiHeight), coverage.getEntete().noDataValue());
            }
            if (MetricManager.hasOnlyQualitativeMetric(metrics)) {
                float[] couples = null;
                if (MetricManager.hasCoupleMetric(metrics)) {
                    couples = new float[(((void)var39_63).length * ((void)var39_63).length - ((void)var39_63).length) / 2 + ((void)var39_63).length];
                    int index = 0;
                    for (void s1 : var39_63) {
                        couples[index++] = Couple.getCouple((int)s1, (int)s1);
                    }
                    for (void s1 : var39_63) {
                        for (void s2 : var39_63) {
                            if (s1 >= s2) continue;
                            couples[index++] = Couple.getCouple((int)s1, (int)s2);
                        }
                    }
                }
                if (MetricManager.hasOnlyValueMetric(metrics)) {
                    nbValues = 5 + ((void)var39_63).length;
                    kernel = new GridCountValueKernel(gridSize, coverage.getEntete().noDataValue(), (int[])var39_63);
                    ValueCounting valueCounting = new ValueCounting(inCellSize, (int[])var39_63, theoreticalSize);
                } else if (MetricManager.hasOnlyCoupleMetric(metrics)) {
                    nbValues = 7 + couples.length;
                    kernel = new GridCountCoupleKernel(gridSize, coverage.getEntete().noDataValue(), (int[])var39_63);
                    CoupleCounting coupleCounting = new CoupleCounting(inCellSize, ((void)var39_63).length, couples, theoreticalSize, theoreticalCoupleSize);
                } else {
                    nbValues = 5 + ((void)var39_63).length + 3 + couples.length;
                    kernel = new GridCountValueAndCoupleKernel(gridSize, coverage.getEntete().noDataValue(), (int[])var39_63);
                    ValueAndCoupleCounting valueAndCoupleCounting = new ValueAndCoupleCounting(inCellSize, (int[])var39_63, couples, theoreticalSize, theoreticalCoupleSize);
                }
            } else if (MetricManager.hasOnlyPatchMetric(metrics)) {
                System.out.println("comptage des patchs");
                nbValues = 8 + 4 * ((void)var39_63).length;
                kernel = new GridPatchKernel(gridSize, coverage.getEntete().noDataValue(), (int[])var39_63, inCellSize);
                PatchCounting patchCounting = new PatchCounting(inCellSize, (int[])var39_63, theoreticalSize);
            }
        }
        for (Metric m : metrics) {
            var37_47.addMetric(m);
        }
        for (CountingObserver co : observers) {
            var37_47.addObserver(co);
        }
        return this.createSingle(coverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, (Counting)var37_47);
    }

    protected abstract int[] readValues(Coverage var1, Rectangle var2, int var3);

    protected abstract GridLandscapeMetricAnalysis createSingle(Coverage var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, GridLandscapeMetricKernel var11, Counting var12);
}

