/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.entity;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.window.analysis.entity.EntityLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityLandscapeMetricKernel;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class TinyEntityLandscapeMetricAnalysis
extends EntityLandscapeMetricAnalysis {
    public TinyEntityLandscapeMetricAnalysis(Coverage coverage, Coverage entityCoverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, EntityLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, entityCoverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        this.kernel().setWidth(this.roiWidth());
        this.kernel().setHeight(this.roiHeight());
        Rectangle roi = new Rectangle(this.roiX(), this.roiY(), this.roiWidth(), this.roiHeight());
        this.kernel().setInDatas(this.coverage().getData(roi));
        this.coverage().dispose();
        this.kernel().setEntityDatas(this.entityCoverage().getData(roi));
        TreeSet<Integer> entityIds = new TreeSet<Integer>();
        for (float f : this.kernel().entityDatas()) {
            if (f == 0.0f || f == (float)Raster.getNoDataValue()) continue;
            entityIds.add((int)f);
        }
        this.kernel().setOutDatas(new HashMap<Integer, double[]>());
        Object object = entityIds.iterator();
        while (object.hasNext()) {
            int aId = (Integer)object.next();
            this.kernel().outDatas().put(aId, new double[this.nbValues()]);
            this.kernel().outDatas().get((Object)Integer.valueOf((int)aId))[0] = 1.0;
        }
        this.counting().init();
        this.kernel().init();
    }

    @Override
    protected void doRun() {
        this.kernel().applyEntityWindow();
        for (Map.Entry<Integer, double[]> e : this.kernel().outDatas().entrySet()) {
            this.counting().setCounts(e.getValue());
            this.counting().calculate();
            this.counting().export(e.getKey());
        }
    }
}

