/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.entity;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.entity.EntityLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityLandscapeMetricKernel;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HugeEntityLandscapeMetricAnalysis
extends EntityLandscapeMetricAnalysis {
    public HugeEntityLandscapeMetricAnalysis(Coverage coverage, Coverage areaCoverage, int roiX, int roiY, int roiWidth, int roiHeight, int bufferROIXMin, int bufferROIXMax, int bufferROIYMin, int bufferROIYMax, int nbValues, EntityLandscapeMetricKernel kernel, Counting counting) {
        super(coverage, areaCoverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, counting);
    }

    @Override
    protected void doInit() {
        this.kernel().setWidth(this.roiWidth());
        this.kernel().init();
        this.counting().init();
    }

    @Override
    protected void doRun() {
        HashSet<Integer> entityIds = new HashSet<Integer>();
        this.kernel().setOutDatas(new HashMap<Integer, double[]>());
        for (int localROIY = this.roiY(); localROIY < this.roiY() + this.roiHeight(); localROIY += LandscapeMetricAnalysis.tileYSize()) {
            int tYs = Math.min(LandscapeMetricAnalysis.tileYSize(), this.roiHeight() + this.roiY() - localROIY);
            this.kernel().setHeight(tYs);
            Rectangle roi = new Rectangle(this.roiX(), localROIY, this.roiWidth(), tYs);
            this.kernel().setInDatas(this.coverage().getData(roi));
            this.kernel().setEntityDatas(this.entityCoverage().getData(roi));
            for (float f : this.kernel().entityDatas()) {
                if (f == 0.0f || f == (float)Raster.getNoDataValue()) continue;
                entityIds.add((int)f);
            }
            Object object = entityIds.iterator();
            while (object.hasNext()) {
                int aId = (Integer)object.next();
                if (this.kernel().outDatas().containsKey(aId)) continue;
                this.kernel().outDatas().put(aId, new double[this.nbValues()]);
                this.kernel().outDatas().get((Object)Integer.valueOf((int)aId))[0] = 1.0;
            }
            this.kernel().init();
            this.kernel().applyEntityWindow();
        }
        for (Map.Entry<Integer, double[]> e : this.kernel().outDatas().entrySet()) {
            this.counting().setCounts(e.getValue());
            this.counting().calculate();
            this.counting().export(e.getKey());
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.coverage().dispose();
    }
}

