/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis.entity;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import fr.inrae.act.bagap.chloe.util.Couple;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.entity.EntityLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.counting.CountingObserver;
import fr.inrae.act.bagap.chloe.window.counting.CoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.QuantitativeCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueAndCoupleCounting;
import fr.inrae.act.bagap.chloe.window.counting.ValueCounting;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityCountCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityCountValueAndCoupleKernel;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityCountValueKernel;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityLandscapeMetricKernel;
import fr.inrae.act.bagap.chloe.window.kernel.entity.EntityQuantitativeKernel;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.output.EntityCsvOutput;
import fr.inrae.act.bagap.chloe.window.output.EntityDataOutput;
import fr.inrae.act.bagap.chloe.window.output.EntityRasterOutput;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class EntityLandscapeMetricAnalysisFactory {
    /*
     * WARNING - void declaration
     */
    public EntityLandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder, Coverage coverage) throws IOException {
        void var23_34;
        StringBuffer sb;
        Object metric;
        int roiHeight;
        Coverage entityCoverage;
        int inWidth = coverage.width();
        int inHeight = coverage.height();
        double inMinX = coverage.minx();
        double inMinY = coverage.miny();
        double inCellSize = coverage.cellsize();
        if (builder.getEntityRasterFile() != null) {
            entityCoverage = CoverageManager.getCoverage(builder.getEntityRasterFile());
        } else if (builder.getEntityRasterTab() != null) {
            entityCoverage = new TabCoverage(builder.getEntityRasterTab(), coverage.getEntete());
        } else {
            throw new IllegalArgumentException("no entity raster declared");
        }
        int roiX = builder.getROIX();
        int roiY = builder.getROIY();
        int roiWidth = builder.getROIWidth();
        if (roiWidth == -1) {
            roiWidth = inWidth;
        }
        if ((roiHeight = builder.getROIHeight()) == -1) {
            roiHeight = inHeight;
        }
        int bufferROIXMin = roiX;
        int bufferROIXMax = inWidth - (roiX + roiWidth);
        int bufferROIYMin = roiY;
        int bufferROIYMax = inHeight - (roiY + roiHeight);
        Set<Metric> metrics = builder.getMetrics();
        HashSet<CountingObserver> observers = new HashSet<CountingObserver>();
        if (builder.getCsv() != null) {
            EntityCsvOutput csvOutput = new EntityCsvOutput(builder.getCsv());
            observers.add(csvOutput);
        } else if (builder.getCsvFolder() != null) {
            String name = builder.getCsvFolder() + new File(builder.getRasterFile()).getName().replace(".tif", "").replace(".asc", "").toString() + ".csv";
            EntityCsvOutput entityCsvOutput = new EntityCsvOutput(name);
            observers.add(entityCsvOutput);
        }
        if (builder.getAsciiOutputs(0) != null) {
            for (Map.Entry<String, String> entry : builder.getAsciiOutputs(0).entrySet()) {
                metric = null;
                for (Metric m : metrics) {
                    if (!m.getName().equalsIgnoreCase(entry.getKey())) continue;
                    metric = m;
                    break;
                }
                if (metric == null) continue;
                EntityRasterOutput entityRasterOutput = new EntityRasterOutput(entry.getValue(), (Metric)metric, entityCoverage, coverage.getEntete().noDataValue());
                observers.add(entityRasterOutput);
            }
        }
        if (builder.getAsciiGridFolder() != null) {
            Object rasterFolder = builder.getAsciiGridFolder();
            if (!((String)rasterFolder).endsWith("/") && !((String)rasterFolder).endsWith("\\")) {
                rasterFolder = (String)rasterFolder + "/";
            }
            for (Metric metric2 : metrics) {
                sb = new StringBuffer();
                sb.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                sb.append("_" + metric2.getName());
                sb.append(".asc");
                String string = (String)rasterFolder + sb.toString();
                EntityRasterOutput geotiffOutput = new EntityRasterOutput(string, metric2, entityCoverage, coverage.getEntete().noDataValue());
                observers.add(geotiffOutput);
            }
        }
        if (builder.getGeoTiffOutputs(0) != null) {
            for (Map.Entry entry : builder.getGeoTiffOutputs(0).entrySet()) {
                metric = null;
                for (Metric m : metrics) {
                    if (!m.getName().equalsIgnoreCase((String)entry.getKey())) continue;
                    metric = m;
                    break;
                }
                if (metric == null) continue;
                EntityRasterOutput entityRasterOutput = new EntityRasterOutput((String)entry.getValue(), (Metric)metric, entityCoverage, coverage.getEntete().noDataValue());
                observers.add(entityRasterOutput);
            }
        }
        if (builder.getGeoTiffFolder() != null) {
            String tifFolder = builder.getGeoTiffFolder();
            if (!tifFolder.endsWith("/") && !tifFolder.endsWith("\\")) {
                tifFolder = tifFolder + "/";
            }
            for (Metric metric3 : metrics) {
                sb = new StringBuffer();
                sb.append(new File(builder.getRasterFile()).getName().replace(".asc", "").replace(".tif", ""));
                sb.append("_" + metric3.getName());
                sb.append(".tif");
                String string = tifFolder + sb.toString();
                EntityRasterOutput rasterOutput2 = new EntityRasterOutput(string, metric3, entityCoverage, coverage.getEntete().noDataValue());
                observers.add(rasterOutput2);
            }
        }
        if (builder.getEntityDataOutput() != null) {
            EntityDataOutput dataOutput = new EntityDataOutput(builder.getEntityDataOutput());
            observers.add(dataOutput);
        }
        EntityLandscapeMetricKernel kernel = null;
        Object var23_29 = null;
        int nbValues = 0;
        if (MetricManager.hasOnlyQuantitativeMetric(metrics)) {
            nbValues = 8;
            kernel = new EntityQuantitativeKernel(Raster.getNoDataValue());
            QuantitativeCounting quantitativeCounting = new QuantitativeCounting(inCellSize);
        } else {
            int[] nArray = builder.getValues();
            if (nArray == null) {
                int[] nArray2 = this.readValues(coverage, new Rectangle(roiX, roiY, roiWidth, roiHeight), coverage.getEntete().noDataValue());
            }
            if (MetricManager.hasOnlyQualitativeMetric(metrics)) {
                void var25_50;
                float[] couples = null;
                if (MetricManager.hasCoupleMetric(metrics)) {
                    couples = new float[(((void)var25_50).length * ((void)var25_50).length - ((void)var25_50).length) / 2 + ((void)var25_50).length];
                    int index = 0;
                    for (void s1 : var25_50) {
                        couples[index++] = Couple.getCouple((int)s1, (int)s1);
                    }
                    for (void s1 : var25_50) {
                        for (void s2 : var25_50) {
                            if (s1 >= s2) continue;
                            couples[index++] = Couple.getCouple((int)s1, (int)s2);
                        }
                    }
                }
                if (MetricManager.hasOnlyValueMetric(metrics)) {
                    System.out.println("comptage des valeurs");
                    nbValues = 5 + ((void)var25_50).length;
                    kernel = new EntityCountValueKernel(Raster.getNoDataValue(), (int[])var25_50);
                    ValueCounting valueCounting = new ValueCounting(inCellSize, (int[])var25_50);
                } else if (MetricManager.hasOnlyCoupleMetric(metrics)) {
                    System.out.println("comptage des couples");
                    nbValues = 7 + couples.length;
                    kernel = new EntityCountCoupleKernel(Raster.getNoDataValue(), (int[])var25_50);
                    CoupleCounting coupleCounting = new CoupleCounting(inCellSize, ((void)var25_50).length, couples);
                } else {
                    System.out.println("comptage des valeurs et des couples");
                    nbValues = 5 + ((void)var25_50).length + 3 + couples.length;
                    kernel = new EntityCountValueAndCoupleKernel(Raster.getNoDataValue(), (int[])var25_50);
                    ValueAndCoupleCounting valueAndCoupleCounting = new ValueAndCoupleCounting(inCellSize, (int[])var25_50, couples);
                }
            }
        }
        for (Metric m : metrics) {
            var23_34.addMetric(m);
        }
        for (CountingObserver co : observers) {
            var23_34.addObserver(co);
        }
        return this.create(coverage, entityCoverage, roiX, roiY, roiWidth, roiHeight, bufferROIXMin, bufferROIXMax, bufferROIYMin, bufferROIYMax, nbValues, kernel, (Counting)var23_34);
    }

    protected abstract int[] readValues(Coverage var1, Rectangle var2, int var3);

    protected abstract EntityLandscapeMetricAnalysis create(Coverage var1, Coverage var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, EntityLandscapeMetricKernel var12, Counting var13);
}

