/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.entity.HugeEntityLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.entity.TinyEntityLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.grid.HugeGridLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.grid.TinyGridLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.map.HugeMapLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.map.TinyMapLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.selected.HugeSelectedLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.selected.TinySelectedLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.HugeSlidingLandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.TinySlidingLandscapeMetricAnalysisFactory;
import java.io.IOException;

public class LandscapeMetricAnalysisFactory {
    public static LandscapeMetricAnalysis create(LandscapeMetricAnalysisBuilder builder) throws IOException {
        float inCellSize;
        int inHeight;
        int inWidth;
        Coverage coverage;
        if (builder.getCoverage() != null) {
            coverage = builder.getCoverage();
            builder.setEntete(coverage.getEntete());
            inWidth = coverage.getEntete().width();
            inHeight = coverage.getEntete().height();
            inCellSize = coverage.getEntete().cellsize();
        } else if (builder.getRasterTile() != null) {
            coverage = CoverageManager.getCoverage(builder.getRasterTile());
            builder.setEntete(coverage.getEntete());
            inWidth = coverage.getEntete().width();
            inHeight = coverage.getEntete().height();
            inCellSize = coverage.getEntete().cellsize();
        } else if (builder.getRasterFile() != null) {
            coverage = CoverageManager.getCoverage(builder.getRasterFile());
            builder.setEntete(coverage.getEntete());
            inWidth = coverage.getEntete().width();
            inHeight = coverage.getEntete().height();
            inCellSize = coverage.getEntete().cellsize();
        } else if (builder.getRasterTab() != null) {
            inWidth = builder.getEntete().width();
            inHeight = builder.getEntete().height();
            inCellSize = builder.getEntete().cellsize();
            coverage = new TabCoverage(builder.getRasterTab(), builder.getEntete());
        } else if (builder.getRasterTabs() != null) {
            inWidth = builder.getEntete().width();
            inHeight = builder.getEntete().height();
            inCellSize = builder.getEntete().cellsize();
            coverage = new TabCoverage(builder.getRasterTabs()[0], builder.getEntete());
        } else {
            throw new IllegalArgumentException("no raster declared");
        }
        int roiWidth = builder.getROIWidth();
        int roiHeight = builder.getROIHeight();
        if (builder.getAnalysisType() == ChloeAnalysisType.SLIDING) {
            int windowSize = -1;
            if (builder.getWindowSize() > 0) {
                windowSize = builder.getWindowSize();
            } else if (builder.getWindowRadius() > 0.0) {
                double v = 2.0 * builder.getWindowRadius() / (double)inCellSize;
                windowSize = v % 2.0 == 0.0 ? new Double(v + 1.0).intValue() : new Double(v).intValue();
            } else {
                throw new IllegalArgumentException("windowSize must be defined");
            }
            int midWindowSize = windowSize / 2;
            int maxWidth = -1;
            int maxHeight = -1;
            if (roiWidth == -1) {
                maxWidth = inWidth;
                maxHeight = inHeight;
            } else {
                maxWidth = roiWidth + 2 * midWindowSize;
                maxHeight = roiHeight + 2 * midWindowSize;
            }
            if ((double)maxWidth / 1000.0 * ((double)maxHeight / 1000.0) <= (double)LandscapeMetricAnalysis.maxTile() / 1000000.0) {
                return new TinySlidingLandscapeMetricAnalysisFactory().create(builder, coverage);
            }
            return new HugeSlidingLandscapeMetricAnalysisFactory().create(builder, coverage);
        }
        if (builder.getAnalysisType() == ChloeAnalysisType.SELECTED) {
            int windowSize = -1;
            if (builder.getWindowSize() > 0) {
                windowSize = builder.getWindowSize();
            } else if (builder.getWindowRadius() > 0.0) {
                double v = 2.0 * builder.getWindowRadius() / (double)inCellSize;
                windowSize = v % 2.0 == 0.0 ? new Double(v + 1.0).intValue() : new Double(v).intValue();
            } else {
                throw new IllegalArgumentException("windowSize must be defined");
            }
            int midWindowSize = windowSize / 2;
            int maxWidth = -1;
            int maxHeight = -1;
            if (roiWidth == -1) {
                maxWidth = inWidth;
                maxHeight = inHeight;
            } else {
                maxWidth = roiWidth + 2 * midWindowSize;
                maxHeight = roiHeight + 2 * midWindowSize;
            }
            if ((double)maxWidth / 1000.0 * ((double)maxHeight / 1000.0) <= (double)LandscapeMetricAnalysis.maxTile() / 1000000.0) {
                return new TinySelectedLandscapeMetricAnalysisFactory().create(builder, coverage);
            }
            return new HugeSelectedLandscapeMetricAnalysisFactory().create(builder, coverage);
        }
        if (builder.getAnalysisType() == ChloeAnalysisType.ENTITY) {
            int maxWidth = inWidth;
            int maxHeight = inHeight;
            if (roiWidth == -1) {
                maxWidth = inWidth;
                maxHeight = inHeight;
            } else {
                maxWidth = roiWidth;
                maxHeight = roiHeight;
            }
            if ((double)maxWidth / 1000.0 * ((double)maxHeight / 1000.0) <= (double)LandscapeMetricAnalysis.maxTile() / 1000000.0) {
                return new TinyEntityLandscapeMetricAnalysisFactory().create(builder, coverage);
            }
            return new HugeEntityLandscapeMetricAnalysisFactory().create(builder, coverage);
        }
        if (builder.getAnalysisType() == ChloeAnalysisType.GRID) {
            int maxWidth = inWidth;
            int maxHeight = inHeight;
            if (roiWidth == -1) {
                maxWidth = inWidth;
                maxHeight = inHeight;
            } else {
                maxWidth = roiWidth;
                maxHeight = roiHeight;
            }
            if ((double)maxWidth / 1000.0 * ((double)maxHeight / 1000.0) <= (double)LandscapeMetricAnalysis.maxTile() / 1000000.0) {
                return new TinyGridLandscapeMetricAnalysisFactory().create(builder, coverage);
            }
            return new HugeGridLandscapeMetricAnalysisFactory().create(builder, coverage);
        }
        if (builder.getAnalysisType() == ChloeAnalysisType.MAP) {
            int maxWidth = inWidth;
            int maxHeight = inHeight;
            if (roiWidth == -1) {
                maxWidth = inWidth;
                maxHeight = inHeight;
            } else {
                maxWidth = roiWidth;
                maxHeight = roiHeight;
            }
            if ((double)maxWidth / 1000.0 * ((double)maxHeight / 1000.0) <= (double)LandscapeMetricAnalysis.maxTile() / 1000000.0) {
                return new TinyMapLandscapeMetricAnalysisFactory().create(builder, coverage);
            }
            return new HugeMapLandscapeMetricAnalysisFactory().create(builder, coverage);
        }
        throw new IllegalArgumentException((Object)((Object)builder.getAnalysisType()) + " is not a recognized analysis type");
    }
}

