/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.window.analysis;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.RefPoint;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisBuilder;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.api.RasterTypeMime;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisFactory;
import fr.inrae.act.bagap.chloe.window.analysis.entity.MultipleEntityLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.grid.MultipleGridLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.map.MultipleMapLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.selected.MultipleSelectedLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.sliding.MultipleSlidingLandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.counting.Counting;
import fr.inrae.act.bagap.chloe.window.metric.Metric;
import fr.inrae.act.bagap.chloe.window.metric.MetricManager;
import fr.inrae.act.bagap.chloe.window.output.CoverageOutput;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LandscapeMetricAnalysisBuilder
extends ChloeAnalysisBuilder {
    private WindowShapeType shapeType;
    private WindowDistanceType distanceType;
    private String distanceFunction;
    private Coverage coverage;
    private Coverage coverage2;
    private Coverage coverage3;
    private Set<String> rasterFiles;
    private String rasterFile;
    private String rasterFile2;
    private String rasterFile3;
    private String entityRasterFile;
    private String rasterTile;
    private float[] rasterTab;
    private float[] rasterTab2;
    private float[] rasterTab3;
    private float[] entityRasterTab;
    private float[][] rasterTabs;
    private EnteteRaster entete;
    private int displacement;
    private int windowSize;
    private double radius;
    private Set<Integer> windowSizes;
    private Set<Double> windowRadius;
    private double dMax;
    private Set<Metric> metrics;
    private String csv;
    private String points;
    private String pixels;
    private String windowsPath;
    private String asciiGridFolder;
    private String geoTiffFolder;
    private String csvFolder;
    private Set<RefPoint> refPoints;
    private Set<? extends Pixel> refPixels;
    private Map<Integer, Map<String, String>> asciiOutputs;
    private Map<Integer, Map<String, String>> geotiffOutputs;
    private Map<Integer, Map<String, float[]>> tabOutputs;
    private Map<Tile, Map<String, String>> tileAsciiOutputs;
    private Map<Tile, Map<String, String>> tileGeoTiffOutputs;
    private boolean interpolation;
    private int roiX;
    private int roiY;
    private int roiWidth;
    private int roiHeight;
    private int[] values;
    private int[] filters;
    private int[] unfilters;
    private Map<RefPoint, Float> datas;
    private Set<CoverageOutput> coverageOutputs;
    private RasterTypeMime typeMime;
    private String thematicDistanceFile;
    private Map<String, Double> mapData;
    private Map<Integer, Map<String, Double>> entityData;

    @Override
    public void reset() {
        this.setAnalysisType(ChloeAnalysisType.SLIDING);
        this.shapeType = WindowShapeType.CIRCLE;
        this.distanceType = WindowDistanceType.THRESHOLD;
        this.distanceFunction = "exp(-pow(distance, 2)/pow(dmax/2, 2))";
        this.metrics = new HashSet<Metric>();
        this.displacement = 1;
        this.interpolation = false;
        this.windowSize = 0;
        this.radius = 0.0;
        this.dMax = -1.0;
        this.windowSizes = new TreeSet<Integer>();
        this.windowRadius = new TreeSet<Double>();
        this.roiX = 0;
        this.roiY = 0;
        this.roiWidth = -1;
        this.roiHeight = -1;
        this.rasterFiles = new LinkedHashSet<String>();
        this.coverage = null;
        this.coverage2 = null;
        this.coverage3 = null;
        this.rasterTile = null;
        this.rasterFile = null;
        this.rasterFile2 = null;
        this.rasterFile3 = null;
        this.rasterTab = null;
        this.rasterTab2 = null;
        this.rasterTab3 = null;
        this.rasterTabs = null;
        this.entete = null;
        this.entityRasterFile = null;
        this.entityRasterTab = null;
        this.csv = null;
        this.asciiGridFolder = null;
        this.geoTiffFolder = null;
        this.csvFolder = null;
        this.points = null;
        this.pixels = null;
        this.refPoints = null;
        this.refPixels = null;
        this.windowsPath = null;
        this.values = null;
        this.asciiOutputs = new TreeMap<Integer, Map<String, String>>();
        this.geotiffOutputs = new TreeMap<Integer, Map<String, String>>();
        this.tabOutputs = new TreeMap<Integer, Map<String, float[]>>();
        this.tileAsciiOutputs = null;
        this.tileGeoTiffOutputs = null;
        this.unfilters = null;
        this.filters = null;
        this.datas = null;
        this.coverageOutputs = new HashSet<CoverageOutput>();
        this.typeMime = RasterTypeMime.GEOTIFF;
        this.thematicDistanceFile = null;
        this.mapData = null;
        this.entityData = null;
    }

    @Override
    public void setWindowShapeType(WindowShapeType shapeType) {
        this.shapeType = shapeType;
    }

    @Override
    public void setWindowDistanceType(WindowDistanceType distanceType) {
        this.distanceType = distanceType;
    }

    @Override
    public void setWindowDistanceFunction(String function) {
        this.distanceFunction = function;
    }

    @Override
    public void addRasterFile(String rasterFile) {
        this.rasterFiles.add(rasterFile);
        this.setRasterFile(rasterFile);
    }

    @Override
    public void setCoverage(Coverage coverage) {
        this.coverage = coverage;
    }

    @Override
    public void setCoverage2(Coverage coverage2) {
        this.coverage2 = coverage2;
    }

    @Override
    public void setCoverage3(Coverage coverage3) {
        this.coverage3 = coverage3;
    }

    @Override
    public void setRasterTile(String rasterTile) {
        this.rasterTile = rasterTile;
    }

    @Override
    public void setRasterFile(String rasterFile) {
        this.rasterFile = rasterFile;
    }

    @Override
    public void setRasterFile2(String rasterFile2) {
        this.rasterFile2 = rasterFile2;
    }

    @Override
    public void setRasterFile3(String rasterFile3) {
        this.rasterFile3 = rasterFile3;
    }

    @Override
    public void setRasterTab(float[] inputDatas) {
        this.rasterTab = inputDatas;
    }

    @Override
    public void setRasterTab2(float[] inputDatas2) {
        this.rasterTab2 = inputDatas2;
    }

    @Override
    public void setRasterTab3(float[] inputDatas3) {
        this.rasterTab3 = inputDatas3;
    }

    @Override
    public void setRasterTabs(float[] ... dataTabs) {
        this.rasterTabs = dataTabs;
    }

    @Override
    public void setEntete(EnteteRaster entete) {
        this.entete = entete;
    }

    @Override
    public void setEntityRasterFile(String entityRasterFile) {
        this.entityRasterFile = entityRasterFile;
    }

    @Override
    public void setEntityRasterTab(float[] entityRasterTab) {
        this.entityRasterTab = entityRasterTab;
    }

    @Override
    public void setValues(String sValues) {
        String[] s = sValues.split(",");
        this.values = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            this.values[i] = Integer.parseInt(s[i].replace(" ", ""));
        }
    }

    public void setValues(int[] values) {
        this.values = values;
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.addWindowSize(windowSize);
    }

    @Override
    public void addWindowSize(int windowSize) {
        this.windowSizes.add(windowSize);
        this.windowSize = windowSize;
    }

    @Override
    public void setWindowSizes(int[] windowSizes) {
        for (int ws : windowSizes) {
            this.addWindowSize(ws);
        }
    }

    @Override
    public void setWindowRadius(double radius) {
        this.addWindowRadius(radius);
    }

    @Override
    public void addWindowRadius(double radius) {
        this.windowRadius.add(radius);
        this.radius = radius;
    }

    @Override
    public void setWindowRadius(double[] radius) {
        for (double r : radius) {
            this.addWindowRadius(r);
        }
    }

    public void setDMax(double dMax) {
        this.dMax = dMax;
    }

    @Override
    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    @Override
    public void setInterpolation(boolean interpolation) {
        this.interpolation = interpolation;
    }

    @Override
    public void setUnfilters(int[] unfilters) {
        this.unfilters = unfilters;
    }

    @Override
    public void setFilters(int[] filters) {
        this.filters = filters;
    }

    @Override
    public void addMetric(Metric metric) {
        this.metrics.add(metric);
    }

    @Override
    public void addMetric(String metric) {
        if (MetricManager.hasMetric(metric)) {
            this.metrics.add(MetricManager.get(metric));
        } else {
            System.out.println("metric '" + metric + "' does not exist");
        }
    }

    @Override
    public void setMetrics(Set<Metric> metrics) {
        this.metrics = metrics;
    }

    public void setThematicDistanceFile(String thematicDistanceFile) {
        this.thematicDistanceFile = thematicDistanceFile;
    }

    @Override
    public void addCsvOutput(String csv) {
        Util.createAccess(csv);
        this.csv = csv;
    }

    @Override
    public void addCoverageOutput(CoverageOutput coverageOutput) {
        this.coverageOutputs.add(coverageOutput);
    }

    @Override
    public void setAsciiGridOutputFolder(String asciiGridFolder) {
        Util.createAccess(asciiGridFolder);
        this.asciiGridFolder = new File(asciiGridFolder).getAbsolutePath() + "/";
    }

    @Override
    public void setGeoTiffOutputFolder(String geoTiffFolder) {
        Util.createAccess(geoTiffFolder);
        this.geoTiffFolder = new File(geoTiffFolder).getAbsolutePath() + "/";
    }

    @Override
    public void setCsvOutputFolder(String csvFolder) {
        Util.createAccess(csvFolder);
        this.csvFolder = new File(csvFolder).getAbsolutePath() + "/";
    }

    @Override
    public void addAsciiGridOutput(String ascii) {
        Metric metric = this.metrics.iterator().next();
        this.addAsciiGridOutput(metric.getName(), ascii);
    }

    @Override
    public void addAsciiGridOutput(String metric, String ascii) {
        int size = this.windowSizes.iterator().next();
        this.addAsciiGridOutput(size, metric, ascii);
    }

    @Override
    public void addAsciiGridOutput(int size, String metric, String ascii) {
        Util.createAccess(ascii);
        if (!this.asciiOutputs.containsKey(size)) {
            this.asciiOutputs.put(size, new HashMap());
        }
        this.asciiOutputs.get(size).put(metric, ascii);
    }

    @Override
    public void addTabOutput(float[] tab) {
        Metric metric = this.metrics.iterator().next();
        this.addTabOutput(metric.getName(), tab);
    }

    @Override
    public void addTabOutput(String metric, float[] tab) {
        int size = this.windowSizes.iterator().next();
        this.addTabOutput(size, metric, tab);
    }

    @Override
    public void addTabOutput(int size, String metric, float[] tab) {
        if (!this.tabOutputs.containsKey(size)) {
            this.tabOutputs.put(size, new HashMap());
        }
        this.tabOutputs.get(size).put(metric, tab);
    }

    @Override
    public void addGeoTiffOutput(String geotiff) {
        Metric metric = this.metrics.iterator().next();
        this.addGeoTiffOutput(metric.getName(), geotiff);
    }

    @Override
    public void addGeoTiffOutput(String metric, String geotiff) {
        int size = 0;
        if (this.windowSizes.size() > 0) {
            size = this.windowSizes.iterator().next();
        }
        this.addGeoTiffOutput(size, metric, geotiff);
    }

    @Override
    public void addGeoTiffOutput(int size, String metric, String geotiff) {
        Util.createAccess(geotiff);
        if (!this.geotiffOutputs.containsKey(size)) {
            this.geotiffOutputs.put(size, new HashMap());
        }
        this.geotiffOutputs.get(size).put(metric, geotiff);
    }

    @Override
    public void addDataInPixelOutput(String metric, Map<RefPoint, Float> datas) {
        this.datas = datas;
    }

    public void addMapDataOutput(Map<String, Double> mapData) {
        this.mapData = mapData;
    }

    public void addEntityDataOutput(Map<Integer, Map<String, Double>> entityData) {
        this.entityData = entityData;
    }

    @Override
    public void addTileAsciiGridOutput(String metric, String pathTile, Tile tile) {
        Util.createAccess(pathTile);
        if (this.tileAsciiOutputs == null) {
            this.tileAsciiOutputs = new HashMap<Tile, Map<String, String>>();
        }
        if (!this.tileAsciiOutputs.containsKey(tile)) {
            this.tileAsciiOutputs.put(tile, new HashMap());
        }
        this.tileAsciiOutputs.get(tile).put(metric, new File(pathTile).getAbsolutePath() + "/");
    }

    @Override
    public void addTileGeoTiffOutput(String metric, String pathTile, Tile tile) {
        Util.createAccess(pathTile);
        if (this.tileGeoTiffOutputs == null) {
            this.tileGeoTiffOutputs = new HashMap<Tile, Map<String, String>>();
        }
        if (!this.tileGeoTiffOutputs.containsKey(tile)) {
            this.tileGeoTiffOutputs.put(tile, new HashMap());
        }
        this.tileGeoTiffOutputs.get(tile).put(metric, new File(pathTile).getAbsolutePath() + "/");
    }

    @Override
    public void setPointsFilter(String points) {
        this.points = points;
    }

    @Override
    public void setPointsFilter(Set<RefPoint> points) {
        this.refPoints = points;
    }

    @Override
    public void setPixelsFilter(String pixels) {
        this.pixels = pixels;
    }

    @Override
    public void setPixelsFilter(Set<? extends Pixel> pixels) {
        this.refPixels = pixels;
    }

    @Override
    public void setWindowsPath(String windowsPath) {
        Util.createAccess(windowsPath);
        this.windowsPath = new File(windowsPath).getAbsolutePath() + "/";
    }

    @Override
    public void setTypeMime(String typeMime) {
        this.typeMime = RasterTypeMime.valueOf(typeMime);
    }

    @Override
    public void setTypeMime(RasterTypeMime typeMime) {
        this.typeMime = typeMime;
    }

    @Override
    public void setBufferSize(int buffSize) {
        LandscapeMetricAnalysis.setBufferSize(buffSize);
    }

    @Override
    public void setROIX(int roiX) {
        this.roiX = roiX;
    }

    @Override
    public void setROIY(int roiY) {
        this.roiY = roiY;
    }

    @Override
    public void setROIWidth(int roiWidth) {
        this.roiWidth = roiWidth;
    }

    @Override
    public void setROIHeight(int roiHeight) {
        this.roiHeight = roiHeight;
    }

    @Override
    public void setMinRate(double min) {
        Counting.setMinRate(min / 100.0);
    }

    @Override
    public WindowShapeType getWindowShapeType() {
        return this.shapeType;
    }

    public WindowDistanceType getWindowDistanceType() {
        return this.distanceType;
    }

    public String getWindowDistanceFunction() {
        return this.distanceFunction;
    }

    public Set<String> getRasterFiles() {
        return this.rasterFiles;
    }

    public Coverage getCoverage() {
        return this.coverage;
    }

    public Coverage getCoverage2() {
        return this.coverage2;
    }

    public Coverage getCoverage3() {
        return this.coverage3;
    }

    public String getRasterTile() {
        return this.rasterTile;
    }

    @Override
    public String getRasterFile() {
        return this.rasterFile;
    }

    public String getRasterFile2() {
        return this.rasterFile2;
    }

    public String getRasterFile3() {
        return this.rasterFile3;
    }

    public float[] getRasterTab() {
        return this.rasterTab;
    }

    public float[] getRasterTab2() {
        return this.rasterTab2;
    }

    public float[] getRasterTab3() {
        return this.rasterTab3;
    }

    public float[][] getRasterTabs() {
        return this.rasterTabs;
    }

    public EnteteRaster getEntete() {
        return this.entete;
    }

    public String getEntityRasterFile() {
        return this.entityRasterFile;
    }

    public float[] getEntityRasterTab() {
        return this.entityRasterTab;
    }

    public int[] getValues() {
        return this.values;
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }

    public Set<Integer> getWindowSizes() {
        return this.windowSizes;
    }

    public double getWindowRadius() {
        return this.radius;
    }

    private Set<Double> getWindowsRadius() {
        return this.windowRadius;
    }

    public double getDMax() {
        return this.dMax;
    }

    @Override
    public int getDisplacement() {
        return this.displacement;
    }

    public boolean getInterpolation() {
        return this.interpolation;
    }

    public Set<Metric> getMetrics() {
        return this.metrics;
    }

    public String getThematicDistanceFile() {
        return this.thematicDistanceFile;
    }

    public String getCsv() {
        return this.csv;
    }

    public Set<CoverageOutput> getCoverageOutputs() {
        return this.coverageOutputs;
    }

    public String getAsciiGridFolder() {
        return this.asciiGridFolder;
    }

    public String getGeoTiffFolder() {
        return this.geoTiffFolder;
    }

    public String getCsvFolder() {
        return this.csvFolder;
    }

    public Map<String, String> getAsciiOutputs(int ws) {
        return this.asciiOutputs.get(ws);
    }

    public Map<String, String> getGeoTiffOutputs(int ws) {
        return this.geotiffOutputs.get(ws);
    }

    public Map<String, float[]> getTabOutputs(int ws) {
        return this.tabOutputs.get(ws);
    }

    public Map<Tile, Map<String, String>> getTileAsciiGridOutputs() {
        return this.tileAsciiOutputs;
    }

    public Map<Tile, Map<String, String>> getTileGeoTiffOutputs() {
        return this.tileGeoTiffOutputs;
    }

    public Map<RefPoint, Float> getDatas() {
        return this.datas;
    }

    public Map<String, Double> getMapDataOutput() {
        return this.mapData;
    }

    public Map<Integer, Map<String, Double>> getEntityDataOutput() {
        return this.entityData;
    }

    public int getROIX() {
        return this.roiX;
    }

    public int getROIY() {
        return this.roiY;
    }

    public int getROIWidth() {
        return this.roiWidth;
    }

    public int getROIHeight() {
        return this.roiHeight;
    }

    public int[] getUnfilters() {
        return this.unfilters;
    }

    public int[] getFilters() {
        return this.filters;
    }

    public String getPixelsFilter() {
        return this.pixels;
    }

    public String getPointsFilter() {
        return this.points;
    }

    public Set<RefPoint> getRefPoints() {
        return this.refPoints;
    }

    public Set<Pixel> getRefPixels() {
        return this.refPixels;
    }

    public String getWindowsPath() {
        return this.windowsPath;
    }

    @Override
    public RasterTypeMime getTypeMime() {
        return this.typeMime;
    }

    @Override
    public LandscapeMetricAnalysis build() {
        LandscapeMetricAnalysis analysis;
        block9: {
            analysis = null;
            try {
                if (this.getAnalysisType().equals((Object)ChloeAnalysisType.SLIDING)) {
                    analysis = (this.windowSizes.size() == 1 || this.windowRadius.size() == 1) && MetricManager.hasCoherence(this.metrics) && this.rasterFiles.size() <= 1 ? LandscapeMetricAnalysisFactory.create(this) : new MultipleSlidingLandscapeMetricAnalysis(this);
                    break block9;
                }
                if (this.getAnalysisType().equals((Object)ChloeAnalysisType.SELECTED)) {
                    analysis = (this.windowSizes.size() == 1 || this.windowRadius.size() == 1) && MetricManager.hasCoherence(this.metrics) && this.rasterFiles.size() <= 1 ? LandscapeMetricAnalysisFactory.create(this) : new MultipleSelectedLandscapeMetricAnalysis(this);
                    break block9;
                }
                if (this.getAnalysisType().equals((Object)ChloeAnalysisType.MAP)) {
                    analysis = MetricManager.hasCoherence(this.metrics) && this.rasterFiles.size() <= 1 ? LandscapeMetricAnalysisFactory.create(this) : new MultipleMapLandscapeMetricAnalysis(this);
                    break block9;
                }
                if (this.getAnalysisType().equals((Object)ChloeAnalysisType.GRID)) {
                    analysis = this.windowSizes.size() == 1 && MetricManager.hasCoherence(this.metrics) && this.rasterFiles.size() <= 1 ? LandscapeMetricAnalysisFactory.create(this) : new MultipleGridLandscapeMetricAnalysis(this);
                    break block9;
                }
                if (this.getAnalysisType().equals((Object)ChloeAnalysisType.ENTITY)) {
                    analysis = MetricManager.hasCoherence(this.metrics) ? LandscapeMetricAnalysisFactory.create(this) : new MultipleEntityLandscapeMetricAnalysis(this);
                    break block9;
                }
                analysis = LandscapeMetricAnalysisFactory.create(this);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return analysis;
    }
}

