/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Map;

public class SearchAndReplaceAnalysis
extends ChloeUtilAnalysis {
    private String inputRaster;
    private String outputRaster;
    private Map<Float, Float> sarMap;
    private int noDataValue;
    private float[] inData;
    private float[] outData;
    private EnteteRaster entete;

    public SearchAndReplaceAnalysis(String outputRaster, String inputRaster, int noDataValue, Map<Float, Float> sarMap) {
        this.outputRaster = outputRaster;
        this.inputRaster = inputRaster;
        this.noDataValue = noDataValue;
        this.sarMap = sarMap;
    }

    @Override
    protected void doInit() {
        Coverage cov = CoverageManager.getCoverage(this.inputRaster);
        this.entete = cov.getEntete();
        this.inData = cov.getData();
        cov.dispose();
        this.entete.setNoDataValue(this.noDataValue);
        this.outData = new float[this.entete.width() * this.entete.height()];
    }

    @Override
    protected void doRun() {
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(this.outData, this.inData, this.sarMap);
        cal.run();
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.inputRaster = null;
        this.outputRaster = null;
        this.entete = null;
        this.sarMap.clear();
        this.sarMap = null;
        this.inData = null;
        this.outData = null;
    }
}

