/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RasterFromShapefileAnalysis
extends ChloeUtilAnalysis {
    private String outputRaster;
    private String inputShapefile;
    private String attribute;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private float cellSize;
    private int noDataValue;
    private float fillValue;
    private EnteteRaster entete;

    public RasterFromShapefileAnalysis(String outputRaster, String inputShapefile, String attribute, double minx, double maxx, double miny, double maxy, float cellSize, int noDataValue, float fillValue) {
        this.outputRaster = outputRaster;
        this.inputShapefile = inputShapefile;
        this.attribute = attribute;
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.fillValue = fillValue;
    }

    @Override
    protected void doInit() {
        CoordinateReferenceSystem crs = ShapeFile2CoverageConverter.getCoordinateReferenceSystem(this.inputShapefile);
        try {
            if (!CRS.toSRS((CoordinateReferenceSystem)crs).startsWith("EPSG")) {
                crs = CRS.decode((String)"EPSG:2154");
            }
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        this.entete = EnteteRaster.getEntete(new Envelope(this.minx, this.maxx, this.miny, this.maxy), this.cellSize, this.noDataValue, crs);
        Util.createAccess(this.outputRaster);
    }

    @Override
    protected void doRun() {
        ShapeFile2CoverageConverter.rasterize(this.outputRaster, this.inputShapefile, this.attribute, this.fillValue, this.entete);
    }

    @Override
    protected void doClose() {
    }
}

