/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.SpatialCsvManager;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;

public class RasterFromCsvAnalysis
extends ChloeUtilAnalysis {
    private String csvFile;
    private String variable;
    private float[] outData;
    private String outputRaster;
    private int width;
    private int height;
    private int noDataValue;
    private float cellSize;
    private double xMin;
    private double yMin;
    private EnteteRaster entete;

    public RasterFromCsvAnalysis(String outputRaster, String csvFile, String variable, int width, int height, double xMin, double yMin, float cellSize, int noDataValue) {
        this.csvFile = csvFile;
        this.variable = variable;
        this.outputRaster = outputRaster;
        this.width = width;
        this.height = height;
        this.xMin = xMin;
        this.yMin = yMin;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    protected void doInit() {
        double xMax = this.xMin + (double)((float)this.width * this.cellSize);
        double yMax = this.yMin + (double)((float)this.height * this.cellSize);
        this.entete = new EnteteRaster(this.width, this.height, this.xMin, xMax, this.yMin, yMax, this.cellSize, this.noDataValue);
        this.outData = new float[this.entete.width() * this.entete.height()];
    }

    @Override
    protected void doRun() {
        SpatialCsvManager.exportTab(this.outData, this.csvFile, this.variable, this.entete);
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.csvFile = null;
        this.variable = null;
        this.outputRaster = null;
        this.entete = null;
        this.outData = null;
    }
}

