/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.analysis.tab.OverlayPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Set;

public class OverlayAnalysis
extends ChloeUtilAnalysis {
    private String outputRaster;
    private Set<String> inputRasters;
    private float[][] inDatas;
    private float[] outData;
    private EnteteRaster entete;

    public OverlayAnalysis(String outputRaster, Set<String> inputRasters) {
        this.outputRaster = outputRaster;
        this.inputRasters = inputRasters;
    }

    @Override
    protected void doInit() {
        this.inDatas = new float[this.inputRasters.size()][];
        int index = 0;
        for (String inputRaster : this.inputRasters) {
            Coverage cov = CoverageManager.getCoverage(inputRaster);
            this.entete = cov.getEntete();
            this.inDatas[index++] = cov.getData();
            cov.dispose();
        }
        this.outData = new float[this.entete.width() * this.entete.height()];
    }

    @Override
    protected void doRun() {
        OverlayPixel2PixelTabCalculation cal = new OverlayPixel2PixelTabCalculation(this.outData, this.entete.noDataValue(), this.inDatas);
        cal.run();
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.inputRasters.clear();
        this.inputRasters = null;
        this.outputRaster = null;
        this.entete = null;
        this.inDatas = null;
        this.outData = null;
    }
}

