/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.SpatialCsvManager;
import fr.inrae.act.bagap.chloe.api.RasterTypeMime;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Set;

public class MultipleRasterFromCsvAnalysis
extends ChloeUtilAnalysis {
    private String csvFile;
    private Set<String> variables;
    private float[][] outDatas;
    private String outputFolder;
    private String outputPrefix;
    private String outputSuffix;
    private int ncols;
    private int nrows;
    private int noDataValue;
    private float cellSize;
    private double xMin;
    private double yMin;
    private EnteteRaster entete;
    private RasterTypeMime typeMime;

    public MultipleRasterFromCsvAnalysis(String outputFolder, String outputPrefix, String outputSuffix, RasterTypeMime typeMime, String csvFile, Set<String> variables, int ncols, int nrows, double xMin, double yMin, float cellSize, int noDataValue) {
        this.csvFile = csvFile;
        this.variables = variables;
        this.outputFolder = outputFolder;
        this.outputPrefix = outputPrefix;
        this.outputSuffix = outputSuffix;
        this.typeMime = typeMime;
        this.ncols = ncols;
        this.nrows = nrows;
        this.xMin = xMin;
        this.yMin = yMin;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    protected void doInit() {
        double xMax = this.xMin + (double)((float)this.ncols * this.cellSize);
        double yMax = this.yMin + (double)((float)this.nrows * this.cellSize);
        this.entete = new EnteteRaster(this.ncols, this.nrows, this.xMin, xMax, this.yMin, yMax, this.cellSize, this.noDataValue);
        this.outDatas = new float[this.variables.size()][this.entete.width() * this.entete.height()];
        this.outputPrefix = this.outputPrefix.endsWith("_") || this.outputPrefix.equalsIgnoreCase("") ? this.outputPrefix : this.outputPrefix + "_";
        this.outputSuffix = this.outputSuffix.startsWith("_") || this.outputSuffix.equalsIgnoreCase("") ? this.outputSuffix : "_" + this.outputSuffix;
    }

    @Override
    protected void doRun() {
        SpatialCsvManager.exportTabs(this.outDatas, this.csvFile, this.variables.toArray(new String[this.variables.size()]), this.entete);
    }

    @Override
    protected void doClose() {
        int var = 0;
        for (String variable : this.variables) {
            if (this.typeMime == RasterTypeMime.ASCII_GRID) {
                CoverageManager.write(this.outputFolder + this.outputPrefix + variable + this.outputSuffix + ".asc", this.outDatas[var++], this.entete);
                continue;
            }
            CoverageManager.write(this.outputFolder + this.outputPrefix + variable + this.outputSuffix + ".tif", this.outDatas[var++], this.entete);
        }
        this.csvFile = null;
        this.variables = null;
        this.outputFolder = null;
        this.entete = null;
        this.outDatas = null;
    }
}

