/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.analysis.combination.CombinationExpressionFactory;
import fr.inrae.act.bagap.apiland.analysis.tab.CombinationExpressionPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Map;

public class CombineAnalysis
extends ChloeUtilAnalysis {
    private String combination;
    private Map<String, String> factors;
    private EnteteRaster entete;
    private String[] names;
    private float[][] tabs;
    private float[] outData;
    private String outputRaster;

    public CombineAnalysis(String outputRaster, Map<String, String> factors, String combination) {
        this.combination = combination;
        this.factors = factors;
        this.outputRaster = outputRaster;
    }

    @Override
    protected void doInit() {
        this.names = new String[this.factors.size()];
        this.tabs = new float[this.factors.size()][];
        int ind = 0;
        for (Map.Entry<String, String> factor : this.factors.entrySet()) {
            this.names[ind] = factor.getKey();
            Coverage cov = CoverageManager.getCoverage(factor.getValue());
            if (this.entete == null) {
                this.entete = cov.getEntete();
            }
            this.tabs[ind] = cov.getData();
            cov.dispose();
            ++ind;
        }
        this.outData = new float[this.entete.width() * this.entete.height()];
        this.factors.clear();
        this.factors = null;
    }

    @Override
    protected void doRun() {
        CombinationExpressionPixel2PixelTabCalculation cal = CombinationExpressionFactory.createPixel2PixelTabCalculation(this.outData, this.combination, this.entete.noDataValue(), this.names, this.tabs);
        cal.run();
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.combination = null;
        this.outputRaster = null;
        this.entete = null;
        this.names = null;
        for (int i = 0; i < this.tabs.length; ++i) {
            this.tabs[i] = null;
        }
        this.tabs = null;
        this.outData = null;
    }
}

