/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.analysis.tab.ClassificationPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Map;

public class ClassificationAnalysis
extends ChloeUtilAnalysis {
    private String inputRaster;
    private String outputRaster;
    private float[] inData;
    private float[] outData;
    private EnteteRaster entete;
    private Map<Domain<Float, Float>, Integer> domains;

    public ClassificationAnalysis(String outputRaster, String inputRaster, Map<Domain<Float, Float>, Integer> domains) {
        this.outputRaster = outputRaster;
        this.inputRaster = inputRaster;
        this.domains = domains;
    }

    @Override
    protected void doInit() {
        Coverage cov = CoverageManager.getCoverage(this.inputRaster);
        this.entete = cov.getEntete();
        this.inData = cov.getData();
        cov.dispose();
        this.outData = new float[this.entete.width() * this.entete.height()];
    }

    @Override
    protected void doRun() {
        ClassificationPixel2PixelTabCalculation cal = new ClassificationPixel2PixelTabCalculation(this.outData, this.inData, this.entete.noDataValue(), this.domains);
        cal.run();
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.inputRaster = null;
        this.outputRaster = null;
        this.entete = null;
        this.domains.clear();
        this.domains = null;
        this.inData = null;
        this.outData = null;
    }
}

