/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.cluster.ClusterAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.DistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysisBuilder;
import fr.inrae.act.bagap.chloe.util.analysis.ClassificationAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.CombineAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.MultipleRasterFromCsvAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.OverlayAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.RasterFromCsvAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.RasterFromShapefileAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.SearchAndReplaceAnalysis;
import java.io.IOException;

public class ChloeUtilAnalysisFactory {
    public static ChloeUtilAnalysis create(ChloeUtilAnalysisBuilder builder) throws IOException {
        ChloeUtilAnalysis analysis = null;
        if (builder.getAnalysisType() == ChloeAnalysisType.COMBINE) {
            analysis = new CombineAnalysis(builder.getOutputRaster(), builder.getNamesAndRasters(), builder.getCombination());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.SEARCHANDREPLACE) {
            analysis = new SearchAndReplaceAnalysis(builder.getOutputRaster(), builder.getRasterFile(), builder.getNoDataValue(), builder.getChanges());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.CLASSIFICATION) {
            analysis = new ClassificationAnalysis(builder.getOutputRaster(), builder.getRasterFile(), builder.getDomains());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.OVERLAY) {
            analysis = new OverlayAnalysis(builder.getOutputRaster(), builder.getRasterFiles());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.RASTER_FROM_CSV) {
            analysis = builder.getVariables().size() == 1 ? new RasterFromCsvAnalysis(builder.getOutputRaster(), builder.getCsvFile(), builder.getVariables().iterator().next(), builder.getWidth(), builder.getHeight(), builder.getXMin(), builder.getYMin(), builder.getCellSize(), builder.getNoDataValue()) : new MultipleRasterFromCsvAnalysis(builder.getOutputFolder(), builder.getOutputPrefix(), builder.getOutputSuffix(), builder.getTypeMime(), builder.getCsvFile(), builder.getVariables(), builder.getWidth(), builder.getHeight(), builder.getXMin(), builder.getYMin(), builder.getCellSize(), builder.getNoDataValue());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.RASTER_FROM_SHAPEFILE) {
            analysis = new RasterFromShapefileAnalysis(builder.getOutputRaster(), builder.getShapefile(), builder.getAttribute(), builder.getXMin(), builder.getXMax(), builder.getYMin(), builder.getYMax(), builder.getCellSize(), builder.getNoDataValue(), builder.getFillValue());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.DISTANCE) {
            analysis = new DistanceAnalysis(builder.getOutputRaster(), builder.getRasterFile(), builder.getRasterFile2(), builder.getDistanceType(), builder.getSources(), builder.getMaxDistance());
        } else if (builder.getAnalysisType() == ChloeAnalysisType.CLUSTER) {
            analysis = new ClusterAnalysis(builder.getOutputRaster(), builder.getOutputCsv(), builder.getRasterFile(), builder.getRasterFile2(), builder.getClusterType(), builder.getSources(), builder.getMaxDistance());
        } else {
            throw new IllegalArgumentException((Object)((Object)builder.getAnalysisType()) + " is not a recognized analysis type");
        }
        return analysis;
    }
}

