/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util.analysis;

import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysis;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisBuilder;
import fr.inrae.act.bagap.chloe.api.RasterTypeMime;
import fr.inrae.act.bagap.chloe.cluster.ClusterType;
import fr.inrae.act.bagap.chloe.distance.analysis.DistanceType;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysisFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ChloeUtilAnalysisBuilder
extends ChloeAnalysisBuilder {
    private Map<String, String> factors;
    private String outputRaster;
    private String outputCsv;
    private String outputFolder;
    private String inputRaster;
    private String inputRaster2;
    private Set<String> rasterFiles;
    private String inputShapefile;
    private String outputPrefix;
    private String outputSuffix;
    private String csv;
    private String attribute;
    private String combination;
    private Map<Float, Float> changes;
    private float cellSize;
    private float fillValue;
    private int width;
    private int height;
    private int noDataValue;
    private CoordinateReferenceSystem crs;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Map<Domain<Float, Float>, Integer> domains;
    private Set<String> variables;
    private RasterTypeMime typeMime;
    private DistanceType distanceType;
    private ClusterType clusterType;
    private float maxDistance;
    private Set<Integer> sources;

    @Override
    public void reset() {
        this.factors = null;
        this.outputRaster = null;
        this.outputCsv = null;
        this.outputFolder = null;
        this.inputRaster = null;
        this.inputRaster2 = null;
        this.rasterFiles = new LinkedHashSet<String>();
        this.inputShapefile = null;
        this.attribute = null;
        this.outputPrefix = "";
        this.outputSuffix = "";
        this.typeMime = RasterTypeMime.GEOTIFF;
        this.csv = null;
        this.combination = null;
        this.changes = null;
        this.cellSize = -1.0f;
        this.width = -1;
        this.height = -1;
        this.xMin = 0.0;
        this.xMax = 0.0;
        this.yMin = 0.0;
        this.yMax = 0.0;
        this.noDataValue = Raster.getNoDataValue();
        this.fillValue = Raster.getNoDataValue();
        this.domains = null;
        this.variables = new HashSet<String>();
        this.distanceType = DistanceType.EUCLIDIAN;
        this.clusterType = ClusterType.QUEEN;
        this.maxDistance = -1.0f;
        this.sources = new HashSet<Integer>();
        try {
            this.crs = CRS.decode((String)"EPSG:2154");
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNamesAndRasters(Map<String, String> factors) {
        this.factors = factors;
    }

    @Override
    public void addAsciiGridOutput(String ascii) {
        this.addRasterOutput(ascii);
    }

    @Override
    public void addGeoTiffOutput(String geotiff) {
        this.addRasterOutput(geotiff);
    }

    private void addRasterOutput(String outputRaster) {
        this.outputRaster = outputRaster;
    }

    @Override
    public void addCsvOutput(String outputCsv) {
        this.outputCsv = outputCsv;
    }

    @Override
    public void addRasterFile(String rasterFile) {
        this.rasterFiles.add(rasterFile);
        this.setRasterFile(rasterFile);
    }

    @Override
    public void setRasterFile(String rasterFile) {
        this.inputRaster = rasterFile;
    }

    @Override
    public void setRasterFile2(String rasterFile2) {
        this.inputRaster2 = rasterFile2;
    }

    @Override
    public void setCombination(String combination) {
        this.combination = combination;
    }

    @Override
    public void setChanges(Map<Float, Float> changes) {
        this.changes = changes;
    }

    @Override
    public void setNoDataValue(int noDataValue) {
        this.noDataValue = noDataValue;
    }

    @Override
    public void setFillValue(float fillValue) {
        this.fillValue = fillValue;
    }

    @Override
    public void setDomains(Map<Domain<Float, Float>, Integer> domains) {
        this.domains = domains;
    }

    @Override
    public void setCsvFile(String csvFile) {
        this.csv = csvFile;
    }

    @Override
    public void addVariable(String variable) {
        this.variables.add(variable);
    }

    @Override
    public void setCellSize(float cellSize) {
        this.cellSize = cellSize;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setXMin(double xMin) {
        this.xMin = xMin;
    }

    @Override
    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    @Override
    public void setYMin(double yMin) {
        this.yMin = yMin;
    }

    @Override
    public void setYMax(double yMax) {
        this.yMax = yMax;
    }

    @Override
    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    @Override
    public void setOutputFolder(String folder) {
        Util.createAccess(folder);
        this.outputFolder = new File(folder).getAbsolutePath() + "/";
    }

    @Override
    public void setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
    }

    @Override
    public void setTypeMime(String typeMime) {
        this.typeMime = RasterTypeMime.valueOf(typeMime);
    }

    @Override
    public void setTypeMime(RasterTypeMime typeMime) {
        this.typeMime = typeMime;
    }

    @Override
    public void setShapefile(String shapefile) {
        this.inputShapefile = shapefile;
    }

    @Override
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public void addSource(int source) {
        this.sources.add(source);
    }

    @Override
    public void setDistanceType(DistanceType distanceType) {
        this.distanceType = distanceType;
    }

    @Override
    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public void setClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    public Set<Integer> getSources() {
        return this.sources;
    }

    public DistanceType getDistanceType() {
        return this.distanceType;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public Map<String, String> getNamesAndRasters() {
        return this.factors;
    }

    public String getOutputRaster() {
        return this.outputRaster;
    }

    public String getOutputCsv() {
        return this.outputCsv;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getOutputSuffix() {
        return this.outputSuffix;
    }

    @Override
    public String getRasterFile() {
        return this.inputRaster;
    }

    public String getRasterFile2() {
        return this.inputRaster2;
    }

    public Set<String> getRasterFiles() {
        return this.rasterFiles;
    }

    public String getShapefile() {
        return this.inputShapefile;
    }

    public String getCsvFile() {
        return this.csv;
    }

    public Set<String> getVariables() {
        return this.variables;
    }

    public String getCombination() {
        return this.combination;
    }

    public Map<Float, Float> getChanges() {
        return this.changes;
    }

    public int getNoDataValue() {
        return this.noDataValue;
    }

    public float getFillValue() {
        return this.fillValue;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public float getCellSize() {
        return this.cellSize;
    }

    public Map<Domain<Float, Float>, Integer> getDomains() {
        return this.domains;
    }

    @Override
    public RasterTypeMime getTypeMime() {
        return this.typeMime;
    }

    @Override
    public ChloeAnalysis build() {
        ChloeUtilAnalysis analysis = null;
        try {
            analysis = ChloeUtilAnalysisFactory.create(this);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.reset();
        }
        return analysis;
    }
}

