/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.util;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.TabCoverage;
import fr.inrae.act.bagap.apiland.util.CoordinateManager;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jumpmind.symmetric.csv.CsvReader;

public class Util {
    private static final DecimalFormat format;

    public static String format(double v) {
        int f = new Double(Math.floor(v)).intValue();
        if (v == (double)f) {
            return f + "";
        }
        return format.format(v);
    }

    public static void createAccess(String f) {
        if (f.endsWith("/") || f.endsWith("\\")) {
            new File(f).mkdirs();
        } else {
            new File(f).getParentFile().mkdirs();
        }
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distance(int x1, int y1, int x2, int y2, double cellSize) {
        return Math.sqrt(Math.pow(cellSize * (double)(x1 - x2), 2.0) + Math.pow(cellSize * (double)(y1 - y2), 2.0));
    }

    public static int[] readValuesTinyRoi(Coverage coverage, Rectangle roi, int noDataValue) {
        float[] datas = coverage.getData(roi);
        TreeSet<Float> inValues = new TreeSet<Float>();
        for (float d : datas) {
            if (d == 0.0f || d == (float)noDataValue) continue;
            inValues.add(Float.valueOf(d));
        }
        int index = 0;
        int[] values = new int[inValues.size()];
        Iterator iterator = inValues.iterator();
        while (iterator.hasNext()) {
            float d;
            d = ((Float)iterator.next()).floatValue();
            values[index++] = (int)d;
        }
        return values;
    }

    public static int[] readValuesHugeRoi(Coverage coverage, Rectangle roi, int noDataValue) {
        TreeSet<Float> inValues = new TreeSet<Float>();
        for (int j = 0; j < roi.height; j += LandscapeMetricAnalysis.tileYSize()) {
            float[] datas;
            for (float d : datas = coverage.getData(new Rectangle(roi.x, roi.y + j, roi.width, Math.min(LandscapeMetricAnalysis.tileYSize(), roi.height - j)))) {
                if (d == 0.0f || d == (float)noDataValue) continue;
                inValues.add(Float.valueOf(d));
            }
        }
        int index = 0;
        int[] values = new int[inValues.size()];
        Iterator iterator = inValues.iterator();
        while (iterator.hasNext()) {
            float d = ((Float)iterator.next()).floatValue();
            values[index++] = (int)d;
        }
        return values;
    }

    public static int[] readValues(Coverage coverage, int width, int height, int noDataValue) {
        TreeSet<Float> inValues = new TreeSet<Float>();
        for (int j = 0; j < height; j += LandscapeMetricAnalysis.tileYSize()) {
            float[] datas;
            for (float d : datas = coverage.getData(new Rectangle(0, j, width, Math.min(LandscapeMetricAnalysis.tileYSize(), height - j)))) {
                if (d == 0.0f || d == (float)noDataValue) continue;
                inValues.add(Float.valueOf(d));
            }
        }
        int index = 0;
        int[] values = new int[inValues.size()];
        Iterator iterator = inValues.iterator();
        while (iterator.hasNext()) {
            float d = ((Float)iterator.next()).floatValue();
            values[index++] = (int)d;
        }
        return values;
    }

    public static Map<Float, Float> importData(String dataFile, String code, String value) {
        try {
            CsvReader cr = new CsvReader(dataFile);
            cr.setDelimiter(';');
            cr.readHeaders();
            HashMap<Float, Float> sarMap = new HashMap<Float, Float>();
            while (cr.readRecord()) {
                sarMap.put(Float.valueOf(Float.parseFloat(cr.get(code))), Float.valueOf(Float.parseFloat(cr.get(value))));
            }
            cr.close();
            return sarMap;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Coverage reduce(Coverage coverage, int displacement) {
        EnteteRaster inEntete = coverage.getEntete();
        int inWidth = inEntete.width();
        int inHeight = inEntete.height();
        double inMinX = inEntete.minx();
        double inMinY = inEntete.miny();
        double inMaxX = inEntete.maxx();
        double inMaxY = inEntete.maxy();
        float inCellSize = inEntete.cellsize();
        int outWidth = (inWidth - 1) / displacement + 1;
        int outHeight = (inHeight - 1) / displacement + 1;
        float outCellSize = inCellSize * (float)displacement;
        double outMinX = inMinX + (double)inCellSize / 2.0 - (double)outCellSize / 2.0;
        double outMaxX = outMinX + (double)((float)outWidth * outCellSize);
        double outMaxY = inMaxY - (double)inCellSize / 2.0 + (double)outCellSize / 2.0;
        double outMinY = outMaxY - (double)((float)outHeight * outCellSize);
        EnteteRaster outEntete = new EnteteRaster(outWidth, outHeight, outMinX, outMaxX, outMinY, outMaxY, outCellSize, inEntete.noDataValue());
        float[] inData = coverage.getData();
        float[] outData = new float[outWidth * outHeight];
        int j = 0;
        int y = 0;
        while (j < inHeight) {
            int i = 0;
            int x = 0;
            while (i < inWidth) {
                outData[y * outWidth + x] = inData[j * inWidth + i];
                i += displacement;
                ++x;
            }
            j += displacement;
            ++y;
        }
        return new TabCoverage(outData, outEntete);
    }

    public static float[] extend(float[] inData, EnteteRaster inEntete, EnteteRaster outEntete, int displacement) {
        float[] outData = new float[outEntete.width() * outEntete.height()];
        Arrays.fill(outData, (float)outEntete.noDataValue());
        int j = 0;
        int y = 0;
        while (j < inEntete.height()) {
            int i = 0;
            int x = 0;
            while (i < inEntete.width()) {
                outData[y * outEntete.width() + x] = inData[j * inEntete.width() + i];
                ++i;
                x += displacement;
            }
            ++j;
            y += displacement;
        }
        return outData;
    }

    public static Coverage extendAndFill(Coverage inCoverage, Coverage refCoverage, int displacement) {
        int i;
        EnteteRaster outEntete = refCoverage.getEntete();
        float[] refData = refCoverage.getData();
        int outWidth = outEntete.width();
        int outHeight = outEntete.height();
        EnteteRaster inEntete = inCoverage.getEntete();
        float[] inData = inCoverage.getData(EnteteRaster.getROI(inEntete, outEntete.getEnvelope()));
        inEntete = EnteteRaster.getEntete(inEntete, outEntete.getEnvelope());
        int inWidth = inEntete.width();
        int inHeight = inEntete.height();
        float[] outData = new float[outWidth * outHeight];
        for (int j = 0; j < outHeight; ++j) {
            int y = CoordinateManager.getLocalY(inEntete, CoordinateManager.getProjectedY(outEntete, j));
            for (i = 0; i < outWidth; ++i) {
                int x = CoordinateManager.getLocalX(inEntete, CoordinateManager.getProjectedX(outEntete, i));
                outData[j * outWidth + i] = inData[y * inWidth + x];
            }
        }
        for (int j = 0; j < inHeight; ++j) {
            for (i = 0; i < inWidth; ++i) {
                float value = inData[j * inWidth + i];
                for (int y = j * displacement; y < j * displacement + displacement && y < outHeight; ++y) {
                    for (int x = i * displacement; x < i * displacement + displacement && x < outWidth; ++x) {
                        outData[y * outWidth + x] = refData[y * outWidth + x] != (float)outEntete.noDataValue() ? value : (float)outEntete.noDataValue();
                    }
                }
            }
        }
        return new TabCoverage(outData, outEntete);
    }

    public static Coverage extendAndFill(Coverage inCoverage, EnteteRaster outEntete, int displacement) {
        int i;
        int outWidth = outEntete.width();
        int outHeight = outEntete.height();
        EnteteRaster inEntete = inCoverage.getEntete();
        float[] inData = inCoverage.getData(EnteteRaster.getROI(inEntete, outEntete.getEnvelope()));
        inEntete = EnteteRaster.getEntete(inEntete, outEntete.getEnvelope());
        int inWidth = inEntete.width();
        int inHeight = inEntete.height();
        float[] outData = new float[outWidth * outHeight];
        Arrays.fill(outData, (float)outEntete.noDataValue());
        for (int j = 0; j < outHeight; ++j) {
            int y = CoordinateManager.getLocalY(inEntete, CoordinateManager.getProjectedY(outEntete, j));
            for (i = 0; i < outWidth; ++i) {
                int x = CoordinateManager.getLocalX(inEntete, CoordinateManager.getProjectedX(outEntete, i));
                outData[j * outWidth + i] = inData[y * inWidth + x];
            }
        }
        for (int j = 0; j < inHeight; ++j) {
            for (i = 0; i < inWidth; ++i) {
                float value = inData[j * inWidth + i];
                for (int y = j * displacement; y < j * displacement + displacement && y < outHeight; ++y) {
                    for (int x = i * displacement; x < i * displacement + displacement && x < outWidth; ++x) {
                        outData[y * outWidth + x] = value;
                    }
                }
            }
        }
        return new TabCoverage(outData, outEntete);
    }

    public static float[][] initThematicDistanceMap(String distanceFile) {
        if (new File(distanceFile).exists()) {
            try {
                CsvReader cr = new CsvReader(distanceFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                int max = -1;
                TreeSet<Integer> values = new TreeSet<Integer>();
                for (int h = 1; h < cr.getHeaderCount(); ++h) {
                    int value = Integer.parseInt(cr.getHeader(h));
                    values.add(value);
                    max = Math.max(max, value);
                }
                float[][] distances = new float[max + 1][max + 1];
                while (cr.readRecord()) {
                    int v1 = Integer.parseInt(cr.get("distance"));
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        float d;
                        int v2 = (Integer)iterator.next();
                        if (v2 > v1) continue;
                        distances[v1][v2] = d = Float.parseFloat(cr.get(v2 + ""));
                        distances[v2][v1] = d;
                    }
                }
                cr.close();
                return distances;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("WARNING: Thematic distance file " + distanceFile + " doesn't exists.");
        }
        return null;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format = new DecimalFormat("0.00000", symbols);
    }
}

