/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.awt.Rectangle;
import org.locationtech.jts.geom.Envelope;

public class ScriptMultipleSelected {
    public static void main(String[] args) {
        ScriptMultipleSelected.scriptMultipleSelected();
    }

    private static void scriptSplit() {
        Coverage cov = CoverageManager.getCoverage("C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/pf_2018_10m.tif");
        EnteteRaster enteteRef = cov.getEntete();
        Envelope env = new Envelope(362500.0, 364500.0, 6830000.0, 6832000.0);
        Rectangle roi = EnteteRaster.getROI(enteteRef, env);
        float[] data = cov.getData(roi);
        EnteteRaster entete = EnteteRaster.getEntete(enteteRef, env);
        cov.dispose();
        CoverageManager.write("C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/mini/landscape2.tif", data, entete);
    }

    private static void scriptMultipleSelected() {
        long begin = System.currentTimeMillis();
        String path = "C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.addRasterFile(path + "mini/landscape1.tif");
        builder.addRasterFile(path + "mini/landscape2.tif");
        builder.addMetric("SHDI");
        builder.addMetric("HET");
        builder.addMetric("NP");
        builder.addMetric("LPI");
        builder.addMetric("MPS");
        builder.setWindowSizes(new int[]{31, 51});
        builder.setPixelsFilter("C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/selected/pixels_pf.csv");
        builder.addCsvOutput(path + "mini/output/selected_pixels.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }
}

