/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.ClassificationPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.domain.DomainFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.util.HashMap;
import java.util.TreeMap;

public class ScriptLeoBoudric {
    private static String path = "H:/temp/leo_boudric/";

    public static void main(String[] args) {
        System.out.println("script pour Leo");
        ScriptLeoBoudric.scriptSliding();
    }

    private static void scriptSliding() {
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setWindowShapeType(WindowShapeType.CIRCLE);
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.addRasterFile(path + "data/INDICATEURS/BENTHOS GLOBAL_SG_classif.tif");
        builder.addMetric("pNV_1");
        builder.addMetric("pNV_2");
        builder.addMetric("pNV_3");
        builder.addMetric("pNV_4");
        builder.addMetric("pNV_5");
        builder.addMetric("NV_1");
        builder.addMetric("NV_2");
        builder.addMetric("NV_3");
        builder.addMetric("NV_4");
        builder.addMetric("NV_5");
        builder.addWindowSize(101);
        builder.setUnfilters(new int[]{0});
        builder.addCsvOutput(path + "sliding/analyse_BENTHOS GLOBAL_SG.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptClassificationIndicateur(String input, String output) {
        Coverage cov1 = CoverageManager.getCoverage(path + "data/INDICATEURS/BENTHOS GLOBAL_SG_clean.tif");
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        float[] data = new float[data1.length];
        HashMap<Domain<Float, Float>, Integer> domains = new HashMap<Domain<Float, Float>, Integer>();
        domains.put(DomainFactory.getFloatDomain("[0,0]"), 0);
        domains.put(DomainFactory.getFloatDomain("]0,3]"), 1);
        domains.put(DomainFactory.getFloatDomain("]3,4.5]"), 2);
        domains.put(DomainFactory.getFloatDomain("]4.5,5.5]"), 3);
        domains.put(DomainFactory.getFloatDomain("]5.5,7]"), 4);
        domains.put(DomainFactory.getFloatDomain("]7,]"), 5);
        ClassificationPixel2PixelTabCalculation cal = new ClassificationPixel2PixelTabCalculation(data, data1, entete.noDataValue(), domains);
        cal.run();
        CoverageManager.write(path + "data/INDICATEURS/BENTHOS GLOBAL_SG_classif.tif", data, entete);
    }

    private static void scriptCleanNoData(String inputFile, String outputFile) {
        Coverage cov1 = CoverageManager.getCoverage(inputFile);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        entete.setNoDataValue(-1);
        float[] data = new float[data1.length];
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(-3.4E38f), Float.valueOf(0.0f));
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, data1, sarMap);
        cal.run();
        CoverageManager.write(outputFile, data, entete);
    }
}

