/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.domain.DomainFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysis;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisBuilder;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.prep.PreparedPoint;

public class ScriptLea {
    private static final String path = "E:/temp/lea/";
    private static final String rasterBio = "E:/temp/lea/bio.tif";
    private static final String rasterOccSol = "E:/temp/lea/occsol.tif";
    private static final String rasterHaie = "E:/temp/lea/haie.tif";
    private static final String propCulture = "E:/temp/lea/prop_culture_5m.tif";
    private static final String propBois = "E:/temp/lea/prop_bois_5m.tif";
    private static final String propImpermeabilise = "E:/temp/lea/prop_impermeabilise_5m.tif";
    private static final String propEau = "E:/temp/lea/prop_eau_5m.tif";
    private static final String propHaie = "E:/temp/lea/prop_haie_5m.tif";
    private static final String propValidite = "E:/temp/lea/prop_validite_5m.tif";
    private static final String classifHaie = "E:/temp/lea/classification_haie_3classes_4_5m.tif";
    private static final String rasterDiversite = "E:/temp/lea/diversite3.tif";
    private static final String rasterParcelle = "E:/temp/lea/parcelle.tif";
    private static final String decision = "E:/temp/lea/decision_c65_b10_p14.tif";
    private static final String analyseParcelleParCategorie = "E:/temp/lea/analyse_parcelle_par_categorie_c65_b10_p14.csv";
    private static final String analyseCategorieParParcelle = "E:/temp/lea/analyse_categorie_par_parcelle_c65_b10_p14.csv";

    public static void main(String[] args) {
        ScriptLea.decision(0.14f);
        ScriptLea.analyseParcelle();
    }

    private static void decision(final float prop) {
        Coverage covBio = CoverageManager.getCoverage(rasterBio);
        EnteteRaster entete = covBio.getEntete();
        float[] dataBio = covBio.getData();
        covBio.dispose();
        Coverage covCulture = CoverageManager.getCoverage(propCulture);
        float[] dataCulture = covCulture.getData();
        covCulture.dispose();
        Coverage covBois = CoverageManager.getCoverage(propBois);
        float[] dataBois = covBois.getData();
        covBois.dispose();
        Coverage covImpermeabilise = CoverageManager.getCoverage(propImpermeabilise);
        float[] dataImpermeabilise = covImpermeabilise.getData();
        covImpermeabilise.dispose();
        Coverage covEau = CoverageManager.getCoverage(propEau);
        float[] dataEau = covEau.getData();
        covEau.dispose();
        Coverage covHaie = CoverageManager.getCoverage(classifHaie);
        float[] dataHaie = covHaie.getData();
        covHaie.dispose();
        Coverage covDiversite = CoverageManager.getCoverage(rasterDiversite);
        float[] dataDiversite = covDiversite.getData();
        covDiversite.dispose();
        Coverage covValidite = CoverageManager.getCoverage(propValidite);
        float[] dataValidite = covValidite.getData();
        covValidite.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataBio, dataCulture, dataBois, dataImpermeabilise, dataEau, dataHaie, dataDiversite, dataValidite}){

            @Override
            protected float doTreat(float[] v) {
                float vBio = v[0];
                float validite = v[7];
                if (vBio == -1.0f || validite < 1.0f) {
                    return -1.0f;
                }
                if ((double)v[1] > 0.65 && (double)v[2] < 0.1 && v[3] < prop && v[4] < prop) {
                    float vHaie = v[5];
                    float vDiversite = v[6];
                    if (vDiversite > 0.0f) {
                        if (vBio == 1.0f) {
                            switch ((int)vHaie) {
                                case 1: {
                                    return 1.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                                case 2: {
                                    return 2.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                                case 3: {
                                    return 3.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                            }
                        } else if (vBio == 2.0f) {
                            switch ((int)vHaie) {
                                case 1: {
                                    return 4.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                                case 2: {
                                    return 5.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                                case 3: {
                                    return 6.0f + (vDiversite - 1.0f) * 6.0f;
                                }
                            }
                        }
                    }
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write(decision, data, entete);
    }

    private static void analyseParcelle() {
        ScriptLea.analyseNbParcelleParCategorie();
        ScriptLea.analyseCategorieParParcelle();
    }

    private static void rasterisationParcelle(String parcelleShapeFile) {
        ShapeFile2CoverageConverter.rasterize(rasterParcelle, parcelleShapeFile, "code", 5.0f, -1, null);
    }

    private static void analyseNbParcelleParCategorie() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(rasterParcelle);
        builder.setEntityRasterFile(decision);
        builder.addMetric("Nclass");
        builder.addCsvOutput(analyseParcelleParCategorie);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseCategorieParParcelle() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(decision);
        builder.setEntityRasterFile(rasterParcelle);
        builder.addMetric("Majority");
        builder.addCsvOutput(analyseCategorieParParcelle);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseDiversite() {
        ScriptLea.rasterisationDiversite("E:/temp/lea/sequence_zaa_bio_diversity3_2015_2022.shp");
    }

    private static void rasterisationDiversite(String diversiteShapeFile) {
        ShapeFile2CoverageConverter.rasterize(rasterDiversite, diversiteShapeFile, "Diversity3", 5.0f, -1, null);
    }

    private static void analyseBio() {
        ScriptLea.rasterisationBio("E:/temp/lea/sequence_zaa_bio_2015_2022.shp");
    }

    private static void rasterisationBio(String bioShapeFile) {
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        codes.put("BIO", 1);
        codes.put("", 2);
        ShapeFile2CoverageConverter.rasterize(rasterBio, bioShapeFile, "bio_zaa", codes, 5.0f, -1, 0, null);
    }

    private static void analyseOccSol() {
        ScriptLea.analyseLandscapeOccSol();
    }

    private static void rasterisationOccSol(String occsolShapeFile) {
        Coverage cov = CoverageManager.getCoverage(rasterBio);
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        ShapeFile2CoverageConverter.rasterize(rasterOccSol, occsolShapeFile, "OS", -1.0f, entete);
    }

    private static void cleanOccSol() {
        HashMap<Float, Float> changes = new HashMap<Float, Float>();
        changes.put(Float.valueOf(23.0f), Float.valueOf(-1.0f));
        ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SEARCHANDREPLACE);
        ((ChloeAnalysisBuilder)builder).setRasterFile(rasterOccSol);
        ((ChloeAnalysisBuilder)builder).setChanges(changes);
        ((ChloeAnalysisBuilder)builder).setNoDataValue(-1);
        ((ChloeAnalysisBuilder)builder).addGeoTiffOutput(rasterOccSol);
        ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
        analysis.allRun();
    }

    private static void analyseLandscapeOccSol() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(rasterOccSol);
        builder.addMetric("pNVm_28&3000");
        builder.addMetric("pNV_6");
        builder.addMetric("pNVm_3&8&16&42");
        builder.addMetric("pNV_11");
        builder.addMetric("pN-valid");
        builder.setWindowSize(401);
        builder.addGeoTiffOutput("pNVm_28&3000", propCulture);
        builder.addGeoTiffOutput("pNV_6", propBois);
        builder.addGeoTiffOutput("pNVm_3&8&16&42", propImpermeabilise);
        builder.addGeoTiffOutput("pNV_11", propEau);
        builder.addGeoTiffOutput("pN-valid", propValidite);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseHaie() {
        ScriptLea.classificationHaie();
    }

    private static void recuperationHaie() {
        Coverage cov = CoverageManager.getCoverage(rasterBio);
        EnteteRaster refEntete = cov.getEntete();
        cov.dispose();
        Coverage haieCov = CoverageManager.getCoverage("E:/grain_bocager/data/35/2020/35_2020_type_boisement.tif");
        EnteteRaster entete = haieCov.getEntete();
        float[] data = haieCov.getData(EnteteRaster.getROI(entete, refEntete.getEnvelope()));
        haieCov.dispose();
        CoverageManager.write(rasterHaie, data, refEntete);
    }

    private static void analyseLandscapeHaie() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(rasterHaie);
        builder.addMetric("pNVm_1&10");
        builder.setWindowSize(401);
        builder.addGeoTiffOutput("pNVm_1&10", propHaie);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void classificationHaie() {
        HashMap<Domain<Float, Float>, Integer> domains = new HashMap<Domain<Float, Float>, Integer>();
        domains.put(DomainFactory.getFloatDomain("[0,0.065]"), 1);
        domains.put(DomainFactory.getFloatDomain("]0.065,0.095]"), 2);
        domains.put(DomainFactory.getFloatDomain("]0.095,]"), 3);
        ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.CLASSIFICATION);
        ((ChloeAnalysisBuilder)builder).setRasterFile(propHaie);
        ((ChloeAnalysisBuilder)builder).setDomains(domains);
        ((ChloeAnalysisBuilder)builder).addGeoTiffOutput(classifHaie);
        ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
        analysis.allRun();
    }

    private static void analyseLea() {
        String path = path;
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.setRasterFile(path + "haie_clean.tif");
        builder.setPointsFilter(path + "point_parcelle.csv");
        builder.setWindowSizes(new int[]{401});
        builder.addMetric("pNV_10");
        builder.addCsvOutput(path + "analyse_test1.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    public static void appelConnu() {
        String path = "E:/temp/lea/transfer_7227431_files_3b840578/";
        ScriptLea.generateShapefileConnues(path + "sequence_categories", path + "Territoires_EA_ZA_sud", path + "sequence_categories_connues");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateShapefileConnues(String inputSequence, String inputCoonue, String outputSequenceConnue) {
        try (FileOutputStream fos = new FileOutputStream(outputSequenceConnue + ".dbf");
             FileOutputStream shp = new FileOutputStream(outputSequenceConnue + ".shp");
             FileOutputStream shx = new FileOutputStream(outputSequenceConnue + ".shx");){
            Geometry g;
            ShpFiles sfConnue = new ShpFiles(inputCoonue + ".shp");
            ShapefileReader sfrConnue = new ShapefileReader(sfConnue, true, false, new GeometryFactory());
            HashSet<Geometry> parcellesConnues = new HashSet<Geometry>();
            while (sfrConnue.hasNext()) {
                g = (Geometry)sfrConnue.nextRecord().shape();
                parcellesConnues.add(g);
            }
            sfrConnue.close();
            ShpFiles sfSequence = new ShpFiles(inputSequence + ".shp");
            ShapefileReader sfrSequence = new ShapefileReader(sfSequence, true, false, new GeometryFactory());
            DbaseFileReader dfrSequence = new DbaseFileReader(sfSequence, true, Charset.defaultCharset());
            DbaseFileHeader headerSequence = dfrSequence.getHeader();
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfrSequence.getHeader().getNumRecords());
            for (int i = 0; i < headerSequence.getNumFields(); ++i) {
                header.addColumn(headerSequence.getFieldName(i), headerSequence.getFieldType(i), headerSequence.getFieldLength(i), headerSequence.getFieldDecimalCount(i));
            }
            header.addColumn("connue", 'c', 3, 0);
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfrSequence.getHeader().minX(), sfrSequence.getHeader().maxX(), sfrSequence.getHeader().minY(), sfrSequence.getHeader().maxY()), ShapeType.POLYGON, headerSequence.getNumRecords(), 1000000);
            Object[] entry = new Object[header.getNumFields()];
            while (sfrSequence.hasNext()) {
                Object[] data = dfrSequence.readEntry();
                for (int i = 0; i < headerSequence.getNumFields(); ++i) {
                    entry[i] = data[i];
                }
                g = (Geometry)sfrSequence.nextRecord().shape();
                PreparedPoint pp = new PreparedPoint((Puntal)g.getInteriorPoint());
                boolean isConnue = false;
                for (Geometry pConnue : parcellesConnues) {
                    if (!pp.intersects(pConnue)) continue;
                    isConnue = true;
                    break;
                }
                entry[headerSequence.getNumFields()] = isConnue ? "oui" : "non";
                sfw.writeGeometry(g);
                dfw.write(entry);
            }
            sfrSequence.close();
            dfrSequence.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Tool.copy(inputSequence + ".prj", outputSequenceConnue + ".prj");
        }
    }

    public static void appel(String[] args) {
        String path = path;
        ScriptLea.generateShapefile(path + "sequence_zaa_2015_2022", path + "bio_zaa_2022", "bio_zaa", "BIO", path + "sequence_zaa_bio_2015_2022");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateShapefile(String inputSequence, String inputBio, String bioColumn, String bioValue, String outputSequenceBio) {
        try (FileOutputStream fos = new FileOutputStream(outputSequenceBio + ".dbf");
             FileOutputStream shp = new FileOutputStream(outputSequenceBio + ".shp");
             FileOutputStream shx = new FileOutputStream(outputSequenceBio + ".shx");){
            Geometry g;
            ShpFiles sfBio = new ShpFiles(inputBio + ".shp");
            ShapefileReader sfrBio = new ShapefileReader(sfBio, true, false, new GeometryFactory());
            DbaseFileReader dfrBio = new DbaseFileReader(sfBio, true, Charset.defaultCharset());
            DbaseFileHeader headerBio = dfrBio.getHeader();
            int indexBio = -1;
            for (int i = 0; i < headerBio.getNumFields(); ++i) {
                if (!headerBio.getFieldName(i).equalsIgnoreCase(bioColumn)) continue;
                indexBio = i;
                break;
            }
            HashSet<Geometry> parcellesBio = new HashSet<Geometry>();
            while (sfrBio.hasNext()) {
                g = (Geometry)sfrBio.nextRecord().shape();
                Object[] data = dfrBio.readEntry();
                if (!data[indexBio].toString().equalsIgnoreCase(bioValue)) continue;
                parcellesBio.add(g);
            }
            sfrBio.close();
            dfrBio.close();
            ShpFiles sfSequence = new ShpFiles(inputSequence + ".shp");
            ShapefileReader sfrSequence = new ShapefileReader(sfSequence, true, false, new GeometryFactory());
            DbaseFileReader dfrSequence = new DbaseFileReader(sfSequence, true, Charset.defaultCharset());
            DbaseFileHeader headerSequence = dfrSequence.getHeader();
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfrSequence.getHeader().getNumRecords());
            for (int i = 0; i < headerSequence.getNumFields(); ++i) {
                header.addColumn(headerSequence.getFieldName(i), headerSequence.getFieldType(i), headerSequence.getFieldLength(i), headerSequence.getFieldDecimalCount(i));
            }
            header.addColumn(bioColumn, 'c', 3, 0);
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfrSequence.getHeader().minX(), sfrSequence.getHeader().maxX(), sfrSequence.getHeader().minY(), sfrSequence.getHeader().maxY()), ShapeType.POLYGON, headerSequence.getNumRecords(), 1000000);
            Object[] entry = new Object[header.getNumFields()];
            while (sfrSequence.hasNext()) {
                Object[] data = dfrSequence.readEntry();
                for (int i = 0; i < headerSequence.getNumFields(); ++i) {
                    entry[i] = data[i];
                }
                g = (Geometry)sfrSequence.nextRecord().shape();
                PreparedPoint pp = new PreparedPoint((Puntal)g.getInteriorPoint());
                boolean isBio = false;
                for (Geometry pBio : parcellesBio) {
                    if (!pp.intersects(pBio)) continue;
                    isBio = true;
                    break;
                }
                entry[headerSequence.getNumFields()] = isBio ? bioValue : "";
                sfw.writeGeometry(g);
                dfw.write(entry);
            }
            sfrSequence.close();
            dfrSequence.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Tool.copy(inputSequence + ".prj", outputSequenceBio + ".prj");
        }
    }
}

