/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.slope.TabInverseAltitudeRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.slope.TabInverseSlopeDirectionRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.File;
import org.locationtech.jts.geom.Envelope;

public class ScriptErosionRuissellement {
    private static final String path = "E:/temp/slope/test2/data/";
    private static final String bv = "E:/temp/slope/test2/data/bv.tif";
    private static final String bv_troncon_hydrographique = "E:/temp/slope/test2/data/bv_troncon_hydrographique.tif";
    private static final String bv_surface_hydrographique = "E:/temp/slope/test2/data/bv_surface_hydrographique.tif";
    private static final String bv_reseau_hydrographique = "E:/temp/slope/test2/data/bv_reseau_hydrographique_plat.tif";
    private static final String bv_altitude = "E:/temp/slope/test2/data/bv_altitude.tif";
    private static final String bv_altitude_lisse = "E:/temp/slope/test2/data/bv_altitude_lisse.tif";
    private static final String bv_intensity = "E:/temp/slope/test2/data/bv_intensity_brute.tif";
    private static final String bv_direction = "E:/temp/slope/test2/data/bv_direction_brute.tif";
    private static final String bv_slope = "E:/temp/slope/test2/data/bv_slope.tif";
    private static final String bv_creux = "E:/temp/slope/test2/data/bv_creux.tif";
    private static final String bv_os = "E:/temp/slope/test2/data/bv_os.tif";
    private static final String bv_abattement = "E:/temp/slope/test2/data/bv_abattement.tif";
    private static final String bv_distance_eau = "E:/temp/slope/test2/data/bv_distance_eau.tif";
    private static final String bv_distance_eau_altitude = "E:/temp/slope/test2/data/bv_distance_eau_altitude_bis.tif";
    private static final String bv_distance_eau_direction = "E:/temp/slope/test2/data/bv_distance_eau_direction_brute_reseau_plat.tif";
    private static final String bv_coef_distance_eau = "E:/temp/slope/test2/data/bv_coef_distance_eau_reseau_plat.tif";
    private static final String bv_coeff_versement = "E:/temp/slope/test2/data/bv_coeff_versement.tif";
    private static final String bv_risque_erosif_local = "E:/temp/slope/test2/data/bv_risque_erosif_local_brute.tif";
    private static final String bv_risque_erosif = "E:/temp/slope/test2/data/bv_risque_erosif_reseau_plat.tif";

    public static void main(String[] args) {
        ScriptErosionRuissellement.convertRGE();
        ScriptErosionRuissellement.recuperationBV();
        ScriptErosionRuissellement.recuperationAltitude();
        ScriptErosionRuissellement.recuperationTronconHydrographique();
        ScriptErosionRuissellement.recuperationReseauHydrographique();
        ScriptErosionRuissellement.generationFrictionAbattement();
        ScriptErosionRuissellement.recuperationOccupationSolAmenagement();
    }

    private static void recuperationReseauHydrographique() {
        Coverage covS = CoverageManager.getCoverage(bv_surface_hydrographique);
        EnteteRaster entete = covS.getEntete();
        float[] dataS = covS.getData();
        covS.dispose();
        Coverage covC = CoverageManager.getCoverage(bv_creux);
        float[] dataC = covC.getData();
        covC.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataS, dataC}){

            @Override
            protected float doTreat(float[] v) {
                float vS = v[0];
                if (vS == -1.0f) {
                    return -1.0f;
                }
                float vC = v[1];
                if (vC == 2.0f || vC == 1.0f) {
                    return 1.0f;
                }
                return vS;
            }
        };
        cal.run();
        CoverageManager.write(bv_reseau_hydrographique, data, entete);
    }

    private static void detectioncreux() {
        Coverage cov = CoverageManager.getCoverage(bv_intensity);
        EnteteRaster entete = cov.getEntete();
        float[] dataInt = cov.getData();
        cov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataInt}){

            @Override
            protected float doTreat(float[] v) {
                float vInt = v[0];
                if (vInt == -1.0f) {
                    return -1.0f;
                }
                if (vInt == 90.0f) {
                    return 1.0f;
                }
                if (vInt > 90.0f) {
                    return 2.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_creux, data, entete);
    }

    private static void test() {
        double vc = 60.0;
        double v = 58.0;
        double diffHauteur = vc - v;
        double diffDistance = 5.0;
        double tangente = diffDistance / diffHauteur;
        double slopeIntensity = (90.0 + (90.0 + Math.toDegrees(Math.atan(tangente)))) % 180.0;
        System.out.println(tangente + " " + slopeIntensity);
        v = 62.0;
        diffHauteur = vc - v;
        diffDistance = 5.0;
        tangente = diffDistance / diffHauteur;
        slopeIntensity = (90.0 + (90.0 + Math.toDegrees(Math.atan(tangente)))) % 180.0;
        System.out.println(tangente + " " + slopeIntensity);
    }

    private static void calculRisqueErosif() {
        Coverage covCDE = CoverageManager.getCoverage(bv_coef_distance_eau);
        EnteteRaster entete = covCDE.getEntete();
        float[] dataCDE = covCDE.getData();
        covCDE.dispose();
        Coverage covREL = CoverageManager.getCoverage(bv_risque_erosif_local);
        float[] dataREL = covREL.getData();
        covREL.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataCDE, dataREL}){

            @Override
            protected float doTreat(float[] v) {
                float vcde = v[0];
                if (vcde == -1.0f) {
                    return -1.0f;
                }
                return vcde * v[1];
            }
        };
        cal.run();
        CoverageManager.write(bv_risque_erosif, data, entete);
    }

    private static void calculCoeffDistanceEau() {
        Coverage covED = CoverageManager.getCoverage(bv_distance_eau_direction);
        EnteteRaster entete = covED.getEntete();
        float[] dataED = covED.getData();
        covED.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataED}){

            @Override
            protected float doTreat(float[] v) {
                float vED = v[0];
                if (vED == -1.0f) {
                    return -1.0f;
                }
                if (vED > 5000.0f) {
                    return 0.0f;
                }
                return (5000.0f - vED) / 5000.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_coef_distance_eau, data, entete);
    }

    private static void calculRisqueErosifLocal() {
        Coverage osSlope = CoverageManager.getCoverage(bv_slope);
        EnteteRaster entete = osSlope.getEntete();
        float[] dataSlope = osSlope.getData();
        osSlope.dispose();
        Coverage osVers = CoverageManager.getCoverage(bv_coeff_versement);
        float[] dataVers = osVers.getData();
        osVers.dispose();
        float[] dataSlopeVers = new float[dataSlope.length];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(dataSlopeVers, new float[][]{dataSlope, dataVers}){

            @Override
            protected float doTreat(float[] v) {
                float vs = v[0];
                if (vs != -1.0f) {
                    return vs * v[1];
                }
                return -1.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_risque_erosif_local, dataSlopeVers, entete);
    }

    private static void cleanIntensite() {
        Coverage intCov = CoverageManager.getCoverage(bv_intensity);
        EnteteRaster entete = intCov.getEntete();
        float[] intData = intCov.getData();
        intCov.dispose();
        float[] data = new float[intData.length];
        for (int ind = 0; ind < intData.length; ++ind) {
            double v = intData[ind];
            if (v != (double)entete.noDataValue()) {
                if (v <= 45.0) {
                    data[ind] = 1.0f;
                    continue;
                }
                data[ind] = (float)((90.0 - v) / 45.0);
                continue;
            }
            data[ind] = entete.noDataValue();
        }
        CoverageManager.write(bv_slope, data, entete);
    }

    private static void detectionPente() {
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        EnteteRaster entete = altCov.getEntete();
        float[] altData = altCov.getData();
        altCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTab(altData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("slopedirection");
        builder.addMetric("slopeintensity");
        builder.setWindowSize(3);
        builder.addGeoTiffOutput("slopedirection", bv_direction);
        builder.addGeoTiffOutput("slopeintensity", bv_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculDistanceFromEauWithDirection() {
        Coverage eauCov = CoverageManager.getCoverage(bv_reseau_hydrographique);
        EnteteRaster entete = eauCov.getEntete();
        float[] eauData = eauCov.getData();
        eauCov.dispose();
        Coverage abbCov = CoverageManager.getCoverage(bv_abattement);
        float[] abbData = abbCov.getData();
        abbCov.dispose();
        Coverage dirCov = CoverageManager.getCoverage(bv_direction);
        float[] dirData = dirCov.getData();
        dirCov.dispose();
        float[] data = new float[eauData.length];
        TabInverseSlopeDirectionRCMDistanceAnalysis analysis = new TabInverseSlopeDirectionRCMDistanceAnalysis(data, eauData, abbData, dirData, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1});
        analysis.allRun();
        CoverageManager.write(bv_distance_eau_direction, data, entete);
    }

    private static void calculDistanceFromEauWithAltitude() {
        Coverage eauCov = CoverageManager.getCoverage(bv_surface_hydrographique);
        EnteteRaster entete = eauCov.getEntete();
        float[] eauData = eauCov.getData();
        eauCov.dispose();
        Coverage abbCov = CoverageManager.getCoverage(bv_abattement);
        float[] abbData = abbCov.getData();
        abbCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude_lisse);
        float[] altData = altCov.getData();
        altCov.dispose();
        float[] data = new float[eauData.length];
        TabInverseAltitudeRCMDistanceAnalysis analysis = new TabInverseAltitudeRCMDistanceAnalysis(data, eauData, abbData, altData, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1}, 1000);
        analysis.allRun();
        CoverageManager.write(bv_distance_eau_altitude, data, entete);
    }

    private static void calculDistanceFromEau() {
        Coverage eauCov = CoverageManager.getCoverage(bv_surface_hydrographique);
        EnteteRaster entete = eauCov.getEntete();
        float[] eauData = eauCov.getData();
        eauCov.dispose();
        Coverage abbCov = CoverageManager.getCoverage(bv_abattement);
        float[] abbData = abbCov.getData();
        abbCov.dispose();
        float[] data = new float[eauData.length];
        TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(data, eauData, abbData, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1});
        analysis.allRun();
        CoverageManager.write(bv_distance_eau, data, entete);
    }

    private static void generationFrictionAbattement() {
        Coverage osCov = CoverageManager.getCoverage(bv_os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[osData.length];
        block15: for (int ind = 0; ind < osData.length; ++ind) {
            int vos = (int)osData[ind];
            switch (vos) {
                case -1: {
                    data[ind] = osEntete.noDataValue();
                    continue block15;
                }
                case 1: {
                    data[ind] = 1.0f;
                    continue block15;
                }
                case 2: {
                    data[ind] = 2.0f;
                    continue block15;
                }
                case 3: {
                    data[ind] = 5.0f;
                    continue block15;
                }
                case 4: {
                    data[ind] = 100.0f;
                    continue block15;
                }
                case 5: {
                    data[ind] = 100.0f;
                    continue block15;
                }
                case 6: {
                    data[ind] = 10.0f;
                    continue block15;
                }
                case 7: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 8: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 9: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 10: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 11: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 12: {
                    data[ind] = 0.0f;
                }
            }
        }
        CoverageManager.write(bv_abattement, data, osEntete);
    }

    private static void generationCoeffVersement() {
        Coverage osCov = CoverageManager.getCoverage(bv_os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[osData.length];
        block15: for (int ind = 0; ind < osData.length; ++ind) {
            int vos = (int)osData[ind];
            switch (vos) {
                case -1: {
                    data[ind] = osEntete.noDataValue();
                    continue block15;
                }
                case 1: {
                    data[ind] = 1.0f;
                    continue block15;
                }
                case 2: {
                    data[ind] = 0.25f;
                    continue block15;
                }
                case 3: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 4: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 5: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 6: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 7: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 8: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 9: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 10: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 11: {
                    data[ind] = 0.0f;
                    continue block15;
                }
                case 12: {
                    data[ind] = 0.0f;
                }
            }
        }
        CoverageManager.write(bv_coeff_versement, data, osEntete);
    }

    private static void recuperationOccupationSol() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage osCov = CoverageManager.getCoverage("G:/data/sig/bretagne/Bretagne_2019_dispositif_bocage_ebr.tif");
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData(EnteteRaster.getROI(osEntete, bvEntete.getEnvelope()));
        osCov.dispose();
        for (int ind = 0; ind < osData.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            osData[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write("H:/temp/slope/test/data/bv_os.tif", osData, bvEntete);
    }

    private static void recuperationOccupationSolAmenagement() {
        Coverage cov = CoverageManager.getCoverage("H:/temp/slope/test/data/bv_os.tif");
        EnteteRaster entete = cov.getEntete();
        float[] dataOS = cov.getData();
        cov.dispose();
        Coverage covAmenagement = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/temp/slope/test/data/amenagement_bocager.shp", entete, 4.0f, 0.0f);
        float[] dataAm = covAmenagement.getData();
        covAmenagement.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataOS, dataAm}){

            @Override
            protected float doTreat(float[] v) {
                float vam = v[1];
                if (vam == 4.0f) {
                    return vam;
                }
                return v[0];
            }
        };
        cal.run();
        CoverageManager.write("H:/temp/slope/test/data/bv_os_amenagement.tif", data, entete);
    }

    private static void recuperationSurfaceHydrographique() {
        Coverage thCov = CoverageManager.getCoverage(bv_troncon_hydrographique);
        EnteteRaster thEntete = thCov.getEntete();
        float[] thData = thCov.getData();
        thCov.dispose();
        Coverage osCov = CoverageManager.getCoverage(bv_os);
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[thData.length];
        for (int ind = 0; ind < osData.length; ++ind) {
            data[ind] = thData[ind] == (float)thEntete.noDataValue() ? (float)thEntete.noDataValue() : (thData[ind] == 1.0f || osData[ind] == 7.0f ? 1.0f : 0.0f);
        }
        CoverageManager.write(bv_surface_hydrographique, data, thEntete);
    }

    private static void recuperationTronconHydrographique() {
        Coverage bvCov = CoverageManager.getCoverage("H:/temp/slope/test/data/bv.tif");
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage("G:/data/sig/bd_topo/archive/2019/BDTOPO_3-0_TOUSTHEMES_SHP_LAMB93_D035_2019-06-20/BDTOPO/1_DONNEES_LIVRAISON_2019-06-00361/BDT_3-0_SHP_LAMB93_D035-ED2019-06-20/HYDROGRAPHIE/TRONCON_HYDROGRAPHIQUE.shp", bvEntete, 1.0f, 0.0f);
        float[] data = cov.getData();
        cov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write("H:/temp/slope/test/data/bv_troncon_hydrographique.tif", data, bvEntete);
    }

    private static void cleanAltitude() {
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        EnteteRaster entete = altCov.getEntete();
        float[] altData = altCov.getData();
        altCov.dispose();
        float[] data = new float[altData.length];
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setWindowSize(15);
        builder.setUnfilters(new int[]{-1});
        builder.setRasterTab(altData);
        builder.setEntete(entete);
        builder.addMetric("average");
        builder.addTabOutput(data);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        CoverageManager.write(bv_altitude_lisse, data, entete);
    }

    private static void recuperationAltitude() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage altCov = CoverageManager.getCoverage("G:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D035_2020-01-27/RGEALTI/1_DONNEES_LIVRAISON_2020-04-00197/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035_geotiff/");
        EnteteRaster entete = altCov.getEntete();
        float[] data = altCov.getData(EnteteRaster.getROI(entete, bvEntete.getEnvelope()));
        altCov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(bv_altitude, data, bvEntete);
    }

    private static void recuperationBV() {
        Envelope envelope = ShapeFile2CoverageConverter.getEnvelope("H:/temp/slope/test/data/bv.shp", 0.0);
        Coverage refCov = CoverageManager.getCoverage("G:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D035_2020-01-27/RGEALTI/1_DONNEES_LIVRAISON_2020-04-00197/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035_geotiff/");
        EnteteRaster refEntete = refCov.getEntete();
        refCov.dispose();
        refEntete.setNoDataValue(-1);
        EnteteRaster entete = EnteteRaster.getEntete(refEntete, envelope);
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/temp/slope/test/data/bv.shp", entete, 1.0f, -1.0f);
        float[] data = cov.getData();
        cov.dispose();
        CoverageManager.write(bv, data, entete);
    }

    private static void convertRGE() {
        String path = "G:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D035_2020-01-27/RGEALTI/1_DONNEES_LIVRAISON_2020-04-00197/";
        String inputPath = "RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035/";
        String outputPath = "RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035_geotiff/";
        for (String file : new File(path + inputPath).list()) {
            if (!file.endsWith(".asc")) continue;
            ScriptErosionRuissellement.convert(path, inputPath, outputPath, file);
        }
    }

    private static void convert(String globalPath, String inputPath, String outputPath, String file) {
        Util.createAccess(globalPath + outputPath);
        Coverage cov = CoverageManager.getCoverage(globalPath + inputPath + file);
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        CoverageManager.write(globalPath + outputPath + file.replace(".asc", ".tif"), data, entete);
    }

    private static void cleanDirection() {
        Coverage dirCov = CoverageManager.getCoverage(bv_direction);
        EnteteRaster entete = dirCov.getEntete();
        float[] dirData = dirCov.getData();
        dirCov.dispose();
        for (int ind = 0; ind < dirData.length; ++ind) {
            int vd = (int)dirData[ind];
            if (vd != 0) continue;
            dirData[ind] = 9.0f;
        }
        float[] data = new float[dirData.length];
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setWindowSize(3);
        builder.setRasterTab(dirData);
        builder.setEntete(entete);
        builder.addMetric("Majority");
        builder.addTabOutput(data);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        for (int ind = 0; ind < data.length; ++ind) {
            int vd = (int)data[ind];
            if (vd != 9) continue;
            data[ind] = 0.0f;
        }
        CoverageManager.write("H:/temp/slope/test/data/bv_direction_clean_sq_3.tif", data, entete);
    }

    private static void recuperationDirection() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage dirCov = CoverageManager.getCoverage("H:/temp/slope/direction/");
        EnteteRaster entete = dirCov.getEntete();
        float[] data = dirCov.getData(EnteteRaster.getROI(entete, bvEntete.getEnvelope()));
        dirCov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(bv_direction, data, bvEntete);
    }

    private static void recuperationIntensity() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage intCov = CoverageManager.getCoverage("H:/temp/slope/intensity/");
        EnteteRaster entete = intCov.getEntete();
        float[] data = intCov.getData(EnteteRaster.getROI(entete, bvEntete.getEnvelope()));
        intCov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(bv_intensity, data, bvEntete);
    }
}

