/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.util.FileMap;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.util.HashMap;
import org.locationtech.jts.geom.Envelope;

public class ScriptErosionMagdelaine {
    private static final String path = "C:/Data/projet/coterra/essai_petit_magdelaine/data/";
    private static final String bv = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_magdelaine.tif";
    private static final String bv_os_bre = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_magdelaine_OSO_bre.tif";
    private static final String bv_os = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_magdelaine_OS.tif";
    private static final String bv_altitude = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_altitude.tif";
    private static final String bv_infiltration_map = "C:/Data/projet/coterra/essai_petit_magdelaine/data/infiltration_map.txt";
    private static final String bv_versement_map = "C:/Data/projet/coterra/essai_petit_magdelaine/data/versement_map.txt";
    private static final String bocageAmenagement = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bocage_amenagement.shp";
    private static final String bv_os_prairie = "C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_magdelaine_OS_prairie.tif";
    private static final int quantitetEAU = 10;
    private static final int displacement = 1;
    private static final String bv_slope_intensity = "bv_slope_intensity.tif";
    private static final String bv_infiltration = "bv_infiltration.tif";
    private static final String bv_versement = "bv_versement.tif";
    private static final String bv_masse_eau_initial = "bv_masse_eau_initial_10mm.tif";
    private static final String bv_masse_eau_cumul = "bv_masse_eau_cumul_10mm.tif";
    private static final String bv_intensite_versement = "bv_intensite_versement_10mm.tif";
    private static final String bv_source_erosion_intensity = "bv_source_erosion_intensity_10mm.tif";
    private static final String bv_depot_erosion_intensity = "bv_depot_erosion_intensity_10mm.tif";
    private static final String bv_degat_erosion_intensity = "bv_degat_erosion_intensity_10mm.tif";
    private static final String bv_norm_slope_intensity = "bv_norm_slope_intensity.tif";
    private static final String bv_norm_source_erosion_intensity = "bv_norm_source_erosion_intensity_10mm.tif";

    public static void main(String[] args) {
        ScriptErosionMagdelaine.analyseErosion();
    }

    private static void analyseErosion() {
        String outputPath = "C:/Data/projet/coterra/essai_petit_magdelaine/data/test2_10mm/";
        Util.createAccess(outputPath);
        ScriptErosionMagdelaine.detectionPente(outputPath);
        ScriptErosionMagdelaine.normalizeSlopeIntensity(outputPath);
        ScriptErosionMagdelaine.generationMasseEau(outputPath);
        ScriptErosionMagdelaine.generationInfiltrationMap(outputPath, 0.25f);
        ScriptErosionMagdelaine.generationVersementMap(outputPath, 1.0f);
        ScriptErosionMagdelaine.generationCumulMasseEau(outputPath, bv_masse_eau_cumul, 1, 201);
        ScriptErosionMagdelaine.generationIntensiteVersement(outputPath);
        ScriptErosionMagdelaine.calculErosion(outputPath, 1, 201);
    }

    private static void remoteSensing() {
        for (int inf = 25; inf <= 50; inf += 5) {
            for (int ver = 50; ver <= 100; ver += 10) {
                String outputPath = "C:/Data/projet/coterra/essai_petit_magdelaine/data/remote_sensing3/erosion_f" + inf + "_v" + ver + "/";
                ScriptErosionMagdelaine.noteSourceErosion(outputPath);
            }
        }
    }

    private static void noteSourceErosion(String outputPath) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.MAP);
        builder.addRasterFile(outputPath + bv_norm_source_erosion_intensity);
        builder.addMetric("average");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void generationCumulMasseEau(String outputPath, String masseEauCumul, int displacement, int windowSize) {
        Coverage massInitCov = CoverageManager.getCoverage(outputPath + bv_masse_eau_initial);
        EnteteRaster entete = massInitCov.getEntete();
        float[] massInitData = massInitCov.getData();
        massInitCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(outputPath + bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        Coverage slopIntCov = CoverageManager.getCoverage(outputPath + bv_slope_intensity);
        float[] slopIntData = slopIntCov.getData();
        slopIntCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(massInitData, altData, infilData, slopIntData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("mass-cumul");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addGeoTiffOutput("degat-mass-cumul", outputPath + masseEauCumul);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculErosion(String outputPath, int displacement, int windowSize) {
        Coverage intVersCov = CoverageManager.getCoverage(outputPath + bv_intensite_versement);
        EnteteRaster entete = intVersCov.getEntete();
        float[] intVersData = intVersCov.getData();
        intVersCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(outputPath + bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        Coverage slopIntCov = CoverageManager.getCoverage(outputPath + bv_slope_intensity);
        float[] slopIntData = slopIntCov.getData();
        slopIntCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(intVersData, altData, infilData, slopIntData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("mass-cumul");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addGeoTiffOutput("mass-cumul", outputPath + bv_source_erosion_intensity);
        builder.addGeoTiffOutput("degat-mass-cumul", outputPath + bv_degat_erosion_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculDegatErosion(int displacement, boolean interpolation, int windowSize) {
        Coverage massInitCov = CoverageManager.getCoverage(bv_intensite_versement);
        EnteteRaster entete = massInitCov.getEntete();
        float[] massInitData = massInitCov.getData();
        massInitCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        Coverage slopIntCov = CoverageManager.getCoverage(bv_slope_intensity);
        float[] slopIntData = slopIntCov.getData();
        slopIntCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(massInitData, altData, infilData, slopIntData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("degat-erosion-intensity");
        builder.setWindowSize(windowSize);
        builder.setDMax(2500.0);
        builder.setDisplacement(displacement);
        builder.setInterpolation(interpolation);
        builder.addGeoTiffOutput("degat-erosion-intensity", bv_degat_erosion_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void normalizeSlopeIntensity(String outputPath) {
        Coverage intCov = CoverageManager.getCoverage(outputPath + bv_slope_intensity);
        float[] intData = intCov.getData();
        EnteteRaster entete = intCov.getEntete();
        intCov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{intData}){

            @Override
            protected float doTreat(float[] v) {
                float vi = v[0];
                if (vi == -1.0f) {
                    return -1.0f;
                }
                return ScriptErosionMagdelaine.getSlopeIntensity(vi);
            }
        };
        cal.run();
        CoverageManager.write(outputPath + bv_norm_slope_intensity, data, entete);
    }

    private static void generationIntensiteVersement(String outputPath) {
        Coverage versCov = CoverageManager.getCoverage(outputPath + bv_versement);
        EnteteRaster outEntete = versCov.getEntete();
        float[] versData = versCov.getData();
        versCov.dispose();
        Coverage degatCov = CoverageManager.getCoverage(outputPath + bv_masse_eau_cumul);
        EnteteRaster inEntete = degatCov.getEntete();
        float[] degatData = Util.extend(degatCov.getData(), inEntete, outEntete, 1);
        degatCov.dispose();
        Coverage intCov = CoverageManager.getCoverage(outputPath + bv_norm_slope_intensity);
        float[] intData = intCov.getData();
        intCov.dispose();
        float[] data = new float[outEntete.width() * outEntete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{versData, degatData, intData}){

            @Override
            protected float doTreat(float[] v) {
                float vv = v[0];
                if (vv == -1.0f) {
                    return -1.0f;
                }
                float vd = v[1];
                float vi = v[2];
                if (vi > 0.0f && vd != -1.0f) {
                    return vv * vd * vi;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write(outputPath + bv_intensite_versement, data, outEntete);
    }

    private static void generationMasseEau(String outputPath) {
        Coverage cov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster entete = cov.getEntete();
        float[] bvData = cov.getData();
        cov.dispose();
        float masseInitiale = (float)(10.0 * Math.pow(entete.cellsize(), 2.0));
        float[] data = new float[entete.width() * entete.height()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = bvData[i] == -1.0f ? -1.0f : masseInitiale;
        }
        CoverageManager.write(outputPath + bv_masse_eau_initial, data, entete);
    }

    private static void normalize(String outputPath, String input, String output, final int max) {
        Coverage cov = CoverageManager.getCoverage(outputPath + input);
        EnteteRaster entete = cov.getEntete();
        float[] data = cov.getData();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value == -1.0f) {
                    return -1.0f;
                }
                return value / (float)max;
            }
        };
        cal.run();
        CoverageManager.write(outputPath + output, outData, entete);
    }

    private static void factor(String input1, String input2, String output) {
        Coverage cov1 = CoverageManager.getCoverage(input1);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage(input2);
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 == -1.0f) {
                    return -1.0f;
                }
                return v1 * v[1];
            }
        };
        cal.run();
        CoverageManager.write(output, outData, entete);
    }

    private static void recuperationOccupationSolAmenagement() {
        Coverage cov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster entete = cov.getEntete();
        float[] dataOS = cov.getData();
        cov.dispose();
        Coverage covAmenagement = ShapeFile2CoverageConverter.getSurfaceCoverage(bocageAmenagement, entete, 25.0f, 0.0f);
        float[] dataAm = covAmenagement.getData();
        covAmenagement.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{dataOS, dataAm}){

            @Override
            protected float doTreat(float[] v) {
                float vam = v[1];
                if (vam == 25.0f) {
                    return vam;
                }
                return v[0];
            }
        };
        cal.run();
        CoverageManager.write("C:/Data/projet/coterra/essai_petit_magdelaine/data/bv_magdelaine_OS_amenagement.tif", data, entete);
    }

    private static float getSlopeIntensity(float alt, float nalt, float cote_adjacent) {
        if (alt == nalt) {
            return 0.0f;
        }
        float cote_oppose = alt - nalt;
        float tangente = cote_oppose / cote_adjacent;
        double arctangente = Math.atan(tangente);
        double angle = Math.toDegrees(arctangente);
        float v = (float)((90.0 - angle) % 180.0);
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    private static float getSlopeIntensity(float slopIntMax) {
        float v = slopIntMax;
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    private static float friction(float slopeIntensity, float infiltration) {
        float friction = (float)Math.pow(1.0f - slopeIntensity, 5.0) + (float)(100.0 * Math.pow(infiltration, 2.0));
        System.out.println(slopeIntensity + " " + infiltration + " " + friction);
        return friction;
    }

    private static void calculTestCompression() {
        Coverage cov = CoverageManager.getCoverage(bv_altitude);
        EnteteRaster entete = cov.getEntete();
        float[] data = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/test_compression/altitude_LZW.tif");
        entete = cov.getEntete();
        data = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/test_compression/altitude_ZLib.tif");
        entete = cov.getEntete();
        data = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/test_compression/altitude_PackBits.tif");
        entete = cov.getEntete();
        data = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/test_compression/altitude_Deflate.tif");
        entete = cov.getEntete();
        data = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/test_compression/altitude_ZSTD.tif");
        entete = cov.getEntete();
        data = cov.getData();
        cov.dispose();
    }

    private static void detectionPente(String outputPath) {
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        EnteteRaster entete = altCov.getEntete();
        float[] altData = altCov.getData();
        altCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTab(altData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("slope-intensity");
        builder.setWindowSize(3);
        builder.addGeoTiffOutput("slope-intensity", outputPath + bv_slope_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void generationInfiltrationMap() {
        Coverage osCov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_infiltration_map, "cover", "infiltration");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(bv_infiltration, data, osEntete);
    }

    private static void generationVersementMap() {
        Coverage osCov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_versement_map, "cover", "versement");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(bv_versement, data, osEntete);
    }

    private static void generationInfiltrationMap(String outputPath, float infiltration) {
        Coverage osCov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_infiltration_map, "cover", "infiltration");
        fMap.change(5.0f, infiltration);
        fMap.change(6.0f, infiltration);
        fMap.change(7.0f, infiltration);
        fMap.change(9.0f, infiltration);
        fMap.change(10.0f, infiltration);
        fMap.change(13.0f, infiltration);
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(outputPath + bv_infiltration, data, osEntete);
    }

    private static void generationVersementMap(String outputPath, float versement) {
        Coverage osCov = CoverageManager.getCoverage(bv_os_prairie);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_versement_map, "cover", "versement");
        fMap.change(5.0f, versement);
        fMap.change(6.0f, versement);
        fMap.change(7.0f, versement);
        fMap.change(9.0f, versement);
        fMap.change(10.0f, versement);
        fMap.change(13.0f, versement);
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(outputPath + bv_versement, data, osEntete);
    }

    private static void generationIntensiteVersementMap() {
        Coverage cov1 = CoverageManager.getCoverage(bv_slope_intensity);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage(bv_versement);
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                float vInt = v[0];
                if (vInt == -1.0f) {
                    return -1.0f;
                }
                vInt = 90.0f - Math.min(vInt, 90.0f);
                float vVers = v[1];
                return vInt * vVers * 100.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_intensite_versement, data, entete);
    }

    private static void recuperePrairieFromRPG() {
        Coverage bvCov = CoverageManager.getCoverage(bv_os);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        codes.put("PPH", 24);
        codes.put("PRL", 24);
        codes.put("SPH", 24);
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/rpg/parcelle_rpg_2020.shp", "CODE_CULTU", codes, bvEntete, -1.0f);
        float[] data = cov.getData();
        cov.dispose();
        float[] outData = new float[bvEntete.width() * bvEntete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{bvData, data}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 != -1.0f) {
                    float v2 = v[1];
                    if (v1 == 25.0f || v1 == 23.0f || v1 == 27.0f) {
                        return v1;
                    }
                    if (v2 > 0.0f) {
                        return v2;
                    }
                    if (v2 == -1.0f && v1 == 13.0f) {
                        return 24.0f;
                    }
                    return v1;
                }
                return -1.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_os_prairie, outData, bvEntete);
    }

    private static void rasterizeBV() {
        Envelope envelope = ShapeFile2CoverageConverter.getEnvelope("C:/Data/projet/coterra/essai_petit_magdelaine/data/Couche SIG BV Magdelaine/BV_Magdelaine.shp", 0.0);
        Coverage refCov = CoverageManager.getCoverage(bv_os_bre);
        EnteteRaster refEntete = refCov.getEntete();
        refCov.dispose();
        refEntete.setNoDataValue(-1);
        EnteteRaster entete = EnteteRaster.getEntete(refEntete, envelope);
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage("C:/Data/projet/coterra/essai_petit_magdelaine/data/Couche SIG BV Magdelaine/BV_Magdelaine.shp", entete, 1.0f, -1.0f);
        float[] data = cov.getData();
        cov.dispose();
        CoverageManager.write(bv, data, entete);
    }

    private static void recuperationOS() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster entete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage osCov = CoverageManager.getCoverage(bv_os_bre);
        EnteteRaster enteteCov = osCov.getEntete();
        float[] osData = osCov.getData(EnteteRaster.getROI(enteteCov, entete.getEnvelope()));
        osCov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{bvData, osData}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 != -1.0f) {
                    return v[1];
                }
                return -1.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_os, data, entete);
    }

    private static void recuperationAltitude() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        String path = "D:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI/1_DONNEES_LIVRAISON_2021-10-00009/";
        String alti = path + "RGEALTI_MNT_5M_GEOTIF_LAMB93_IGN69_D031/";
        Coverage altCov = CoverageManager.getCoverage(alti);
        EnteteRaster entete = altCov.getEntete();
        float[] data = altCov.getData(EnteteRaster.getROI(entete, bvEntete.getEnvelope()));
        altCov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(bv_altitude, data, bvEntete);
    }
}

