/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.util.FileMap;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.File;

public class ScriptErosionCoterra {
    private static final String path = "C:/Data/projet/coterra/essai_magdelaine/data/";
    private static final String bv = "C:/Data/projet/coterra/essai_magdelaine/data/bv_magdelaine.tif";
    private static final String bv_os_bre = "C:/Data/projet/coterra/essai_magdelaine/data/bv_magdelaine_OSO_bre.tif";
    private static final String bv_altitude = "C:/Data/projet/coterra/essai_magdelaine/data/bv_altitude.tif";
    private static final String bv_infiltration_map = "C:/Data/projet/coterra/essai_magdelaine/data/infiltration_map.txt";
    private static final String bv_versement_map = "C:/Data/projet/coterra/essai_magdelaine/data/versement_map.txt";
    private static final String bv_friction_maximale = "C:/Data/projet/coterra/essai_magdelaine/data/bv_friction_maximale.tif";
    private static final String bv_os = "C:/Data/projet/coterra/essai_magdelaine/data/bv_magdelaine_OS.tif";
    private static final String output_path = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/";
    private static final String bv_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_intensity.tif";
    private static final String bv_direction = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_direction.tif";
    private static final String bv_infiltration = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_infiltration.tif";
    private static final String bv_versement = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_versement.tif";
    private static final String bv_intensite_versement = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_intensite_versement.tif";
    private static final String bv_source_erosion_emprise = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_source_erosion_emprise_pente.tif";
    private static final String bv_source_erosion_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_source_erosion_intensity_pente.tif";
    private static final String bv_degat_erosion_emprise = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_degat_erosion_emprise_pente.tif";
    private static final String bv_degat_erosion_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_degat_erosion_intensity_pente.tif";
    private static final String bv_norm_erosion_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_norm_erosion_intensity.tif";
    private static final String bv_norm_degat_erosion_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_norm_degat_erosion_intensity.tif";
    private static final String bv_norm_factor_erosion_intensity = "C:/Data/projet/coterra/essai_magdelaine/data/erosion2/bv_norm_factor_erosion_intensity.tif";

    public static void main(String[] args) {
        Util.createAccess(output_path);
        ScriptErosionCoterra.convertRGE();
        ScriptErosionCoterra.rasterizeBV();
        ScriptErosionCoterra.generationCoeffInfiltration();
        ScriptErosionCoterra.generationIntensiteVersement();
    }

    private static void detectionPente() {
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        EnteteRaster entete = altCov.getEntete();
        float[] altData = altCov.getData();
        altCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTab(altData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("slope-direction");
        builder.addMetric("slope-intensity");
        builder.setWindowSize(3);
        builder.addGeoTiffOutput("slope-direction", bv_direction);
        builder.addGeoTiffOutput("slope-intensity", bv_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculSourceErosion() {
        Coverage intVersCov = CoverageManager.getCoverage(bv_intensite_versement);
        EnteteRaster entete = intVersCov.getEntete();
        float[] intVersData = intVersCov.getData();
        intVersCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTab(intVersData);
        builder.setRasterTab2(altData);
        builder.setRasterTab3(infilData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("source-erosion-emprise");
        builder.addMetric("source-erosion-intensity");
        builder.setWindowSize(201);
        builder.setDMax(500.0);
        builder.addGeoTiffOutput("source-erosion-emprise", bv_source_erosion_emprise);
        builder.addGeoTiffOutput("source-erosion-intensity", bv_source_erosion_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculDegatErosionAltitude() {
        Coverage intVersCov = CoverageManager.getCoverage(bv_intensite_versement);
        EnteteRaster entete = intVersCov.getEntete();
        float[] intVersData = intVersCov.getData();
        intVersCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(bv_altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(intVersData, altData, infilData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("degat-erosion-emprise");
        builder.addMetric("degat-erosion-intensity");
        builder.setWindowSize(201);
        builder.setDMax(500.0);
        builder.addGeoTiffOutput("degat-erosion-emprise", bv_degat_erosion_emprise);
        builder.addGeoTiffOutput("degat-erosion-intensity", bv_degat_erosion_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculDegatErosionPente() {
        Coverage intVersCov = CoverageManager.getCoverage(bv_intensite_versement);
        EnteteRaster entete = intVersCov.getEntete();
        float[] intVersData = intVersCov.getData();
        intVersCov.dispose();
        Coverage slopeIntCov = CoverageManager.getCoverage(bv_intensity);
        float[] slopeIntData = slopeIntCov.getData();
        slopeIntCov.dispose();
        Coverage slopeDirCov = CoverageManager.getCoverage(bv_direction);
        float[] slopeDirData = slopeDirCov.getData();
        slopeDirCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(bv_infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(intVersData, slopeIntData, slopeDirData, infilData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("degat-erosion-emprise");
        builder.addMetric("degat-erosion-intensity");
        builder.setWindowSize(201);
        builder.setDMax(500.0);
        builder.addGeoTiffOutput("degat-erosion-emprise", bv_degat_erosion_emprise);
        builder.addGeoTiffOutput("degat-erosion-intensity", bv_degat_erosion_intensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void generationCoeffInfiltration() {
        Coverage osCov = CoverageManager.getCoverage(bv_os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_infiltration_map, "cover", "infiltration");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(bv_infiltration, data, osEntete);
    }

    private static void generationCoeffVersement() {
        Coverage osCov = CoverageManager.getCoverage(bv_os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(bv_versement_map, "cover", "versement");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(bv_versement, data, osEntete);
    }

    private static void generationFrictionMaximales() {
        Coverage cov1 = CoverageManager.getCoverage(bv_intensity);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage(bv_infiltration);
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 == -1.0f) {
                    return -1.0f;
                }
                return ScriptErosionCoterra.friction(ScriptErosionCoterra.getSlopeIntensity(v1), v[1]);
            }
        };
        cal.run();
        CoverageManager.write(bv_friction_maximale, data, entete);
    }

    private static void generationIntensiteVersement() {
        Coverage cov1 = CoverageManager.getCoverage(bv_intensity);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage(bv_versement);
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 == -1.0f) {
                    return -1.0f;
                }
                v1 = Math.abs(90.0f - v1);
                float v2 = v[1];
                return v1 * v2 * 100.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_intensite_versement, data, entete);
    }

    private static void recuperationOS() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster entete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        Coverage osCov = CoverageManager.getCoverage(bv_os_bre);
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{bvData, osData}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 != -1.0f) {
                    return v[1];
                }
                return -1.0f;
            }
        };
        cal.run();
        CoverageManager.write(bv_os, data, entete);
    }

    private static void rasterizeBV() {
        Coverage osCov = CoverageManager.getCoverage(bv_os_bre);
        EnteteRaster entete = osCov.getEntete();
        entete.setNoDataValue(-1);
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage("C:/Data/projet/coterra/essai_magdelaine/data/bv_shape/bv_magdelaine.shp", entete, 1.0f, -1.0f);
        float[] data = cov.getData();
        cov.dispose();
        CoverageManager.write(bv, data, entete);
    }

    private static void recuperationAltitude() {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        bvCov.dispose();
        String path = "D:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI/1_DONNEES_LIVRAISON_2021-10-00009/";
        String alti = path + "RGEALTI_MNT_5M_GEOTIF_LAMB93_IGN69_D031/";
        Coverage altCov = CoverageManager.getCoverage(alti);
        EnteteRaster entete = altCov.getEntete();
        float[] data = altCov.getData(EnteteRaster.getROI(entete, bvEntete.getEnvelope()));
        altCov.dispose();
        for (int ind = 0; ind < data.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            data[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(bv_altitude, data, bvEntete);
    }

    private static void convertRGE() {
        String path = "D:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D031_2021-05-12/RGEALTI/1_DONNEES_LIVRAISON_2021-10-00009/";
        String inputPath = "RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D031/";
        String outputPath = "RGEALTI_MNT_5M_GEOTIF_LAMB93_IGN69_D031/";
        for (String file : new File(path + inputPath).list()) {
            if (!file.endsWith(".asc")) continue;
            ScriptErosionCoterra.convert(path, inputPath, outputPath, file, ".asc", ".tif", -1);
        }
    }

    private static void convert(String globalPath, String inputPath, String outputPath, String file, String inputFormat, String outputFormat, int noDataValue) {
        Util.createAccess(globalPath + outputPath);
        Coverage cov = CoverageManager.getCoverage(globalPath + inputPath + file);
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        entete.setNoDataValue(noDataValue);
        cov.dispose();
        CoverageManager.write(globalPath + outputPath + file.replace(inputFormat, outputFormat), data, entete);
    }

    private static void factor(String input1, String input2, String output) {
        Coverage cov1 = CoverageManager.getCoverage(input1);
        EnteteRaster entete = cov1.getEntete();
        float[] data1 = cov1.getData();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage(input2);
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                float v1 = v[0];
                if (v1 == -1.0f) {
                    return -1.0f;
                }
                return v1 * v[1];
            }
        };
        cal.run();
        CoverageManager.write(output, outData, entete);
    }

    private static void normalize(String input, String output, final int max) {
        Coverage cov = CoverageManager.getCoverage(input);
        EnteteRaster entete = cov.getEntete();
        float[] data = cov.getData();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value == -1.0f) {
                    return -1.0f;
                }
                if (value >= (float)max) {
                    return 1.0f;
                }
                return value / (float)max;
            }
        };
        cal.run();
        CoverageManager.write(output, outData, entete);
    }

    private static void test2() {
        float cote_oppose = 5.0f;
        float cote_adjacent = 10.0f;
        float tangente = cote_oppose / cote_adjacent;
        double arctangente = Math.atan(tangente);
        double angle = Math.toDegrees(arctangente);
        System.out.println(tangente + " " + arctangente + " " + angle);
        System.out.println(Math.toDegrees(Math.atan(0.8)));
    }

    private static void test() {
        float si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 100.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 90.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 95.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 110.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 105.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 120.0f, 10.0f);
        System.out.println(si);
        System.out.println();
        si = ScriptErosionCoterra.getSlopeIntensity(100.0f, 80.0f, 10.0f);
        System.out.println(si);
        System.out.println();
    }

    private static float getSlopeIntensity(float alt, float nalt, float dist) {
        float cote_oppose = alt - nalt;
        float cote_adjacent = dist;
        float tangente = cote_oppose / cote_adjacent;
        double arctangente = Math.atan(tangente);
        double angle = Math.toDegrees(arctangente);
        System.out.println(cote_oppose + " " + cote_adjacent + " " + tangente + " " + arctangente + " " + angle);
        float v = (float)((90.0 - angle) % 180.0);
        System.out.println(v);
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    private static float getSlopeIntensity(float angle) {
        float v = angle;
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    private static float friction(float slopeIntensity, float infiltration) {
        float friction = 1.0f + 9.0f * infiltration - slopeIntensity;
        return friction;
    }
}

