/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.Raster;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.distance.analysis.euclidian.TabChamferDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;

public class ScriptDIRO {
    private static String path = "C:/Data/projet/DIRO/data/";
    private static int dMax = 250;

    public static void main(String[] args) {
    }

    private static void compileAnalyse() {
        try {
            CsvWriter cw = new CsvWriter(path + "analyse_diro.csv");
            cw.setDelimiter(';');
            cw.write("site");
            cw.write("area_site");
            cw.write("area_env");
            cw.write("moy_site_prairiale");
            cw.write("moy_site_boisee");
            cw.write("moy_env_prairiale");
            cw.write("moy_env_boisee");
            cw.write("moy_sc_env_prairiale");
            cw.write("moy_sc_env_boisee");
            cw.write("delta_moy_env_prairiale");
            cw.write("delta_moy_env_boisee");
            cw.endRecord();
            CsvReader cr = new CsvReader(path + "analyse_surfaces.csv");
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                int code = Integer.parseInt(cr.get("raster").replace("environnement_site_clean_window_", "").replace(".tif", ""));
                System.out.println(code);
                float area_1 = Float.parseFloat(cr.get("area_1"));
                float area_2 = Float.parseFloat(cr.get("area_2"));
                CsvReader cr1 = new CsvReader(path + "analyse_moyenne/analyse_moyenne_prairiale_" + code + ".csv");
                cr1.setDelimiter(';');
                cr1.readHeaders();
                cr1.readRecord();
                float moy_p_1 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.readRecord();
                float moy_p_2 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.close();
                cr1 = new CsvReader(path + "analyse_moyenne/analyse_moyenne_boisee_" + code + ".csv");
                cr1.setDelimiter(';');
                cr1.readHeaders();
                cr1.readRecord();
                float moy_b_1 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.readRecord();
                float moy_b_2 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.close();
                cr1 = new CsvReader(path + "analyse_moyenne_scenario/analyse_moyenne_prairiale_scenario_" + code + ".csv");
                cr1.setDelimiter(';');
                cr1.readHeaders();
                cr1.readRecord();
                cr1.readRecord();
                float moy_sc_p_2 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.close();
                cr1 = new CsvReader(path + "analyse_moyenne_scenario/analyse_moyenne_boisee_scenario_" + code + ".csv");
                cr1.setDelimiter(';');
                cr1.readHeaders();
                cr1.readRecord();
                cr1.readRecord();
                float moy_sc_b_2 = Float.parseFloat(cr1.get("average")) * 100.0f;
                cr1.close();
                float delta_moy_p_2 = (moy_p_2 - moy_sc_p_2) * 100.0f;
                float delta_moy_b_2 = (moy_b_2 - moy_sc_b_2) * 100.0f;
                cw.write(code + "");
                cw.write(area_1 + "");
                cw.write(area_2 + "");
                cw.write(moy_p_1 + "");
                cw.write(moy_b_1 + "");
                cw.write(moy_p_2 + "");
                cw.write(moy_b_2 + "");
                cw.write(moy_sc_p_2 + "");
                cw.write(moy_sc_b_2 + "");
                cw.write(delta_moy_p_2 + "");
                cw.write(delta_moy_b_2 + "");
                cw.endRecord();
            }
            cr.close();
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void analyseMoyennePrairiales() {
        File folder = new File(path + "indices_continuites_prairiales/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[5]);
            System.out.println(file + " " + code);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.ENTITY);
            builder.setRasterFile(path + "indices_continuites_prairiales/" + file);
            builder.setEntityRasterFile(path + "environnement_sites/environnement_site_clean_window_" + code + ".tif");
            builder.addMetric("average");
            builder.addCsvOutput(path + "analyse_moyenne/analyse_moyenne_prairiale_" + code + ".csv");
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void analyseMoyenneBoisees() {
        File folder = new File(path + "indices_continuites_boisees/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[5]);
            System.out.println(file + " " + code);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.ENTITY);
            builder.setRasterFile(path + "indices_continuites_boisees/" + file);
            builder.setEntityRasterFile(path + "environnement_sites/environnement_site_clean_window_" + code + ".tif");
            builder.addMetric("average");
            builder.addCsvOutput(path + "analyse_moyenne/analyse_moyenne_boisee_" + code + ".csv");
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void analyseMoyennePrairialesScenario() {
        File folder = new File(path + "indices_continuites_prairiales_scenario/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[6]);
            System.out.println(file + " " + code);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.ENTITY);
            builder.setRasterFile(path + "indices_continuites_prairiales_scenario/" + file);
            builder.setEntityRasterFile(path + "environnement_sites/environnement_site_clean_window_" + code + ".tif");
            builder.addMetric("average");
            builder.addCsvOutput(path + "analyse_moyenne_scenario/analyse_moyenne_prairiale_scenario_" + code + ".csv");
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void analyseMoyenneBoiseesScenario() {
        File folder = new File(path + "indices_continuites_boisees_scenario/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[6]);
            System.out.println(file + " " + code);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.ENTITY);
            builder.setRasterFile(path + "indices_continuites_boisees_scenario/" + file);
            builder.setEntityRasterFile(path + "environnement_sites/environnement_site_clean_window_" + code + ".tif");
            builder.addMetric("average");
            builder.addCsvOutput(path + "analyse_moyenne_scenario/analyse_moyenne_boisee_scenario_" + code + ".csv");
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void analyseSurfaceSites() {
        File folder = new File(path + "environnement_sites/");
        Raster.setCellSize(5.0);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.MAP);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            builder.addRasterFile(path + "environnement_sites/" + file);
        }
        builder.addMetric("area_1");
        builder.addMetric("area_2");
        builder.addCsvOutput(path + "analyse_surfaces.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void rasteurisation_environement_sites() {
        Util.createAccess(path + "environnement_sites/");
        File folder = new File(path + "sites/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[3]);
            System.out.println(file + " " + code);
            Coverage cov = CoverageManager.getCoverage(path + "sites/" + file);
            float[] data = cov.getData();
            EnteteRaster entete = cov.getEntete();
            cov.dispose();
            float[] distanceData = new float[data.length];
            TabChamferDistanceAnalysis analysis = new TabChamferDistanceAnalysis(distanceData, data, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{code}, entete.noDataValue());
            analysis.allRun();
            for (int i = 0; i < distanceData.length; ++i) {
                distanceData[i] = distanceData[i] == 0.0f ? 1.0f : (distanceData[i] <= (float)dMax ? 2.0f : 0.0f);
            }
            CoverageManager.write(path + "environnement_sites/environnement_" + file, distanceData, entete);
        }
    }

    private static void rasteurisation_sites() {
        Util.createAccess(path + "sites/");
        File folder = new File(path + "paysages_nettoyage/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            String code = file.replace(".tif", "").split("_")[2];
            System.out.println(path + "paysages_nettoyage/" + file + " " + code);
            HashMap<String, Integer> codes = new HashMap<String, Integer>();
            codes.put(code, Integer.parseInt(code));
            Coverage cov = CoverageManager.getCoverage(path + "paysages_nettoyage/" + file);
            EnteteRaster entete = cov.getEntete();
            cov.dispose();
            ShapeFile2CoverageConverter.rasterize(path + "sites/site_" + file, path + "Sites_DIRO.shp", "code", codes, 0.0f, entete);
        }
    }

    private static void calculIndicesContinuites(String output, String input, int dMax) {
        Util.createAccess(output);
        File folder = new File(input);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            ScriptDIRO.calculIndiceContinuite(output + "indice_" + file, input + file, dMax);
        }
    }

    private static void calculIndiceContinuite(String output, String input, final int dMax) {
        Coverage cov = CoverageManager.getCoverage(input);
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                return (float)((double)v[0] / (Math.pow(dMax, 2.0) * Math.PI * (double)dMax) / 3.0);
            }
        };
        cal.run();
        CoverageManager.write(output, outData, entete);
    }

    private static void scriptContinuitesStructurelles(int size) {
        int ws = size * 2 / 5 + 1;
        System.out.println(ws);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.addRasterFile("F:/data/sig/grand_ouest/GO_2021_ebr.tif");
        builder.setValues("1,2,3,4,5,6,7,9,10,12,13,14,15,16,17,18,19,20,22,23");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(ws);
        builder.setDisplacement(20);
        builder.addMetric("pNVm_13&14&19");
        builder.addGeoTiffOutput("pNVm_13&14&19", path + "structure/proportion_habitats_prairiaux_" + size + "m.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void scriptContinuitesPrairiales(String output, String inputOS, String inputPermeabilite) {
        File folder = new File(inputOS);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
            builder.setRasterFile(inputOS + file);
            builder.setRasterFile2(inputPermeabilite + "permeabilite_prairiale_" + file);
            builder.setWindowSize(101);
            builder.addMetric("volume");
            builder.setDMax(dMax);
            builder.addGeoTiffOutput("volume", output + "continuite_prairiale_" + file);
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void scriptContinuitesBoisees(String output, String inputOS, String inputPermeabilite) {
        File folder = new File(inputOS);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
            builder.setRasterFile(inputOS + file);
            builder.setRasterFile2(inputPermeabilite + "permeabilite_boisee_" + file);
            builder.setWindowSize(101);
            builder.addMetric("volume");
            builder.setDMax(dMax);
            builder.addGeoTiffOutput("volume", output + "continuite_boisee_" + file);
            LandscapeMetricAnalysis analysis = builder.build();
            analysis.allRun();
        }
    }

    private static void scriptGenerationPermeabilitesPrairiales(String output, String input) {
        Util.createAccess(output);
        File folder = new File(input);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            Coverage covOS = CoverageManager.getCoverage(input + file);
            EnteteRaster entete = covOS.getEntete();
            float[] dataOS = covOS.getData();
            covOS.dispose();
            TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
            sarMap.put(Float.valueOf(0.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(2.0f), Float.valueOf(5.0f));
            sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
            sarMap.put(Float.valueOf(5.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(6.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(7.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(9.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(10.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(12.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(13.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(14.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(15.0f), Float.valueOf(5.0f));
            sarMap.put(Float.valueOf(16.0f), Float.valueOf(1.8f));
            sarMap.put(Float.valueOf(17.0f), Float.valueOf(1.8f));
            sarMap.put(Float.valueOf(18.0f), Float.valueOf(1.3f));
            sarMap.put(Float.valueOf(19.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(20.0f), Float.valueOf(1.8f));
            sarMap.put(Float.valueOf(22.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(23.0f), Float.valueOf(100.0f));
            float[] dataPermeabilite = new float[entete.width() * entete.height()];
            SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataPermeabilite, dataOS, sarMap);
            cal.run();
            CoverageManager.write(output + "permeabilite_prairiale_" + file, dataPermeabilite, entete);
        }
    }

    private static void scriptGenerationPermeabilitesBoisees(String output, String input) {
        Util.createAccess(output);
        File folder = new File(input);
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            Coverage covOS = CoverageManager.getCoverage(input + file);
            EnteteRaster entete = covOS.getEntete();
            float[] dataOS = covOS.getData();
            covOS.dispose();
            TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
            sarMap.put(Float.valueOf(0.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(2.0f), Float.valueOf(10.0f));
            sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
            sarMap.put(Float.valueOf(5.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(6.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(7.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(9.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(10.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(12.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(13.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(14.0f), Float.valueOf(1.5f));
            sarMap.put(Float.valueOf(15.0f), Float.valueOf(2.5f));
            sarMap.put(Float.valueOf(16.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(17.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(18.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(19.0f), Float.valueOf(2.0f));
            sarMap.put(Float.valueOf(20.0f), Float.valueOf(1.0f));
            sarMap.put(Float.valueOf(22.0f), Float.valueOf(100.0f));
            sarMap.put(Float.valueOf(23.0f), Float.valueOf(100.0f));
            float[] dataPermeabilite = new float[entete.width() * entete.height()];
            SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataPermeabilite, dataOS, sarMap);
            cal.run();
            CoverageManager.write(output + "permeabilite_boisee_" + file, dataPermeabilite, entete);
        }
    }

    private static void scriptGenerationPaysages() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.addRasterFile("F:/data/sig/grand_ouest/GO_2021_ebr.tif");
        builder.setValues("1,2,3,4,5,6,7,9,10,12,13,14,15,16,17,18,19,20,22,23");
        builder.addMetric("N-valid");
        builder.setWindowSize(1001);
        builder.setPointsFilter(path + "points_potentiels.txt");
        builder.addCsvOutput(path + "analyse.csv");
        builder.setWindowsPath(path + "paysages/");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void scriptGenerationPaysagesNettoyage() {
        Util.createAccess(path + "paysages_nettoyage/");
        File folder = new File(path + "paysages/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            System.out.println(file);
            Coverage covOS = CoverageManager.getCoverage(path + "paysages/" + file);
            EnteteRaster entete = covOS.getEntete();
            float[] dataOS = covOS.getData();
            covOS.dispose();
            Coverage covMajOS = ShapeFile2CoverageConverter.getSurfaceCoverage(path + "maj_sites.shp", "code", entete, 0);
            float[] dataMajOS = covMajOS.getData();
            covMajOS.dispose();
            for (int i = 0; i < dataOS.length; ++i) {
                if (dataOS[i] == -1.0f || !(dataMajOS[i] > 0.0f)) continue;
                dataOS[i] = dataMajOS[i];
            }
            CoverageManager.write(path + "paysages_nettoyage/clean_" + file, dataOS, entete);
        }
    }

    private static void scriptGenerationPaysagesScenario() {
        Util.createAccess(path + "paysages_scenario/");
        File folder = new File(path + "paysages_nettoyage/");
        for (String file : folder.list()) {
            if (!file.endsWith(".tif")) continue;
            int code = Integer.parseInt(file.replace(".tif", "").split("_")[2]);
            System.out.println(file + " " + code);
            Coverage covOS = CoverageManager.getCoverage(path + "paysages_nettoyage/" + file);
            EnteteRaster entete = covOS.getEntete();
            float[] dataOS = covOS.getData();
            covOS.dispose();
            HashMap<String, Integer> codes = new HashMap<String, Integer>();
            codes.put(code + "", 1);
            Coverage covMajOS = ShapeFile2CoverageConverter.getSurfaceCoverage(path + "Sites_DIRO.shp", "code", codes, entete, 0.0f);
            float[] dataMajOS = covMajOS.getData();
            covMajOS.dispose();
            for (int i = 0; i < dataOS.length; ++i) {
                if (dataOS[i] == -1.0f || !(dataMajOS[i] > 0.0f)) continue;
                dataOS[i] = dataMajOS[i];
            }
            CoverageManager.write(path + "paysages_scenario/scenario_" + file, dataOS, entete);
        }
    }
}

