/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.analysis.tab.ClassificationPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.OverlayPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.domain.DomainFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.cluster.TabClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenClusteringAnalysis;
import fr.inrae.act.bagap.chloe.cluster.distance.TabDistanceClusteringAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import org.locationtech.jts.geom.Envelope;

public class ScriptContinuitesRennesMetropole {
    public static void main(String[] args) {
        long begin = System.currentTimeMillis();
        ScriptContinuitesRennesMetropole.clusteringContinuity();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void clusteringContinuity() {
        String path = "E:/rennes_metropole/continuite_ecologique/clustering2/";
        Coverage cov = CoverageManager.getCoverage(path + "indice_deplacement_250m.tif");
        float[] inData = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[][] datas = new float[10][];
        for (int k = 10; k > 0; --k) {
            cov = CoverageManager.getCoverage(path + "pnvalues_cluster_indice_deplacement_250m_" + k + ".tif");
            datas[k - 1] = cov.getData();
            entete = cov.getEntete();
            cov.dispose();
        }
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, datas){

            @Override
            protected float doTreat(float[] v) {
                return (v[0] + v[1] + v[2] + v[3] + v[4] + v[5] + v[6] + v[7] + v[8] + v[9]) / 10.0f;
            }
        };
        cal.run();
        CoverageManager.write(path + "sum_pnvalues_cluster_indice_deplacement_250m.tif", outData, entete);
    }

    private static void analyseGlobale(String inputRaster, String outputCsv) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.MAP);
        builder.setRasterFile(inputRaster);
        builder.addMetric("pNV_1");
        builder.addCsvOutput(outputCsv);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void cleanClassif(int dMax, String continuite, int seuil) {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/data/commune_5m.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage cov1 = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_boise_" + dMax + "m.tif");
        float[] data1 = cov1.getData();
        cov1.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data, data1}){

            @Override
            protected float doTreat(float[] v) {
                float v0 = v[0];
                float v1 = v[1];
                if (v0 == -1.0f) {
                    return -1.0f;
                }
                if (v1 == 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/classification/rm_classif_0-" + seuil + "_" + continuite + "_boise_" + dMax + "m.tif", outData, entete);
        cov1 = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_humide_" + dMax + "m.tif");
        data1 = cov1.getData();
        cov1.dispose();
        outData = new float[entete.width() * entete.height()];
        cal = new Pixel2PixelTabCalculation(outData, new float[][]{data, data1}){

            @Override
            protected float doTreat(float[] v) {
                float v0 = v[0];
                float v1 = v[1];
                if (v0 == -1.0f) {
                    return -1.0f;
                }
                if (v1 == 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/classification/rm_classif_0-" + seuil + "_" + continuite + "_humide_" + dMax + "m.tif", outData, entete);
        cov1 = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_" + dMax + "m.tif");
        data1 = cov1.getData();
        cov1.dispose();
        outData = new float[entete.width() * entete.height()];
        cal = new Pixel2PixelTabCalculation(outData, new float[][]{data, data1}){

            @Override
            protected float doTreat(float[] v) {
                float v0 = v[0];
                float v1 = v[1];
                if (v0 == -1.0f) {
                    return -1.0f;
                }
                if (v1 == 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/classification/rm_classif_0-" + seuil + "_" + continuite + "_" + dMax + "m.tif", outData, entete);
    }

    private static void sum(int dMax, String continuite, int seuil) {
        Coverage covB = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_boise_" + dMax + "m.tif");
        float[] dataB = covB.getData();
        EnteteRaster entete = covB.getEntete();
        covB.dispose();
        Coverage covH = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_humide_" + dMax + "m.tif");
        float[] dataH = covH.getData();
        covH.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{dataB, dataH}){

            @Override
            protected float doTreat(float[] v) {
                float vB = v[0];
                float vH = v[1];
                if (vB == 1.0f || vH == 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/classification/classif_0-" + seuil + "_" + continuite + "_" + dMax + "m.tif", outData, entete);
    }

    private static void classification(String type, int dMax, String continuite, int min, int max, float step) {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/indice_" + continuite + "_" + type + "_" + dMax + "m.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        HashMap<Domain<Float, Float>, Integer> domains = new HashMap<Domain<Float, Float>, Integer>();
        domains.put(DomainFactory.getFloatDomain("[0, 0.26]"), -1);
        domains.put(DomainFactory.getFloatDomain("]0.26, ]"), 1);
        ClassificationPixel2PixelTabCalculation cal = new ClassificationPixel2PixelTabCalculation(outData, data, entete.noDataValue(), domains);
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/classification/classif_0-26_" + continuite + "_" + type + "_" + dMax + "m.tif", outData, entete);
    }

    private static void cleanPermeabilitePrairial() {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/permeabilite_prairial.tif");
        float[] data1 = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage cov2 = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique/diversity.tif");
        float[] data2 = cov2.getData();
        cov2.dispose();
        Coverage cov3 = CoverageManager.getCoverage("E:/rennes_metropole/data/cgtv.tif");
        float[] data3 = cov3.getData();
        cov3.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data1, data2, data3}){

            @Override
            protected float doTreat(float[] v) {
                float v3 = v[2];
                if (v3 == 5.0f || v3 == 6.0f) {
                    return 0.1f;
                }
                float v2 = v[1];
                if (v2 > 0.0f) {
                    return 1.0f;
                }
                return v[0];
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/permeabilite_prairial.tif", outData, entete);
    }

    private static void prepaPermeabilitePrairial() {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/continuite_ecologique_old/rm_os_bre.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(8.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(11.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(2.0f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/permeabilite_prairial.tif", dataSR, entete);
    }

    private static void rasterizeCGTV() {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/grain_bocager/rm_grain_bocager_5m_4classes.tif");
        EnteteRaster enteteRef = cov.getEntete();
        cov.dispose();
        Coverage cov2 = CoverageManager.getCoverage("D:/data/sig/CGTV/cgtv.tif");
        EnteteRaster entete = cov2.getEntete();
        float[] data = cov2.getData(EnteteRaster.getROI(entete, new Envelope(enteteRef.minx(), enteteRef.maxx(), enteteRef.miny(), enteteRef.maxy())));
        cov2.dispose();
        CoverageManager.write("E:/rennes_metropole/data/cgtv.tif", data, enteteRef);
    }

    private static void calculIndiceContinuite(String type, int dMax) {
        Coverage cov1 = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/indice_accessibilite_" + type + "_" + dMax + "m.tif");
        float[] data1 = cov1.getData();
        EnteteRaster entete = cov1.getEntete();
        cov1.dispose();
        Coverage cov2 = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/indice_deplacement_" + type + "_" + dMax + "m.tif");
        float[] data2 = cov2.getData();
        cov2.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data1, data2}){

            @Override
            protected float doTreat(float[] v) {
                return v[0] * v[1];
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/test/indice_continuite_" + type + "_" + dMax + "m.tif", outData, entete);
    }

    private static void calculIndiceDeplacement(String type, final int dMax) {
        Coverage cov = CoverageManager.getCoverage("E:/rennes_metropole/volume_deplacement/volume_deplacement_" + type + "_" + dMax + ".tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                return (float)((double)v[0] / (Math.pow(dMax, 2.0) * Math.PI * (double)dMax) / 3.0);
            }
        };
        cal.run();
        CoverageManager.write("E:/rennes_metropole/continuite_ecologique/indice_deplacement_" + type + "_" + dMax + "m.tif", outData, entete);
    }

    private static void sumProportionContinuites(int dMax) {
        Coverage covB = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/average_500m_indice_accessibilite_boise_" + dMax + "m.tif");
        float[] dataB = covB.getData();
        EnteteRaster entete = covB.getEntete();
        covB.dispose();
        Coverage covH = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/average_500m_indice_accessibilite_humide_" + dMax + "m.tif");
        float[] dataH = covH.getData();
        covH.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{dataB, dataH}){

            @Override
            protected float doTreat(float[] v) {
                return v[0] + v[1];
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/test/sum_average_continuites_" + dMax + "m.tif", outData, entete);
    }

    private static void calculIndiceAccessibilite(String type, final int dMax) {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/surface_accessibilite_" + type + "_" + dMax + ".tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                return (float)((double)v[0] / (Math.pow(dMax, 2.0) * Math.PI));
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/test/indice_accessibilite_" + type + "_" + dMax + "m.tif", outData, entete);
    }

    private static void proportionContinuites(String type, int dMax) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/volume_deplacement/test/indice_accessibilite_" + type + "_" + dMax + "m.tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(201);
        builder.setDisplacement(10);
        builder.addMetric("average");
        builder.addGeoTiffOutput("average", "H:/rennes_metropole/volume_deplacement/test/average_500m_indice_accessibilite_" + type + "_" + dMax + "m.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void noteEntity(String territoire, String type, int echelle, String continuite, String metric) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("H:/rennes_metropole/continuite_ecologique/indice_" + continuite + "_" + type + "_" + echelle + "m.tif");
        builder.setEntityRasterFile("H:/rennes_metropole/continuite_ecologique/" + territoire + "_5m.tif");
        builder.addMetric(metric);
        builder.addGeoTiffOutput(metric, "H:/rennes_metropole/continuite_ecologique/" + territoire + "/" + territoire + "_" + metric + "_" + continuite + "_" + type + "_" + echelle + "m.tif");
        builder.addCsvOutput("H:/rennes_metropole/continuite_ecologique/" + territoire + "/" + territoire + "_" + metric + "_" + continuite + "_" + type + "_" + echelle + "m.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void rasterizeCodeSecteur() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/continuite_ecologique/communes_rennes_metropole_L93.shp", "id_secteur", entete.cellsize(), entete.noDataValue(), entete.crs(), entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.noDataValue());
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/secteur_5m.tif", dataN, entete);
    }

    private static void rasterizeCodeCommune() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/continuite_ecologique/communes_rennes_metropole_L93.shp", "insee", entete.cellsize(), entete.noDataValue(), entete.crs(), entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.noDataValue());
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/commune_5m.tif", dataN, entete);
    }

    private static void rasterizeCodeMNIE() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/data/MNIE22/MNIE22/MNIE-SIG/MNIE_HAB_PAYS_2022.shp", "codeMNIE", entete.cellsize(), entete.noDataValue(), entete.crs(), entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), entete.noDataValue());
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/mnie_5m.tif", dataN, entete);
    }

    private static void fragmentationFonctionnelle(String type, int echelle, String continuite, float min, int echelle2) {
        int ws = echelle2 * 2 / 5 + 1;
        String minV = (int)((double)min * 100.0) + "";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/volume_deplacement/test/cluster_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + ".tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(ws);
        builder.setDisplacement(10);
        builder.addMetric("SHDI");
        builder.addGeoTiffOutput("SHDI", "H:/rennes_metropole/volume_deplacement/test/fragmentation_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + "_" + echelle2 + "m.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void proportionFonctionnelle(String type, int echelle, String continuite, float min, int echelle2) {
        int ws = echelle2 * 2 / 5 + 1;
        String minV = (int)((double)min * 100.0) + "";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/volume_deplacement/test/classif_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + ".tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(ws);
        builder.setDisplacement(10);
        builder.addMetric("pNV_1");
        builder.addGeoTiffOutput("pNV_1", "H:/rennes_metropole/volume_deplacement/test/proportion_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + "_" + echelle2 + "m.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void clusterFonctionnel(String type, int echelle, String continuite, float min) {
        String minV = (int)((double)min * 100.0) + "";
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/classif_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + ".tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TabQueenClusteringAnalysis ca = new TabQueenClusteringAnalysis(data, entete.width(), entete.height(), new int[]{1}, entete.noDataValue());
        float[] outData = (float[])ca.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/volume_deplacement/test/cluster_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + ".tif", outData, entete);
    }

    private static void classifFonctionnelle(String type, int echelle, String continuite, final float min) {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/indice_" + continuite + "_" + type + "_" + echelle + "m.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value == -1.0f) {
                    return -1.0f;
                }
                if (value > min) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        String minV = (int)((double)min * 100.0) + "";
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/test/classif_indice_" + continuite + "_" + type + "_" + echelle + "m_min" + minV + ".tif", outData, entete);
    }

    private static void testIndiceContinuiteHumide() {
        Coverage covSurface = CoverageManager.getCoverage("H:/rennes_metropole/test/surface_accessibilite_humide_2.tif");
        float[] dataSurface = covSurface.getData();
        EnteteRaster entete = covSurface.getEntete();
        covSurface.dispose();
        Coverage covVolume = CoverageManager.getCoverage("H:/rennes_metropole/test/volume_deplacement_humide_2.tif");
        float[] dataVolume = covVolume.getData();
        covVolume.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{dataSurface, dataVolume}){

            @Override
            protected float doTreat(float[] v) {
                if (v[1] > 1.0E7f) {
                    return v[1] / v[0];
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/test/rapport_humide_2_2.tif", outData, entete);
    }

    private static void fragmentationFonctionnelleBoise(int volumeMin) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/test/cluster_volume_deplacement_boise_9_" + volumeMin + ".tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(201);
        builder.setDisplacement(10);
        builder.addMetric("SHDI");
        builder.addGeoTiffOutput("SHDI", "H:/rennes_metropole/test/fragmentation_volume_deplacement_boise_9_" + volumeMin + ".tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void proportionFonctionnelleBoise(int volumeMin) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/test/classif_volume_deplacement_boise_9_" + volumeMin + ".tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(201);
        builder.setDisplacement(10);
        builder.addMetric("pNV_1");
        builder.addGeoTiffOutput("pNV_1", "H:/rennes_metropole/test/proportion_volume_deplacement_boise_9_" + volumeMin + ".tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void clusterFonctionnelBoise(int volumeMin) {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/test/classif_volume_deplacement_boise_9_" + volumeMin + ".tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TabQueenClusteringAnalysis ca = new TabQueenClusteringAnalysis(data, entete.width(), entete.height(), new int[]{1}, entete.noDataValue());
        float[] dataCluster = (float[])ca.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/test/cluster_volume_deplacement_boise_9_" + volumeMin + ".tif", dataCluster, entete);
    }

    private static void classifFonctionnelleBoise(final int volumeMin) {
        Coverage covVolume = CoverageManager.getCoverage("H:/rennes_metropole/test/volume_deplacement_boise_9.tif");
        float[] dataVolume = covVolume.getData();
        EnteteRaster entete = covVolume.getEntete();
        covVolume.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{dataVolume}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value > (float)volumeMin) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/test/classif_volume_deplacement_boise_9_" + volumeMin + ".tif", outData, entete);
    }

    private static void testIndiceContinuite(String type, int dMax) {
        Coverage covSurface = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/indice_accessibilite_" + type + "_" + dMax + "m.tif");
        float[] dataSurface = covSurface.getData();
        EnteteRaster entete = covSurface.getEntete();
        covSurface.dispose();
        Coverage covVolume = CoverageManager.getCoverage("H:/rennes_metropole/volume_deplacement/test/indice_deplacement_" + type + "_" + dMax + "m.tif");
        float[] dataVolume = covVolume.getData();
        covVolume.dispose();
        Coverage covPerm = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_" + type + ".tif");
        float[] dataPerm = covPerm.getData();
        covPerm.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{dataSurface, dataVolume, dataPerm}){

            @Override
            protected float doTreat(float[] v) {
                return v[1] * (1.0f / v[2]);
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/volume_deplacement/test/rapport_deplacement_sur_permeabilite_" + type + "_" + dMax + "m.tif", outData, entete);
    }

    private static void testIndiceContinuite2() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("H:/rennes_metropole/test/volume_deplacement_boise_9.tif");
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(401);
        builder.setDisplacement(10);
        builder.addMetric("average");
        builder.addGeoTiffOutput("average", "H:/rennes_metropole/test/volume_deplacement_boise_10_average.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculContinuity(String type, int dMax) {
        int ws = dMax * 2 / 5 * 4 + 1;
        System.out.println(type + " " + dMax + " " + ws);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile("E:/rennes_metropole/continuite_ecologique_old/rm_os_bre.tif");
        builder.setRasterFile2("E:/rennes_metropole/continuite_ecologique/permeabilite_" + type + ".tif");
        builder.setROIX(4000);
        builder.setROIY(4000);
        builder.setROIWidth(1000);
        builder.setROIHeight(1000);
        builder.setWindowSize(ws);
        builder.setDisplacement(1);
        builder.addMetric("surface");
        builder.addMetric("volume");
        builder.setDMax(dMax);
        builder.addGeoTiffOutput("surface", "E:/rennes_metropole/volume_deplacement/surface_accessibilite_" + type + "_" + dMax + ".tif");
        builder.addGeoTiffOutput("volume", "E:/rennes_metropole/volume_deplacement/volume_deplacement_" + type + "_" + dMax + ".tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculContinuityHumide() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        builder.setRasterFile2("H:/rennes_metropole/continuite_ecologique/permeabilite_humide.tif");
        builder.setWindowSize(201);
        builder.setDisplacement(4);
        builder.addMetric("surface");
        builder.addMetric("volume");
        builder.setDMax(125.0);
        builder.addGeoTiffOutput("surface", "H:/rennes_metropole/test/surface_accessibilite_humide_2.tif");
        builder.addGeoTiffOutput("volume", "H:/rennes_metropole/test/volume_deplacement_humide_2.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculContinuityBoise() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        builder.setRasterFile2("H:/rennes_metropole/continuite_ecologique/permeabilite_boise.tif");
        builder.setWindowSize(201);
        builder.setDisplacement(4);
        builder.addMetric("surface");
        builder.addMetric("volume");
        builder.setDMax(250.0);
        builder.addGeoTiffOutput("surface", "H:/rennes_metropole/test/surface_accessibilite_boise_9.tif");
        builder.addGeoTiffOutput("volume", "H:/rennes_metropole/test/volume_deplacement_boise_9.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculContinuityGlobal() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        builder.setRasterFile2("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif");
        builder.setWindowSize(151);
        builder.setDisplacement(20);
        builder.addMetric("surface");
        builder.addMetric("volume");
        builder.setDMax(125.0);
        builder.addGeoTiffOutput("surface", "H:/rennes_metropole/test/surface_3.tif");
        builder.addGeoTiffOutput("volume", "H:/rennes_metropole/test/volume_3.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void calculFenetresFonctionnelles() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        builder.setRasterFile2("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif");
        builder.setWindowSize(501);
        builder.setDisplacement(20);
        builder.addMetric("N-valid");
        builder.addMetric("SHDI");
        builder.setDMax(125.0);
        builder.addGeoTiffOutput("N-valid", "H:/rennes_metropole/test/nvalid_39.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void prepaFenetresFonctionnelles() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[data.length];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value != -1.0f && value > 0.0f && value < 1.0f) {
                    return 1.0f;
                }
                return value;
            }
        };
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/permeabilite_nvalid.tif", outData, entete);
    }

    private static void convert() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.asc", data, entete);
    }

    private static void calculClusterFonctionnel() {
        for (int dc = 0; dc < 1000; dc += 50) {
            ScriptContinuitesRennesMetropole.calculClusterFonctionnelGlobal(dc);
        }
    }

    private static void calculClusterFonctionnelBoise(int dMax) {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_boise.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covDist = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/distance_boise.tif");
        float[] dataDist = covDist.getData();
        covDist.dispose();
        TabDistanceClusteringAnalysis ca = new TabDistanceClusteringAnalysis(dataHab, dataDist, entete.width(), entete.height(), new int[]{1}, dMax, entete.noDataValue());
        float[] dataCluster = (float[])ca.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/continuite_ecologique/cluster_boise_" + dMax + ".tif", dataCluster, entete);
    }

    private static void calculClusterFonctionnelHumide(int dMax) {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_humide.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covDist = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/distance_humide.tif");
        float[] dataDist = covDist.getData();
        covDist.dispose();
        TabDistanceClusteringAnalysis ca = new TabDistanceClusteringAnalysis(dataHab, dataDist, entete.width(), entete.height(), new int[]{1}, dMax, entete.noDataValue());
        float[] dataCluster = (float[])ca.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/continuite_ecologique/cluster_humide_" + dMax + ".tif", dataCluster, entete);
    }

    private static void calculClusterFonctionnelGlobal(int dMax) {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_global.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covDist = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/distance_globale.tif");
        float[] dataDist = covDist.getData();
        covDist.dispose();
        TabDistanceClusteringAnalysis ca = new TabDistanceClusteringAnalysis(dataHab, dataDist, entete.width(), entete.height(), new int[]{1}, dMax, entete.noDataValue());
        float[] dataCluster = (float[])ca.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/continuite_ecologique/cluster_global_" + dMax + ".tif", dataCluster, entete);
        TabClusteringOutput out = new TabClusteringOutput(dataCluster, dataHab, new int[]{1}, entete.cellsize(), entete.noDataValue());
        out.allRun();
        System.out.println(dMax + ";" + out.getNbPatch());
    }

    private static void calculDistanceFonctionnelle() {
        ScriptContinuitesRennesMetropole.calculDistanceFonctionnelleGlobale();
    }

    private static void calculDistanceFonctionnelleBoise() {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_boise.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covPerm = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_boise.tif");
        float[] dataPerm = covPerm.getData();
        covPerm.dispose();
        float[] data = new float[entete.width() * entete.height()];
        TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(data, dataHab, dataPerm, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1});
        analysis.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/continuite_ecologique/distance_boise.tif", data, entete);
    }

    private static void calculDistanceFonctionnelleHumide() {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_humide.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covPerm = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_humide.tif");
        float[] dataPerm = covPerm.getData();
        covPerm.dispose();
        float[] data = new float[entete.width() * entete.height()];
        TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(data, dataHab, dataPerm, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1});
        analysis.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/continuite_ecologique/distance_humide.tif", data, entete);
    }

    private static void calculDistanceFonctionnelleGlobale() {
        Coverage covHab = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/habitat_global.tif");
        float[] dataHab = covHab.getData();
        EnteteRaster entete = covHab.getEntete();
        covHab.dispose();
        Coverage covPerm = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif");
        float[] dataPerm = covPerm.getData();
        covPerm.dispose();
        float[] data = new float[entete.width() * entete.height()];
        TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(data, dataHab, dataPerm, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1});
        analysis.allRun();
        CoverageManager.writeGeotiff("H:/rennes_metropole/test/distance_globale_4.tif", data, entete);
    }

    private static void prepaPermeabilite() {
        ScriptContinuitesRennesMetropole.prepaPermeabiliteBoise();
        ScriptContinuitesRennesMetropole.prepaPermeabiliteHumide();
        ScriptContinuitesRennesMetropole.prepaPermeabiliteGlobale();
    }

    private static void prepaPermeabiliteBoise() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(8.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(11.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(100.0f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/permeabilite_boise.tif", dataSR, entete);
    }

    private static void prepaPermeabiliteHumide() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(8.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(11.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(0.1f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        Coverage covZH = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/zone_humide.tif");
        float[] dataZH = covZH.getData();
        covZH.dispose();
        for (int i = 0; i < dataSR.length; ++i) {
            if (dataZH[i] != 1.0f) continue;
            int n = i;
            dataSR[n] = dataSR[n] / 10.0f;
        }
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/permeabilite_humide.tif", dataSR, entete);
    }

    private static void prepaPermeabiliteGlobale() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(8.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(11.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(0.1f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        Coverage covZH = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/zone_humide.tif");
        float[] dataZH = covZH.getData();
        covZH.dispose();
        for (int i = 0; i < dataSR.length; ++i) {
            if (dataZH[i] != 1.0f) continue;
            int n = i;
            dataSR[n] = dataSR[n] / 10.0f;
        }
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/permeabilite_globale.tif", dataSR, entete);
    }

    private static void rasterizeZoneHumide() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Arrays.fill(data, 0.0f);
        String path = "G:/AUDIAR/Donn\u00ef\u00bf\u00bdes2Hugues/Donn\u00ef\u00bf\u00bdes2Hugues/ZonesHumides/";
        Coverage cov2 = ShapeFile2CoverageConverter.getSurfaceCoverage(data, entete, path + "izh_sage_vilaine/izh_sage_vilaine.shp", "code");
        cov2.dispose();
        cov2 = ShapeFile2CoverageConverter.getSurfaceCoverage(data, entete, path + "zone_humide_sage_couesnon/zone_humide_sage_couesnon.shp", "code");
        cov2.dispose();
        cov2 = ShapeFile2CoverageConverter.getSurfaceCoverage(data, entete, path + "zonehumidesagerfbb/zonehumidesagerfbb.shp", "code");
        cov2.dispose();
        CoverageManager.write(path + "zone_humide.tif", data, entete);
    }

    private static void prepaOS() {
        ScriptContinuitesRennesMetropole.recuperationOS2021ebr();
        ScriptContinuitesRennesMetropole.nettoyageOS2021ebr();
        ScriptContinuitesRennesMetropole.nettoyageTypeBoisement();
        ScriptContinuitesRennesMetropole.rasterizeVoies();
        ScriptContinuitesRennesMetropole.rasterizeEau();
        ScriptContinuitesRennesMetropole.compileOS();
    }

    private static void prepaHabitats() {
        ScriptContinuitesRennesMetropole.rasterizeMNIEBoise();
        ScriptContinuitesRennesMetropole.rasterizeMNIEHumide();
        ScriptContinuitesRennesMetropole.rasterizeMNIEGlobaux();
    }

    private static void rasterizeMNIEGlobaux() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/data/MNIE22/MNIE22/MNIE-SIG/MNIE_HAB_PAYS_2022.shp", "code_globa", entete, 0);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/habitat_global.tif", dataN, entete);
    }

    private static void rasterizeMNIEBoise() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/data/MNIE22/MNIE22/MNIE-SIG/MNIE_HAB_PAYS_2022.shp", "code_bois", entete, 0);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/habitat_boise.tif", dataN, entete);
    }

    private static void rasterizeMNIEHumide() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/data/MNIE22/MNIE22/MNIE-SIG/MNIE_HAB_PAYS_2022.shp", "code_humid", entete, 0);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/habitat_humide.tif", dataN, entete);
    }

    private static void compileOS() {
        float[][] datas = new float[6][];
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/surface_eau.tif");
        EnteteRaster entete = cov.getEntete();
        datas[0] = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/troncon_eau.tif");
        datas[1] = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/route_clean.tif");
        datas[2] = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/voie_ferre.tif");
        datas[3] = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/type_boisement_clean.tif");
        datas[4] = cov.getData();
        cov.dispose();
        cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/os_2021_ebr_clean.tif");
        datas[5] = cov.getData();
        cov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        OverlayPixel2PixelTabCalculation cal = new OverlayPixel2PixelTabCalculation(data, entete.noDataValue(), (float[][])datas);
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/rm_os_bre.tif", data, entete);
    }

    private static void rasterizeEau() {
        ScriptContinuitesRennesMetropole.rasterizeSurfacesEau();
        ScriptContinuitesRennesMetropole.rasterizeTronceauEau();
    }

    private static void rasterizeSurfacesEau() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/rennes_metropole/continuite_ecologique/SURFACE_HYDROGRAPHIQUE.shp", entete, 13.0f, 0.0f);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/surface_eau.tif", dataN, entete);
    }

    private static void rasterizeTronceauEau() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getLinearCoverage("H:/rennes_metropole/continuite_ecologique/TRONCON_HYDROGRAPHIQUE.shp", entete, 13.0f, 0.0f);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/troncon_eau.tif", dataN, entete);
    }

    private static void rasterizeVoies() {
        ScriptContinuitesRennesMetropole.rasterizeRoutes();
        ScriptContinuitesRennesMetropole.cleanRoutes();
        ScriptContinuitesRennesMetropole.rasterizeVoiesFerres();
    }

    private static void rasterizeVoiesFerres() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getLinearCoverage("H:/rennes_metropole/continuite_ecologique/TRONCON_DE_VOIE_FERREE.shp", "code", entete, 0.0f, 0.0);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/voie_ferre.tif", dataN, entete);
    }

    private static void rasterizeRoutes() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covN = ShapeFile2CoverageConverter.getLinearCoverage("H:/rennes_metropole/continuite_ecologique/TRONCON_DE_ROUTE.shp", "importance", entete, 0.0f, 0.0);
        float[] dataN = covN.getData();
        covN.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/route.tif", dataN, entete);
    }

    private static void cleanRoutes() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/route.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(3.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(3.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(3.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(4.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(4.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(0.0f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/route_clean.tif", dataSR, entete);
    }

    private static void nettoyageTypeBoisement() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(9.0f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(10.0f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/type_boisement_clean.tif", dataSR, entete);
    }

    private static void nettoyageOS2021ebr() {
        Coverage cov = CoverageManager.getCoverage("H:/rennes_metropole/continuite_ecologique/os_2021_ebr.tif");
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(0.0f), Float.valueOf(0.0f));
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(3.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(4.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(6.0f));
        sarMap.put(Float.valueOf(14.0f), Float.valueOf(7.0f));
        sarMap.put(Float.valueOf(15.0f), Float.valueOf(8.0f));
        sarMap.put(Float.valueOf(16.0f), Float.valueOf(9.0f));
        sarMap.put(Float.valueOf(17.0f), Float.valueOf(9.0f));
        sarMap.put(Float.valueOf(18.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(19.0f), Float.valueOf(11.0f));
        sarMap.put(Float.valueOf(20.0f), Float.valueOf(12.0f));
        sarMap.put(Float.valueOf(22.0f), Float.valueOf(0.0f));
        sarMap.put(Float.valueOf(23.0f), Float.valueOf(13.0f));
        float[] dataSR = new float[data.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(dataSR, data, sarMap);
        cal.run();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/os_2021_ebr_clean.tif", dataSR, entete);
    }

    private static void recuperationOS2021ebr() {
        Coverage cov1 = CoverageManager.getCoverage("H:/rennes_metropole/grain_bocager/rm_type_boisement.tif");
        EnteteRaster enteteRef = cov1.getEntete();
        cov1.dispose();
        Coverage cov = CoverageManager.getCoverage("G:/data/sig/grand_ouest/GO_2021_ebr.tif");
        EnteteRaster entete = cov.getEntete();
        float[] data = cov.getData(EnteteRaster.getROI(entete, enteteRef.getEnvelope()));
        cov.dispose();
        CoverageManager.write("H:/rennes_metropole/continuite_ecologique/os_2021_ebr.tif", data, enteteRef);
    }

    private static void rasterizeCosia() {
        String path = "H:/rennes_metropole/data/";
        Coverage cov = CoverageManager.getCoverage(path + "grain_rm_classif_5m.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Arrays.fill(data, (float)entete.noDataValue());
        for (String file : new File(path + "CoSIA_D035_2020/").list()) {
            if (!file.endsWith(".shp")) continue;
            System.out.println(file);
            Coverage cov2 = ShapeFile2CoverageConverter.getSurfaceCoverage(data, entete, path + "CoSIA_D035_2020/" + file, "numero");
            data = cov2.getData();
            cov2.dispose();
        }
        CoverageManager.write(path + "cosia_2020.tif", data, entete);
    }
}

