/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;

public class Script {
    public static void main(String[] args) {
        Script.scriptMultipleSelected();
    }

    private static void scriptMultipleSelected() {
        long begin = System.currentTimeMillis();
        String path = "C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.setRasterFile(path + "pf_2018_10m.tif");
        builder.addMetric("SHDI");
        builder.addMetric("HET");
        builder.setWindowSize(31);
        builder.setPointsFilter("C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/selected/points_pf.csv");
        builder.addCsvOutput(path + "selected/output/selected_points.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptMultipleSliding() {
        long begin = System.currentTimeMillis();
        String path = "C:/Hugues/data/data_ZA/PF_OS_L93/PF_2018/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setRasterFile(path + "pf_2018_10m.tif");
        builder.addMetric("SHDI");
        builder.addMetric("HET");
        builder.addMetric("NP");
        builder.addMetric("LPI");
        builder.addMetric("MPS");
        builder.setWindowSizes(new int[]{31, 51});
        builder.setUnfilters(new int[]{-1});
        builder.setDisplacement(4);
        builder.addGeoTiffOutput(31, "SHDI", path + "sliding_c5/shdi_31p.tif");
        builder.addGeoTiffOutput(31, "NP", path + "sliding_c5/np_31p.tif");
        builder.addGeoTiffOutput(51, "SHDI", path + "sliding_c5/shdi_51p.tif");
        builder.addGeoTiffOutput(51, "NP", path + "sliding_c5/np_51p.tif");
        builder.addCsvOutput(path + "sliding_c5/sliding_pf_2018.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptSelected() {
        String path = "G:/chloe/winterschool/data/start/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.setRasterFile(path + "za.tif");
        builder.setPointsFilter(path + "points_id.csv");
        builder.setWindowSize(21);
        builder.addMetric("SHDI");
        builder.addCsvOutput(path + "selected2/analyse.csv");
        builder.setWindowsPath(path + "selected2/filters/");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void scriptSlope() {
        long begin = System.currentTimeMillis();
        Tile tile = Tile.getTile("G:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D035_2020-01-27/RGEALTI/1_DONNEES_LIVRAISON_2020-04-00197/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035_geotiff/");
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("G:/data/sig/bd_alti/RGEALTI_2-0_5M_ASC_LAMB93-IGN69_D035_2020-01-27/RGEALTI/1_DONNEES_LIVRAISON_2020-04-00197/RGEALTI_MNT_5M_ASC_LAMB93_IGN69_D035_geotiff/");
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.addMetric("slopedirection");
        builder.addMetric("slopeintensity");
        builder.setWindowSize(3);
        builder.addTileGeoTiffOutput("slopedirection", "H:/temp/slope/direction/", tile);
        builder.addTileGeoTiffOutput("slopeintensity", "H:/temp/slope/intensity/", tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestErwan() {
        String path = "G:/chloe/winterschool/data/start/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.GRID);
        builder.setRasterFile(path + "za.tif");
        builder.setWindowSize(201);
        builder.addMetric("pNV_3");
        builder.addGeoTiffOutput("pNV_3", path + "erwan/prop_prairie_grid_500m.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        long begin = System.currentTimeMillis();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestSliding() {
        String path = "G:/chloe/winterschool/data/start/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_SQUARE);
        builder.setRasterFile(path + "za.tif");
        builder.setWindowSize(201);
        builder.setDisplacement(20);
        builder.addMetric("average");
        builder.addAsciiGridOutput("average", path + "fast/fsaverage.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        long begin = System.currentTimeMillis();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestTileCoverageZA() {
        String path = "H:/temp/tile_coverage/";
        Coverage coverage = CoverageManager.getCoverage(path + "very_little/");
        Tile tile = Tile.getTile((TileCoverage)coverage);
        System.out.println(tile);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setRasterFile("G:/data/sig/bretagne/Bretagne_2019_dispositif_bocage_ebr.tif");
        builder.setWindowSize(501);
        builder.setDisplacement(40);
        builder.addMetric("Majority");
        builder.addTileGeoTiffOutput("Majority", path + "majority_501p/", tile);
        LandscapeMetricAnalysis analysis = builder.build();
        long begin = System.currentTimeMillis();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestTileCoverage() {
        String path = "H:/temp/tile_coverage/";
        Coverage coverage = CoverageManager.getCoverage(path + "mean/");
        Tile tile = Tile.getTile((TileCoverage)coverage);
        System.out.println(tile);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setCoverage(coverage);
        builder.setWindowSize(21);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("average");
        builder.addTileAsciiGridOutput("average", path + "average/", tile);
        LandscapeMetricAnalysis analysis = builder.build();
        long begin = System.currentTimeMillis();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestGenerateTileCoverage() {
        System.out.println("importation des tuiles");
        Coverage cov = CoverageManager.getCoverage("H:/temp/tile_coverage/little/");
        Rectangle localRoi = new Rectangle(500, 1500, 2000, 2000);
        System.out.println("recuperation des donnees locales");
        float[] roiDatas = cov.getData(localRoi);
        System.out.println("recuperation de l'entete locale");
        EnteteRaster roiEntete = EnteteRaster.getEntete(cov.getEntete(), localRoi);
        System.out.println("exportation du raster local");
        CoverageManager.writeGeotiff("H:/temp/tile_coverage/test_35_local2.tif", roiDatas, roiEntete);
    }

    private static void scriptTestEntity() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "za.tif");
        builder.setEntityRasterFile(path + "communes_za.asc");
        builder.addMetric("SHDI");
        builder.setAsciiGridOutputFolder(path + "communes/");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestMinimumValidValue() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za_2018.asc");
        builder.setWindowSize(51);
        builder.setDisplacement(5);
        builder.setMinRate(100.0);
        builder.addMetric("SHDI");
        builder.addAsciiGridOutput("SHDI", path + "valid/shdi_3.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestOutput() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(201);
        builder.setDisplacement(20);
        for (int i = 1; i <= 12; ++i) {
            builder.addMetric("pNV_" + i);
            for (int j = 1; j <= 12; ++j) {
                if (i >= j) continue;
                builder.addMetric("pNC_" + i + "-" + j);
            }
        }
        builder.setGeoTiffOutputFolder(path + "output4/");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestEcopaysage() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(201);
        builder.setDisplacement(20);
        for (int i = 1; i <= 12; ++i) {
            builder.addMetric("pNV_" + i);
            for (int j = 1; j <= 12; ++j) {
                if (i >= j) continue;
                builder.addMetric("pNC_" + i + "-" + j);
            }
        }
        builder.addCsvOutput(path + "ecopaysage/analyse_za_5km.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestQuantitative() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setRasterFile(path + "fast/cshdi_201p_dep20.asc");
        builder.setWindowSize(21);
        builder.addMetric("average");
        builder.addAsciiGridOutput("average", path + "fast/fgaverage_21p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestSelected() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.setPointsFilter("G:/chloe/winterschool/data/start/selected/points.csv");
        builder.setRasterFile(path + "za.tif");
        builder.setWindowSize(101);
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("SHDI");
        builder.addCsvOutput("G:/chloe/winterschool/data/start/selected/new/test5.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestWithoutShape() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.setRasterFile(path + "za.tif");
        builder.setWindowSize(21);
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("SHDI");
        builder.addAsciiGridOutput("SHDI", path + "without_shape/without_shdi.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestNais() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SLIDING);
        builder.setRasterFile(path + "za.tif");
        builder.setWindowSize(201);
        builder.setWindowSize(401);
        builder.setDisplacement(20);
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("SHEI");
        builder.addAsciiGridOutput(201, "SHEI", path + "diversity/shei_201.asc");
        builder.addAsciiGridOutput(401, "SHEI", path + "diversity/shei_401.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestMap() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.MAP);
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setROIX(0);
        builder.setROIY(0);
        builder.setROIWidth(21);
        builder.setROIHeight(21);
        builder.addMetric("NV_5");
        builder.addCsvOutput(path + "map/analyse.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestGrid() {
        String path = "G:/chloe/winterschool/data/start/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setAnalysisType(ChloeAnalysisType.GRID);
        builder.setWindowSize(10);
        builder.setROIX(100);
        builder.setROIY(100);
        builder.setROIWidth(1000);
        builder.setROIHeight(1000);
        builder.addMetric("NV_1");
        builder.addAsciiGridOutput("NV_1", path + "grid/huge_roi_nv1_grid_10p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestComptageValueAndCouple() {
        long begin = System.currentTimeMillis();
        String path = "G:/chloe/winterschool/data/start/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(101);
        builder.setDisplacement(20);
        builder.addMetric("HET-frag");
        builder.addAsciiGridOutput("HET-frag", path + "test2/HET-frag_201p_dep20.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEcopaysageAmazonie() {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(9);
        codes.add(11);
        codes.add(12);
        codes.add(15);
        codes.add(20);
        codes.add(21);
        codes.add(23);
        codes.add(24);
        codes.add(25);
        codes.add(30);
        codes.add(32);
        codes.add(33);
        codes.add(39);
        codes.add(41);
        codes.add(48);
        codes.add(63);
        Script.scriptEcopaysageAmazonie("composition", "25km", codes);
    }

    private static void scriptEcopaysageAmazonie(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "H:/amazonie/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "data/mapbiomas-brazil-collection-70-amazonia-2019.tif");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("5km")) {
            builder.setWindowSize(333);
            builder.setDisplacement(33);
        }
        if (scale.equalsIgnoreCase("10km")) {
            builder.setWindowSize(667);
            builder.setDisplacement(66);
        }
        if (scale.equalsIgnoreCase("25km")) {
            builder.setWindowSize(1667);
            builder.setDisplacement(160);
        }
        if (scale.equalsIgnoreCase("50km")) {
            builder.setWindowSize(3333);
            builder.setDisplacement(330);
        }
        builder.setUnfilters(new int[]{0});
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/test_amazonie_" + compo_config + "_" + scale + ".csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptAmazonieTest() {
        long begin = System.currentTimeMillis();
        String path = "H:/amazonie/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "mapbiomas-brazil-collection-70-amazonia-2019.tif");
        builder.setValues("3, 4, 5, 9, 11, 12, 15, 20, 21, 23, 24 ,25, 30, 32, 33, 39, 41, 48, 63");
        builder.addMetric("SHDI");
        builder.setWindowSize(333);
        builder.setDisplacement(30);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addAsciiGridOutput("SHDI", path + "amazonie_shdi.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestMPS() {
        long begin = System.currentTimeMillis();
        String path = "G:/PREPARE/toulouse/model/test_MPS/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "s1_cover_2020.asc");
        builder.addMetric("Central");
        builder.addMetric("pCentral");
        builder.addMetric("pNV_6");
        builder.addMetric("N-valid");
        builder.addMetric("pNC_6-24");
        builder.setDisplacement(10);
        builder.setWindowSize(401);
        builder.addAsciiGridOutput("Central", path + "chloe5/data.asc");
        builder.addAsciiGridOutput("pCentral", path + "chloe5/data1.asc");
        builder.addAsciiGridOutput("pNV_6", path + "chloe5/data2.asc");
        builder.addAsciiGridOutput("N-valid", path + "chloe5/data3.asc");
        builder.addAsciiGridOutput("pNC_6-24", path + "chloe5/data4.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void test2() {
        GridCoverage2D cov = CoverageManager.get("F:/IGN/35-2020-0320-6785-LA93-5M-MNHC/35-2020-0320-6785-LA93-5M-MNHC.tif");
        float[] tileDatas = CoverageManager.getData(cov, 0, 0, 1000, 1000);
        cov.dispose(true);
        ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)cov.getRenderedImage()));
    }

    private static void propClassifGrainPaysdelaLoire() {
        long begin = System.currentTimeMillis();
        String path = "F:/FRC_Pays_de_la_Loire/data/BocagePdlL_V3/test2/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "grain_PdlL_classif.asc");
        builder.addMetric("pNV_1");
        builder.setWindowSize(401);
        builder.setDisplacement(40);
        builder.addAsciiGridOutput("pNV_1", path + "prop_grain_10km.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptSHDIClusterGrainPaysdelaLoire() {
        long begin = System.currentTimeMillis();
        String path = "F:/FRC_Pays_de_la_Loire/data/BocagePdlL_V3/test2/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "cluster_grain.asc");
        builder.addMetric("SHDI");
        builder.setWindowSize(401);
        builder.setDisplacement(40);
        builder.addAsciiGridOutput("SHDI", path + "shdi_10km.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainPaysdelaLoire() {
        long begin = System.currentTimeMillis();
        String path = "F:/FRC_Pays_de_la_Loire/data/BocagePdlL_V3/test2/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "distance_bois_2021_2.tif");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.setDisplacement(10);
        builder.addAsciiGridOutput("MD", path + "grain_pays_loire_101p_dep10_2.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainGers() {
        String path = "F:/gers/data/wetransfer_overlay_dist-1-2-asc_2022-03-03_1538/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "overlay_dist-[1, 2].asc");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("MD", path + "grain.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void boisementBaieLancieux() {
        long begin = System.currentTimeMillis();
        String path = "F://dreal/ophelie/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "cgtv_baie_lancieux.asc");
        builder.addMetric("pNMV_12-13-14-17-18-19");
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.setWindowSize(41);
        builder.addAsciiGridOutput("pNMV_12-13-14-17-18-19", path + "boisement.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void luminanceBaieLancieux() {
        long begin = System.currentTimeMillis();
        String path = "F://dreal/ophelie/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "cgtv_baie_lancieux.asc");
        builder.addMetric("pNMV_25-26");
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.setWindowSize(41);
        builder.addAsciiGridOutput("pNMV_25-26", path + "elumi_100m.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void retileBaieLancieux() {
        double minx = 306091.0;
        double maxx = 328852.0;
        double miny = 6831235.0;
        double maxy = 6853026.0;
        String fileCGTV = "F://data/sig/CGTV/cgtv.tif";
        String fileBaie = "F://dreal/ophelie/cgtv_baie_lancieux.asc";
        CoverageManager.retile(fileCGTV, fileBaie, minx, maxx, miny, maxy, Raster.getNoDataValue());
    }

    private static void scriptEcopaysageBretagneCGTV() {
        Raster.setNoDataValue(255);
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(6);
        codes.add(7);
        codes.add(8);
        codes.add(9);
        codes.add(10);
        codes.add(11);
        codes.add(12);
        codes.add(13);
        codes.add(14);
        codes.add(15);
        codes.add(16);
        codes.add(17);
        codes.add(18);
        codes.add(19);
        codes.add(20);
        codes.add(21);
        codes.add(22);
        codes.add(23);
        codes.add(24);
        codes.add(25);
        codes.add(26);
        codes.add(27);
        Script.scriptEcopaysageBretagneCGTV("composition", "3km", codes);
        Script.scriptEcopaysageBretagneCGTV("configuration", "3km", codes);
    }

    private static void scriptEcopaysageBretagneCGTV(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/dreal/ecopaysage/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("F:/data/sig/CGTV/cgtv.tif");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("500m")) {
            builder.setWindowSize(401);
        }
        if (scale.equalsIgnoreCase("3km")) {
            builder.setWindowSize(2401);
        }
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.setUnfilters(new int[]{23, 255});
        builder.addCsvOutput(path + "analyse2/bretagne_cgtv_" + compo_config + "_" + scale + ".csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainEloise() {
        long begin = System.currentTimeMillis();
        String path = "F:/Eloise/data/analyse/distance/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "haie_large_clean_dist-[99].asc");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("MD", path + "grain_101.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceIGN5() {
        String path = "F:/IGN/35-2020-0320-6785-LA93-5M-MNHC/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "35-2020-0320-6785-LA93-5M-MNHC.tif");
        builder.setRasterFile2(path + "local_wood.asc");
        builder.addMetric("distance");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("distance", path + "test_ign4.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceIGN4() {
        String path = "F:/IGN/35-2020-0320-6785-LA93-5M-MNHC/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "35-2020-0320-6785-LA93-5M-MNHC.tif");
        builder.addMetric("standard_deviation");
        builder.setWindowSize(7);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addAsciiGridOutput("standard_deviation", path + "standard_deviation.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceIGN3() {
        String path = "F:/IGN/35-2020-0320-6785-LA93-5M-MNHC/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "35-2020-0320-6785-LA93-5M-MNHC.tif");
        builder.addMetric("bocage");
        builder.setWindowSize(13);
        builder.addAsciiGridOutput("bocage", path + "local_wood.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceIGN2() {
        String path = "F:/IGN/35-2020-0320-6785-LA93-5M-MNHC/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "35-2020-0320-6785-LA93-5M-MNHC_max.tif");
        builder.addMetric("distance");
        builder.setWindowSize(41);
        builder.addAsciiGridOutput("distance", path + "test_ign2.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceIGN() {
        String path = "C:/Hugues/data/ascii/aparapi/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "wood.asc");
        builder.addMetric("distance");
        builder.setWindowSize(51);
        builder.addAsciiGridOutput("distance", path + "result_test_aparapi_2.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestDistanceFunction() {
        String path = "C:/Hugues/data/ascii/qualitative-no-data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "raster2007.asc");
        builder.setValues("1, 2, 3");
        builder.addMetric("pNV_1");
        builder.setWindowSize(51);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addAsciiGridOutput("pNV_1", path + "distance/pNV_1_dyn-4.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainBasLeon() {
        String path = "F:/bas_leon/data2/grain/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "bas_leon_distance_bois.asc");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("MD", path + "bas_leon_grain.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEcopaysageDordogneRPG2017() {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(6);
        codes.add(7);
        codes.add(8);
        codes.add(11);
        codes.add(18);
        codes.add(19);
        codes.add(21);
        codes.add(28);
        codes.add(30);
        codes.add(33);
        Script.scriptEcopaysageDordogneRPG2017("composition", "275m", codes);
        Script.scriptEcopaysageDordogneRPG2017("configuration", "275m", codes);
        Script.scriptEcopaysageDordogneRPG2017("composition", "1-5km", codes);
        Script.scriptEcopaysageDordogneRPG2017("configuration", "1-5km", codes);
    }

    private static void scriptEcopaysageDordogneRPG2017(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/aquitaine/dordogne/socio_ecosysteme_spatial/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "carto/dordogne_carto_2017.asc");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("275m")) {
            builder.setWindowSize(221);
        }
        if (scale.equalsIgnoreCase("1-5km")) {
            builder.setWindowSize(1201);
        }
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/dordogne_rpg_2017_" + compo_config + "_" + scale + "_dep40.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptLocalWoodOFBZA() {
        long begin = System.currentTimeMillis();
        String path = "F:/OFB/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "ocsol_terrain.asc");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_4");
        builder.addMetric("pNV_5");
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setWindowSize(3);
        builder.addAsciiGridOutput("pNV_4", path + "local_haie_3p.asc");
        builder.addAsciiGridOutput("pNV_5", path + "local_bois_3p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptPropPrairieLocalOFBZA() {
        long begin = System.currentTimeMillis();
        String path = "F:/OFB/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "cgtv_terrain.asc");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 ,14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 255");
        builder.addMetric("pNV_5");
        builder.addMetric("pNV_6");
        builder.setWindowSize(5);
        builder.addAsciiGridOutput("pNV_5", path + "prop_pp_5p.asc");
        builder.addAsciiGridOutput("pNV_6", path + "prop_pph_5p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptPropPrairieOFBZA() {
        long begin = System.currentTimeMillis();
        String path = "F:/OFB/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "ocsol_terrain.asc");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_3");
        builder.setWindowSize(201);
        builder.addAsciiGridOutput("pNV_3", path + "prop_prairie_201.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptPropBoisOFBZA() {
        long begin = System.currentTimeMillis();
        String path = "F:/OFB/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "ocsol_terrain.asc");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_4");
        builder.addMetric("pNV_5");
        builder.setWindowSize(21);
        builder.addAsciiGridOutput("pNV_4", path + "prop_haie_21.asc");
        builder.addAsciiGridOutput("pNV_5", path + "prop_bois_21.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainOFBZA() {
        long begin = System.currentTimeMillis();
        String path = "F:/OFB/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "distance_elt_bois.asc");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("MD", path + "grain_101.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptPropPrairieTerrainEcofriche2() {
        long begin = System.currentTimeMillis();
        String path = "F:/ecofriche2/continuites/terrain/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "ocsol_terrain.tif");
        builder.addMetric("pNV_3");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(201);
        builder.addAsciiGridOutput("pNV_3", path + "prop_prairie_201p_terrain.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainTerrainEcofriche2() {
        long begin = System.currentTimeMillis();
        String path = "F:/ecofriche2/continuites/terrain/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "distance_elts_boises.asc");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.addAsciiGridOutput("MD", path + "grain_terrain_101.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptStandardDeviationMNTPREPAREToulouse() {
        String path = "F:/PREPARE/toulouse/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "mnt_standard_deviation_5p.asc");
        builder.setEntityRasterFile(path + "parcellaire_toulouse_5m.asc");
        builder.addMetric("maximum");
        builder.addCsvOutput(path + "mnt_standard_deviation/parcelles_max_slope_mnt.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptStandardDeviationMNTPREPAREToulouseBis() {
        String path = "F:/PREPARE/toulouse/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "T01alti25m.tif");
        builder.setEntityRasterFile(path + "parcellaire_toulouse.asc");
        builder.addMetric("standard_deviation");
        builder.setAsciiGridOutputFolder(path + "mnt_standard_deviation/");
        builder.addCsvOutput(path + "mnt_standard_deviation/parcelles_standard_deviation_mnt_bis.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptAverageMNTPREPAREToulouse() {
        String path = "F:/PREPARE/toulouse/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "MNT5mT01.tif");
        builder.setEntityRasterFile(path + "parcellaire_toulouse_5m.asc");
        builder.addMetric("average");
        builder.addCsvOutput(path + "mnt_5m_average/parcelles_average_mnt.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptMNTPREPAREToulouse() {
        long begin = System.currentTimeMillis();
        String path = "F:/PREPARE/toulouse/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "MNT5mT01.asc");
        builder.addMetric("standard_deviation");
        builder.setWindowSize(7);
        builder.addAsciiGridOutput("standard_deviation", path + "mnt_standard_deviation_7p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofriche() {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "occsol_sitesecofriche1.tif");
        builder.setEntityRasterFile(path + "unites_gestion_sites_ecofriche1.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_3");
        builder.addMetric("pNV_4");
        builder.addMetric("pNV_5");
        builder.addMetric("pNV_6");
        builder.setAsciiGridOutputFolder(path + "prop/");
        builder.addCsvOutput(path + "entites_composition_bis.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofricheRPG() {
        Script.scriptEntitesGestionEcofricheRPGCompositionBaseCGTVZoneHumide("rpg2009R");
        Script.scriptEntitesGestionEcofricheRPGCompositionBaseCGTVZoneHumide("rpg2009buffR");
        Script.scriptEntitesGestionEcofricheRPGCompositionBaseCGTVZoneHumide("rpg2014R");
        Script.scriptEntitesGestionEcofricheRPGCompositionBaseCGTVZoneHumide("rpg2014buffR");
    }

    private static void scriptEntitesGestionEcofricheRPGCompositionBaseCGTVZoneHumide(String period) {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("F:/data/sig/CGTV/cgtv_humide.tif");
        builder.setEntityRasterFile(path + "rpg/select/" + period + ".tif");
        builder.setValues("1, 2");
        builder.addMetric("pNV_1");
        builder.addMetric("N-valid");
        builder.addCsvOutput(path + "entites_" + period + "_composition_cgtv_humide.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofricheRPGCompositionBaseCGTV(String period) {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("F:/data/sig/CGTV/cgtv.tif");
        builder.setEntityRasterFile(path + "rpg/select/" + period + ".tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 ,14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27");
        for (int v : builder.getValues()) {
            builder.addMetric("pNV_" + v);
        }
        builder.addMetric("N-valid");
        builder.addCsvOutput(path + "entites_" + period + "_composition_cgtv.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofricheRPGConfigurationBaseCGTV(String period) {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("F:/data/sig/CGTV/cgtv.tif");
        builder.setEntityRasterFile(path + "rpg/select/" + period + ".tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 ,14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27");
        for (int v1 : builder.getValues()) {
            for (int v2 : builder.getValues()) {
                if (v1 > v2) continue;
                builder.addMetric("pNC_" + v1 + "-" + v2);
            }
        }
        builder.addMetric("NC-valid");
        builder.addCsvOutput(path + "entites_" + period + "_configuration_cgtv.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofricheRPGComposition(String period) {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("F:/data/sig/bretagne/Bretagne_2018_dispositif_bocage_reb_4.tif");
        builder.setEntityRasterFile(path + "rpg/select/" + period + ".tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        for (int v : builder.getValues()) {
            builder.addMetric("pNV_" + v);
        }
        builder.addMetric("N-valid");
        builder.addCsvOutput(path + "entites_" + period + "_composition_occsol.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEntitesGestionEcofricheRPGConfiguration(String period) {
        String path = "F:/ecofriche2/ecopaysage/entite_gestion/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("F:/data/sig/bretagne/Bretagne_2018_dispositif_bocage_reb_4.tif");
        builder.setEntityRasterFile(path + "rpg/select/" + period + ".tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        for (int v1 : builder.getValues()) {
            for (int v2 : builder.getValues()) {
                if (v1 > v2) continue;
                builder.addMetric("pNC_" + v1 + "-" + v2);
            }
        }
        builder.addMetric("NC-valid");
        builder.addCsvOutput(path + "entites_" + period + "_configuration_occsol.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainBretagne() {
        long begin = System.currentTimeMillis();
        String path = "F:/FDCCA/bretagne/grain_10m/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "distance_bois_bretagne.tif");
        builder.addMetric("MD");
        builder.setWindowSize(101);
        builder.setDisplacement(2);
        builder.addAsciiGridOutput("MD", path + "grain_bretagne_101p_dep2.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEcopaysageNouvelleAquitaine() {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(6);
        codes.add(7);
        codes.add(8);
        codes.add(9);
        codes.add(10);
        Script.scriptEcopaysageNouvelleAquitaine("composition", "500m", codes);
        Script.scriptEcopaysageNouvelleAquitaine("configuration", "500m", codes);
        Script.scriptEcopaysageNouvelleAquitaine("composition", "3km", codes);
        Script.scriptEcopaysageNouvelleAquitaine("configuration", "3km", codes);
    }

    private static void scriptEcopaysageNouvelleAquitaine(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/aquitaine/nouvelle_aquitaine/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "ocs_15_na_ecopaysage_dnsb.tif");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("500m")) {
            builder.setWindowSize(401);
        }
        if (scale.equalsIgnoreCase("3km")) {
            builder.setWindowSize(2401);
        }
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/nouvelle_aquitaine_" + compo_config + "_" + scale + "_dep40.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptLocalWoodCoterra() {
        long begin = System.currentTimeMillis();
        String path = "F:/coterra/data/Coterra_2019_DNSB_erb/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "Coterra_2019_DNSB_erb_alternative.asc");
        builder.addMetric("pNV_4");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(3);
        builder.addAsciiGridOutput("pNV_4", path + "analyse/Coterra_local_wood_3p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptPropPrairieCoterra() {
        long begin = System.currentTimeMillis();
        String path = "F:/coterra/data/Coterra_2019_DNSB_erb/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "Coterra_2019_DNSB_erb.tif");
        builder.addMetric("pNV_3");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.setWindowSize(201);
        builder.setDisplacement(20);
        builder.setInterpolation(true);
        builder.addAsciiGridOutput("pNV_3", path + "analyse/Coterra_prop_prairie_201p.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEcopaysageCoterra() {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(6);
        codes.add(7);
        codes.add(8);
        codes.add(9);
        codes.add(10);
        codes.add(11);
        codes.add(12);
        Script.scriptEcopaysageCoterra("composition", "500m", codes);
        Script.scriptEcopaysageCoterra("configuration", "500m", codes);
        Script.scriptEcopaysageCoterra("composition", "3km", codes);
        Script.scriptEcopaysageCoterra("configuration", "3km", codes);
    }

    private static void scriptEcopaysageCoterra(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/coterra/data/Coterra_2019_DNSB_erb/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "Coterra_2019_DNSB_erb.tif");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("500m")) {
            builder.setWindowSize(401);
        }
        if (scale.equalsIgnoreCase("3km")) {
            builder.setWindowSize(2401);
        }
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/coterra_" + compo_config + "_" + scale + "_dep40.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainCoterra() {
        String path = "F:/coterra/data/Coterra_2019_DNSB_erb/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "Coterra_2019_DNSB_erb_distance_elt_boises.asc");
        builder.addMetric("MD");
        builder.setWindowSize(141);
        builder.addAsciiGridOutput("MD", path + "Coterra_2019_DNSB_erb_grain_bocager.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestValuesAndCouples() {
        long begin = System.currentTimeMillis();
        String path = "F:/chloe/chloe5/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_1");
        builder.addMetric("pNC_1-2");
        builder.setWindowSize(21);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptFeature() {
        String path = "F:/chloe/chloe5/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile(path + "za.asc");
        builder.setEntityRasterFile(path + "feature/feature_za.asc");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("pNV_3");
        builder.addMetric("NV_3");
        builder.addCsvOutput(path + "feature/feature_za2.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTest(String singleOrHuge) {
        String path = "";
        path = singleOrHuge.equalsIgnoreCase("single") ? "F:/chloe/chloe5/data/" : "F:/data/sig/bretagne/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        if (singleOrHuge.equalsIgnoreCase("single")) {
            builder.setRasterFile(path + "za.tif");
        } else {
            builder.setRasterFile(path + "Bretagne_2018_dispositif_bocage_reb_4.tif");
        }
        builder.addMetric("SHDI");
        builder.setWindowSize(21);
        builder.addAsciiGridOutput("SHDI", path + "SHDI.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptCouesnon() {
        Script.scriptPropPrairieCouesnon("DoublePerf_2050");
        Script.scriptPropPrairieCouesnon("OS_2018");
        Script.scriptPropPrairieCouesnon("UtopiaBGIN_2050");
    }

    private static void scriptPropPrairieCouesnon(String name) {
        String path = "F:/Couesnon/analyse2/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "OS_Couesnon_bocage/cover_" + name + ".tif");
        builder.setValues("1, 2, 3, 4, 8, 9, 21, 22, 23, 31, 32");
        builder.addMetric("pNV_31");
        builder.addMetric("pNV_32");
        builder.setWindowSize(101);
        builder.setDisplacement(10);
        builder.setInterpolation(true);
        builder.addCsvOutput(path + "prairial/prop_prairie_" + name + ".csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptGrainCouesnon(String name) {
        String path = "F:/Couesnon/analyse2/data/";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "distance_bois/" + name + "_distance_bois.asc");
        builder.addMetric("MD");
        builder.setWindowSize(71);
        builder.addAsciiGridOutput("MD", path + "grain/" + name + "_grain.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptTestFocus() {
        long begin = System.currentTimeMillis();
        String path = "F:/chloe/chloe5/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.tif");
        builder.addMetric("sum");
        builder.setWindowSize(101);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptEcopaysageBretagne() {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(6);
        codes.add(7);
        codes.add(8);
        codes.add(9);
        codes.add(10);
        codes.add(11);
        codes.add(12);
        Script.scriptEcopaysageBretagne("composition", "500m", codes);
        Script.scriptEcopaysageBretagne("configuration", "500m", codes);
        Script.scriptEcopaysageBretagne("composition", "3km", codes);
        Script.scriptEcopaysageBretagne("configuration", "3km", codes);
    }

    private static void scriptEcopaysageBretagne(String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/ecofriche2/ecopaysage/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile("F:/data/sig/bretagne/Bretagne_2018_dispositif_bocage_reb_4.tif");
        StringBuilder sb = new StringBuilder();
        for (int c : codes) {
            sb.append(c + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        builder.setValues(sb.toString());
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("500m")) {
            builder.setWindowSize(401);
        }
        if (scale.equalsIgnoreCase("3km")) {
            builder.setWindowSize(2401);
        }
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/bretagne_" + compo_config + "_" + scale + "_dep40.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptLea() {
        long begin = System.currentTimeMillis();
        String path = "F:/temp/lea/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "fav_cheveche5m.tif");
        builder.addMetric("average");
        builder.setWindowSize(121);
        builder.addAsciiGridOutput("average", path + "average_121p_c.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void script1() {
        long begin = System.currentTimeMillis();
        String path = "F:/chloe/chloe5/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.tif");
        builder.setValues("1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12");
        builder.addMetric("SHDI");
        builder.setWindowSize(23);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.addCsvOutput(path + "analyse/shdi_23_writer2.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptHuge() {
        long begin = System.currentTimeMillis();
        String path = "F:/chloe/chloe5/data/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "za.asc");
        builder.addMetric("SHDI");
        builder.setWindowSize(21);
        builder.setDisplacement(2);
        builder.setInterpolation(true);
        builder.addAsciiGridOutput("SHDI", path + "analyse/shdi_ex100_300_bis.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptACE() {
        HashSet<Integer> codes = new HashSet<Integer>();
        codes.add(1);
        codes.add(2);
        codes.add(3);
        codes.add(4);
        codes.add(5);
        codes.add(7);
    }

    private static void scriptACE(String year, String compo_config, String scale, Set<Integer> codes) {
        long begin = System.currentTimeMillis();
        String path = "F:/aquitaine/ocs/OCS_Dordogne_00_09_15_raster/eau_divers/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setDisplacement(20);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        builder.setRasterFile(path + "carto/OCS_Dordogne_" + year + ".tif");
        if (compo_config.equalsIgnoreCase("composition")) {
            for (int i : codes) {
                builder.addMetric("pNV_" + i);
            }
        }
        if (compo_config.equalsIgnoreCase("configuration")) {
            for (int i : codes) {
                for (int j : codes) {
                    if (j <= i) continue;
                    builder.addMetric("pNC_" + i + "-" + j);
                }
            }
        }
        if (scale.equalsIgnoreCase("300m")) {
            builder.setWindowSize(121);
        }
        if (scale.equalsIgnoreCase("500m")) {
            builder.setWindowSize(201);
        }
        if (scale.equalsIgnoreCase("700m")) {
            builder.setWindowSize(281);
        }
        if (scale.equalsIgnoreCase("2km")) {
            builder.setWindowSize(801);
        }
        if (scale.equalsIgnoreCase("3km")) {
            builder.setWindowSize(1201);
        }
        if (scale.equalsIgnoreCase("3-5km")) {
            builder.setWindowSize(1401);
        }
        builder.addCsvOutput(path + "analyse/ace_" + compo_config + "_" + year + "_" + scale + ".csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptFDCCA() {
        long begin = System.currentTimeMillis();
        String path = "F:/FDCCA/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "secteur4bis/carto/secteur4bis_distance.asc");
        builder.addMetric("MD");
        builder.setWindowSize(141);
        builder.addAsciiGridOutput("MD", path + "secteur4/carto/secteur4bis_grain.asc");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptBasleonEcopaysageFonctionnel() {
        long begin = System.currentTimeMillis();
        String path = "F:/bas_leon/data/continuite/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "zh/norm_continuites_zones_humides.asc");
        builder.addMetric("sum");
        builder.setWindowSize(2401);
        builder.setDisplacement(40);
        builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptClemence() {
        long begin = System.currentTimeMillis();
        String path = "F:/agent/clemence_brosse/Limousin/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(path + "Limousin.tif");
        builder.setWindowSize(3);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptMathilde() {
        String path = "F:/woodnet/mathilde/Continuity/";
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.SELECTED);
        builder.setRasterFile(path + "PF.asc");
        builder.setWindowSize(151);
        builder.setPointsFilter(path + "points.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }
}

