/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.script;

import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoTiffExporter {
    public static void main(String[] args) throws Exception {
    }

    public static void littleMap() throws Exception {
        int width = 1000;
        int height = 1000;
        BufferedImage image = new BufferedImage(width, height, 10);
        WritableRaster raster = image.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int value = (x + y) % 256;
                raster.setSample(x, y, 0, value);
            }
        }
        double minX = -5.0;
        double minY = 47.0;
        double maxX = -4.0;
        double maxY = 48.0;
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154");
        GeneralEnvelope envelope = new GeneralEnvelope(2);
        envelope.setCoordinateReferenceSystem(crs);
        envelope.setRange(0, minX, maxX);
        envelope.setRange(1, minY, maxY);
        GridCoverageFactory gcf = new GridCoverageFactory();
        GridCoverage2D coverage = gcf.create((CharSequence)"Example", (RenderedImage)image, (Envelope)envelope);
        File outputFile = new File("C:/Data/temp/export/exported_image.tif");
        GeoTiffWriter writer = new GeoTiffWriter((Object)outputFile);
        writer.write((GridCoverage)coverage, null);
        System.out.println("GeoTIFF exported: " + outputFile.getAbsolutePath());
    }

    public static void hugeMap() throws Exception {
        int tileSize = 1024;
        int tilesX = 100;
        int tilesY = 100;
        double pixelSize = 1.0;
        double originX = 500000.0;
        double originY = 6300000.0;
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154", (boolean)true);
        GridCoverageFactory gcf = new GridCoverageFactory();
        for (int ty = 0; ty < 100; ++ty) {
            for (int tx = 0; tx < 100; ++tx) {
                int tileWidth = 1024;
                int tileHeight = 1024;
                BufferedImage image = new BufferedImage(tileWidth, tileHeight, 10);
                WritableRaster raster = image.getRaster();
                for (int j = 0; j < tileHeight; ++j) {
                    for (int i = 0; i < tileWidth; ++i) {
                        int globalX = tx * 1024 + i;
                        int globalY = ty * 1024 + j;
                        int value = (globalX / 100 + globalY / 100) % 256;
                        raster.setSample(i, j, 0, value);
                    }
                }
                double minX = originX + (double)(tx * 1024) * pixelSize;
                double maxY = originY - (double)(ty * 1024) * pixelSize;
                double maxX = minX + 1024.0 * pixelSize;
                double minY = maxY - 1024.0 * pixelSize;
                GeneralEnvelope envelope = new GeneralEnvelope(2);
                envelope.setCoordinateReferenceSystem(crs);
                envelope.setRange(0, minX, maxX);
                envelope.setRange(1, minY, maxY);
                GridCoverage2D coverage = gcf.create((CharSequence)("tile_" + tx + "_" + ty), (RenderedImage)image, (Envelope)envelope);
                File tileFile = new File("C:/Data/temp/export/tiles/tile_" + ty + "_" + tx + ".tif");
                tileFile.getParentFile().mkdirs();
                GeoTiffWriter writer = new GeoTiffWriter((Object)tileFile);
                writer.write((GridCoverage)coverage, null);
                System.out.println("\u00f0\u009f\u00a7\u00a9 Wrote tile: " + tileFile.getName());
            }
        }
        System.out.println("\u00e2\u009c\u0085 All tiles written.");
    }

    public static void hugeMap4() throws Exception {
        int width = 50000;
        int height = 50000;
        int tileSize = 1024;
        double pixelSize = 1.0;
        double xMin = 500000.0;
        double yMax = 6300000.0;
        double xMax = 550000.0;
        double yMin = 6250000.0;
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154", (boolean)true);
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)1024, (int)1024, (int)1);
        long numPixels = 2500000000L;
        if (numPixels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Raster too large for in-memory buffer. Try chunked writing to disk.");
        }
        DataBufferByte dataBuffer = new DataBufferByte((int)numPixels);
        WritableRaster raster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(50000, 50000), dataBuffer, new Point(0, 0));
        for (int y = 0; y < 50000; y += 1024) {
            for (int x = 0; x < 50000; x += 1024) {
                int w = Math.min(1024, 50000 - x);
                int h = Math.min(1024, 50000 - y);
                byte[] tilePixels = new byte[w * h];
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        int value = ((x + i) / 100 + (y + j) / 100) % 256;
                        tilePixels[j * w + i] = (byte)value;
                    }
                }
                raster.setDataElements(x, y, w, h, tilePixels);
            }
        }
        BufferedImage image = new BufferedImage(null, raster, false, null);
        GeneralEnvelope envelope = new GeneralEnvelope(2);
        envelope.setCoordinateReferenceSystem(crs);
        envelope.setRange(0, 500000.0, 550000.0);
        envelope.setRange(1, 6250000.0, 6300000.0);
        GridCoverageFactory gcf = new GridCoverageFactory();
        GridCoverage2D coverage = gcf.create((CharSequence)"tiled_epsg2154", (RenderedImage)image, (Envelope)envelope);
        File outputFile = new File("C:/Data/temp/export/geo2_large_image.tif");
        GeoTiffWriter writer = new GeoTiffWriter((Object)outputFile);
        writer.write((GridCoverage)coverage, null);
        System.out.println("\u00e2\u009c\u0085 Tiled GeoTIFF written to: " + outputFile.getAbsolutePath());
    }

    public static void hugeMap3() throws Exception {
        int width = 10000;
        int height = 10000;
        double pixelSize = 1.0;
        double xMin = 500000.0;
        double yMax = 6300000.0;
        double xMax = xMin + 10000.0 * pixelSize;
        double yMin = yMax - 10000.0 * pixelSize;
        BufferedImage image = new BufferedImage(10000, 10000, 10);
        WritableRaster raster = image.getRaster();
        for (int y = 0; y < 10000; ++y) {
            for (int x = 0; x < 10000; ++x) {
                int value = (x + y) / 100 % 256;
                raster.setSample(x, y, 0, value);
            }
        }
        GeneralEnvelope envelope = new GeneralEnvelope(2);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:2154", (boolean)true);
        envelope.setCoordinateReferenceSystem(crs);
        envelope.setRange(0, xMin, xMax);
        envelope.setRange(1, yMin, yMax);
        GridCoverageFactory gcf = new GridCoverageFactory();
        GridCoverage2D coverage = gcf.create((CharSequence)"georef_image", (RenderedImage)image, (Envelope)envelope);
        File outputFile = new File("C:/Data/temp/export/geo_large_image.tif");
        GeoTiffWriter writer = new GeoTiffWriter((Object)outputFile);
        writer.write((GridCoverage)coverage, null);
        System.out.println("\u00e2\u009c\u0085 GeoTIFF EPSG:2154 exported: " + outputFile.getAbsolutePath());
    }

    public static void hugeMap2() throws Exception {
        int width = 10000;
        int height = 10000;
        int tileSize = 1024;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("TIFF");
        if (!writers.hasNext()) {
            throw new IllegalStateException("No TIFF writer found.");
        }
        ImageWriter writer = writers.next();
        TIFFImageWriteParam writeParam = new TIFFImageWriteParam(Locale.ENGLISH);
        writeParam.setCompressionMode(0);
        writeParam.setTilingMode(2);
        writeParam.setTiling(1024, 1024, 0, 0);
        File outputFile = new File("C:/Data/temp/export/large_image.tif");
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(outputFile);){
            writer.setOutput(ios);
            BufferedImage tileSample = new BufferedImage(1024, 1024, 10);
            ImageTypeSpecifier typeSpecifier = new ImageTypeSpecifier(tileSample);
            writer.prepareWriteSequence(null);
            for (int y = 0; y < 10000; y += 1024) {
                for (int x = 0; x < 10000; x += 1024) {
                    int w = Math.min(1024, 10000 - x);
                    int h = Math.min(1024, 10000 - y);
                    BufferedImage tile = new BufferedImage(w, h, 10);
                    WritableRaster raster = tile.getRaster();
                    for (int j = 0; j < h; ++j) {
                        for (int i = 0; i < w; ++i) {
                            int value = ((x + i) / 100 + (y + j) / 100) % 256;
                            raster.setSample(i, j, 0, value);
                        }
                    }
                    IIOImage iioImage = new IIOImage(tile, null, null);
                    writer.writeToSequence(iioImage, (ImageWriteParam)writeParam);
                }
            }
            writer.endWriteSequence();
            System.out.println("Large GeoTIFF successfully written: " + outputFile.getAbsolutePath());
        }
    }
}

