/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.output;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Tile;
import org.locationtech.jts.geom.Envelope;

public abstract class TileRasterDistanceOutput {
    private String folder;
    private String name;
    private Tile tile;
    private int tileSize;
    private int maxTile;
    private double cellSize;
    private int noDataValue;
    private float[][] tabs;
    private boolean[] actives;
    private float[] datas;
    private int width;
    private int height;
    private int theY;
    private int tY;
    private int tabY;

    public TileRasterDistanceOutput(String folder, String name, Tile tile, int width, int height, int maxTile, double minX, double maxX, double minY, double maxY, double cellSize, int noDataValue) {
        this.folder = folder;
        this.name = name;
        this.tile = Tile.getTile(tile, new Envelope(minX, maxX, minY, maxY));
        this.width = width;
        this.height = height;
        this.maxTile = maxTile;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    public void init() {
        this.tileSize = new Double(this.tile.getTileLength() / this.cellSize).intValue();
        this.actives = new boolean[this.tile.getNcols()];
        this.tabs = new float[this.tile.getNcols()][new Double(Math.pow(this.tileSize, 2.0)).intValue()];
        this.datas = new float[this.maxTile * this.width];
        this.tabY = 0;
        this.tY = 0;
        this.theY = 0;
        this.resetTabs();
    }

    private void resetTabs() {
        for (int t = 0; t < this.tile.getNcols(); ++t) {
            this.actives[t] = false;
        }
        this.tabY = 0;
    }

    public void post(int x, int y, int roiWidth, int roiHeight, float[] values) {
        for (int j = 0; j < roiHeight; ++j) {
            for (int i = 0; i < roiWidth; ++i) {
                this.datas[j * this.width + (i + x)] = values[j * roiWidth + i];
            }
        }
    }

    public void operate(int y, int localHeight) {
        if (y == 0) {
            this.doOperate(0, localHeight);
        } else {
            this.doOperate(1, localHeight);
        }
    }

    private void doOperate(int y, int localHeight) {
        int x;
        int t;
        while (this.tabY < this.tileSize && y < localHeight) {
            for (t = 0; t < this.tile.getNcols(); ++t) {
                for (x = 0; x < this.tileSize; ++x) {
                    float v = this.datas[y * this.width + x + t * this.tileSize];
                    if (v != (float)this.noDataValue) {
                        this.actives[t] = true;
                    }
                    this.tabs[t][this.tabY * this.tileSize + x] = v;
                }
            }
            ++this.tabY;
            ++y;
            ++this.theY;
        }
        if (this.tabY == this.tileSize) {
            this.exportTabs();
            ++this.tY;
            this.resetTabs();
            this.doOperate(y, localHeight);
        } else if (this.theY == this.height) {
            while (this.tabY < this.tileSize) {
                for (t = 0; t < this.tile.getNcols(); ++t) {
                    for (x = 0; x < this.tileSize; ++x) {
                        this.tabs[t][this.tabY * this.tileSize + x] = this.noDataValue;
                    }
                }
                ++this.tabY;
            }
            this.exportTabs();
        }
    }

    private void exportTabs() {
        for (int t = 0; t < this.tile.getNcols(); ++t) {
            if (!this.actives[t]) continue;
            this.exportTab(t);
        }
    }

    private void exportTab(int tX) {
        Envelope e = this.tile.getEnvelope(tX, this.tY);
        EnteteRaster entete = new EnteteRaster(this.tileSize, this.tileSize, e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), (float)this.cellSize, this.noDataValue);
        this.writeRaster(this.folder + this.name + "_" + (int)e.getMinX() / 1000 + "_" + (int)e.getMaxY() / 1000, this.tabs[tX], entete);
    }

    public void close() {
        this.datas = null;
        this.tabs = null;
        this.actives = null;
    }

    protected abstract void writeRaster(String var1, float[] var2, EnteteRaster var3);
}

