/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.slope;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import java.util.ArrayList;
import java.util.List;

public class TabSourceErosionPenteRCMDistanceAnalysis
extends Analysis {
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private static final float coeffReg = 314.0f;
    private float[] outDatas;
    private float[] inDatas;
    private float[] infiltrationDatas;
    private float[] altitudeDatas;
    private float[] everDatas;
    private int[] codes;
    private float threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private boolean hasValue;
    private List<Integer>[] waits;

    public TabSourceErosionPenteRCMDistanceAnalysis(float[] outDatas, float[] altitudeDatas, float[] infiltrationDatas, int width, int height, float cellSize, int noDataValue, float threshold) {
        this(outDatas, null, altitudeDatas, infiltrationDatas, width, height, cellSize, noDataValue, null, threshold);
    }

    public TabSourceErosionPenteRCMDistanceAnalysis(float[] outDatas, float[] inDatas, float[] altitudeDatas, float[] infiltrationDatas, int width, int height, float cellSize, int noDataValue, int[] codes, float threshold) {
        this.outDatas = outDatas;
        this.inDatas = inDatas;
        this.infiltrationDatas = infiltrationDatas;
        this.altitudeDatas = altitudeDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.codes = codes;
        this.threshold = threshold;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    protected void doInit() {
        block12: {
            block11: {
                this.everDatas = new float[this.outDatas.length];
                this.waits = new ArrayList[(int)(this.threshold * 314.0f / this.cellSize)];
                this.waits[0] = new ArrayList<Integer>();
                this.hasValue = false;
                if (this.inDatas != null) break block11;
                for (int ind = 0; ind < this.infiltrationDatas.length; ++ind) {
                    if (this.infiltrationDatas[ind] == (float)this.noDataValue) {
                        this.outDatas[ind] = this.noDataValue;
                        continue;
                    }
                    if (ind == (this.width * this.width - 1) / 2) {
                        this.hasValue = true;
                        this.outDatas[ind] = 0.0f;
                        this.waits[0].add(ind);
                        continue;
                    }
                    this.outDatas[ind] = -2.0f;
                }
                break block12;
            }
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    float v = this.inDatas[yt * this.width + xt];
                    boolean ok = false;
                    if (v != (float)this.noDataValue) {
                        for (int c : this.codes) {
                            if ((float)c != v) continue;
                            ok = true;
                            this.hasValue = true;
                            break;
                        }
                        if (ok) {
                            this.outDatas[yt * this.width + xt] = 0.0f;
                            continue;
                        }
                        this.outDatas[yt * this.width + xt] = -2.0f;
                        continue;
                    }
                    this.outDatas[yt * this.width + xt] = this.noDataValue;
                }
            }
            this.inDatas = null;
            if (!this.hasValue) break block12;
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    if (this.outDatas[yt * this.width + xt] != 0.0f) continue;
                    boolean maj = true;
                    if (!(xt != 0 && this.outDatas[xt - 1 + yt * this.width] != 0.0f || xt != 0 && yt != 0 && this.outDatas[xt - 1 + (yt - 1) * this.width] != 0.0f || yt != 0 && this.outDatas[xt + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && yt != 0 && this.outDatas[xt + 1 + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && this.outDatas[xt + 1 + yt * this.width] != 0.0f || xt != this.width - 1 && yt != this.height - 1 && this.outDatas[xt + 1 + (yt + 1) * this.width] != 0.0f || yt != this.height - 1 && this.outDatas[xt + (yt + 1) * this.width] != 0.0f || xt != 0 && yt != this.height - 1 && this.outDatas[xt - 1 + (yt + 1) * this.width] != 0.0f)) {
                        maj = false;
                    }
                    if (!maj) continue;
                    this.setPixelAndValue(yt * this.width + xt, 0.0f);
                }
            }
        }
    }

    @Override
    public void doRun() {
        if (this.hasValue) {
            for (int d = 0; d < (int)(this.threshold * 314.0f / this.cellSize); ++d) {
                List<Integer> wait = this.waits[d];
                if (wait == null) continue;
                this.waits[d] = null;
                this.diffusionPaquet(d, wait);
                --d;
            }
        }
        this.setResult(this.outDatas);
    }

    private static float getSlopeIntensity(float alt, float nalt, float cote_adjacent) {
        if (alt == nalt) {
            return 0.0f;
        }
        float cote_oppose = alt - nalt;
        float tangente = cote_oppose / cote_adjacent;
        double arctangente = Math.atan(tangente);
        double angle = Math.toDegrees(arctangente);
        float v = (float)((90.0 - angle) % 180.0);
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    private float friction(float slopeIntensity, float infiltration) {
        float friction = 2.0f + 9.0f * infiltration - slopeIntensity;
        if (friction >= 9.0f) {
            friction *= 10.0f;
        }
        return friction;
    }

    private void diffusionPaquet(int dd, List<Integer> wait) {
        for (int p : wait) {
            this.diffusion(p, (float)dd / 314.0f);
        }
    }

    public void setPixelAndValue(int pixel, float dist) {
        if (dist < (float)((int)(this.threshold / this.cellSize))) {
            if (this.waits[(int)(dist * 314.0f)] == null) {
                this.waits[(int)(dist * 314.0f)] = new ArrayList<Integer>();
            }
            this.waits[(int)(dist * 314.0f)].add(pixel);
        }
    }

    private void diffusion(int p, double dd) {
        if (this.everDatas[p] != 1.0f && (double)((float)((int)this.threshold) / this.cellSize) > dd) {
            this.everDatas[p] = 1.0f;
            if (this.outDatas[p] != (float)this.noDataValue) {
                float d;
                float friction;
                float infc;
                float nalt;
                float sInt;
                float v;
                float alt = this.altitudeDatas[p];
                int x = p % this.width;
                int y = p / this.width;
                float slope = -1.0f;
                int direction = 0;
                int np = p - this.width - 1;
                if (x > 0 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], sqrt2 * this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 1;
                }
                np = p - this.width;
                if (y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 2;
                }
                np = p - this.width + 1;
                if (x < this.width - 1 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], sqrt2 * this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 3;
                }
                np = p - 1;
                if (x > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 4;
                }
                np = p + 1;
                if (x < this.width - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 5;
                }
                np = p + this.width - 1;
                if (x > 0 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], sqrt2 * this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 6;
                }
                np = p + this.width;
                if (y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 7;
                }
                np = p + this.width + 1;
                if (x < this.width - 1 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue && (sInt = TabSourceErosionPenteRCMDistanceAnalysis.getSlopeIntensity(alt, nalt = this.altitudeDatas[np], sqrt2 * this.cellSize)) >= slope) {
                    slope = sInt;
                    direction = 8;
                }
                if (direction == 1) {
                    np = p - this.width - 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)(sqrt2 * friction));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 2) {
                    np = p - this.width;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)friction);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 3) {
                    np = p - this.width + 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)(sqrt2 * friction));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 4) {
                    np = p - 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)friction);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 5) {
                    np = p + 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)friction);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 6) {
                    np = p + this.width - 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)(sqrt2 * friction));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 7) {
                    np = p + this.width;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)friction);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (direction == 8) {
                    np = p + this.width + 1;
                    v = this.outDatas[np];
                    infc = this.infiltrationDatas[np];
                    friction = this.friction(slope, infc);
                    d = (float)(dd + (double)(sqrt2 * friction));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() {
        this.waits = null;
        this.inDatas = null;
        this.infiltrationDatas = null;
        this.altitudeDatas = null;
        this.everDatas = null;
    }
}

