/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.slope;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import java.util.ArrayList;
import java.util.List;

public class TabMassCumulAnalysis
extends Analysis {
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private static final float coeffReg = 314.0f;
    private float[] outDatas;
    private float[] inDatas;
    private float[] altitudeDatas;
    private float[] infiltrationDatas;
    private float[] slopeIntensityDatas;
    private float[] everDatas;
    private int[] codes;
    private float massInit;
    private int width;
    private int height;
    private float cellSize;
    private float localSurface;
    private int noDataValue;
    private boolean hasValue;
    private List<Integer>[] waits;

    public TabMassCumulAnalysis(float[] outDatas, float[] altitudeDatas, float[] infiltrationDatas, float[] slopeIntensityDatas, int width, int height, float cellSize, int noDataValue, float massInit) {
        this(outDatas, null, altitudeDatas, infiltrationDatas, slopeIntensityDatas, width, height, cellSize, noDataValue, null, massInit);
    }

    public TabMassCumulAnalysis(float[] outDatas, float[] inDatas, float[] altitudeDatas, float[] infiltrationDatas, float[] slopeIntensityDatas, int width, int height, float cellSize, int noDataValue, int[] codes, float massInit) {
        this.outDatas = outDatas;
        this.inDatas = inDatas;
        this.altitudeDatas = altitudeDatas;
        this.infiltrationDatas = infiltrationDatas;
        this.slopeIntensityDatas = slopeIntensityDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.localSurface = (float)Math.pow(cellSize, 2.0);
        this.noDataValue = noDataValue;
        this.codes = codes;
        this.massInit = massInit;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    protected void doInit() {
        block12: {
            block11: {
                this.everDatas = new float[this.outDatas.length];
                this.waits = new ArrayList[(int)(this.massInit * 314.0f) + 1];
                this.waits[(int)(this.massInit * 314.0f)] = new ArrayList<Integer>();
                this.hasValue = false;
                if (this.inDatas != null) break block11;
                for (int ind = 0; ind < this.infiltrationDatas.length; ++ind) {
                    if (this.infiltrationDatas[ind] == (float)this.noDataValue) {
                        this.outDatas[ind] = this.noDataValue;
                        continue;
                    }
                    if (ind == (this.width * this.width - 1) / 2) {
                        this.hasValue = true;
                        this.outDatas[ind] = this.massInit;
                        this.waits[(int)(this.massInit * 314.0f)].add(ind);
                        continue;
                    }
                    this.outDatas[ind] = -2.0f;
                }
                break block12;
            }
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    float v = this.inDatas[yt * this.width + xt];
                    boolean ok = false;
                    if (v != (float)this.noDataValue) {
                        for (int c : this.codes) {
                            if ((float)c != v) continue;
                            ok = true;
                            this.hasValue = true;
                            break;
                        }
                        if (ok) {
                            this.outDatas[yt * this.width + xt] = this.massInit;
                            continue;
                        }
                        this.outDatas[yt * this.width + xt] = -2.0f;
                        continue;
                    }
                    this.outDatas[yt * this.width + xt] = this.noDataValue;
                }
            }
            this.inDatas = null;
            if (!this.hasValue) break block12;
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    if (this.outDatas[yt * this.width + xt] != 0.0f) continue;
                    boolean maj = true;
                    if (!(xt != 0 && this.outDatas[xt - 1 + yt * this.width] != 0.0f || xt != 0 && yt != 0 && this.outDatas[xt - 1 + (yt - 1) * this.width] != 0.0f || yt != 0 && this.outDatas[xt + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && yt != 0 && this.outDatas[xt + 1 + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && this.outDatas[xt + 1 + yt * this.width] != 0.0f || xt != this.width - 1 && yt != this.height - 1 && this.outDatas[xt + 1 + (yt + 1) * this.width] != 0.0f || yt != this.height - 1 && this.outDatas[xt + (yt + 1) * this.width] != 0.0f || xt != 0 && yt != this.height - 1 && this.outDatas[xt - 1 + (yt + 1) * this.width] != 0.0f)) {
                        maj = false;
                    }
                    if (!maj) continue;
                    this.setPixelAndValue(yt * this.width + xt, this.massInit);
                }
            }
        }
    }

    @Override
    public void doRun() {
        if (this.hasValue) {
            for (int m = (int)(this.massInit * 314.0f); m > 0; --m) {
                List<Integer> wait = this.waits[m];
                if (wait == null) continue;
                this.waits[m] = null;
                this.diffusionPaquet(m, wait);
                ++m;
            }
        }
        this.setResult(this.outDatas);
    }

    private void diffusionPaquet(int masseLocale, List<Integer> wait) {
        for (int p : wait) {
            this.diffusion(p, (float)masseLocale / 314.0f);
        }
    }

    public void setPixelAndValue(int pixel, float masse) {
        if (masse > 0.0f && masse <= (float)((int)this.massInit)) {
            if (this.waits[(int)(masse * 314.0f)] == null) {
                this.waits[(int)(masse * 314.0f)] = new ArrayList<Integer>();
            }
            this.waits[(int)(masse * 314.0f)].add(pixel);
        }
    }

    private void diffusion(int p, float masseLocale) {
        if (this.everDatas[p] != 1.0f && masseLocale > 0.0f) {
            this.everDatas[p] = 1.0f;
            if (this.outDatas[p] != (float)this.noDataValue) {
                float alt0 = this.altitudeDatas[p];
                float inf0 = this.infiltrationDatas[p];
                float friction0 = this.friction(inf0);
                float masseLocale0 = masseLocale - friction0 * this.localSurface;
                float sIntMax = TabMassCumulAnalysis.getSlopeIntensity(this.slopeIntensityDatas[p]);
                int x = p % this.width;
                int y = p / this.width;
                int np = p - this.width - 1;
                if (x > 0 && y > 0 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, sqrt2);
                }
                np = p - this.width;
                if (y > 0 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, 1.0f);
                }
                np = p - this.width + 1;
                if (x < this.width - 1 && y > 0 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, sqrt2);
                }
                np = p - 1;
                if (x > 0 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, 1.0f);
                }
                np = p + 1;
                if (x < this.width - 1 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, 1.0f);
                }
                np = p + this.width - 1;
                if (x > 0 && y < this.height - 1 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, sqrt2);
                }
                np = p + this.width;
                if (y < this.height - 1 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, 1.0f);
                }
                np = p + this.width + 1;
                if (x < this.width - 1 && y < this.height - 1 && this.everDatas[np] != 1.0f) {
                    this.doMassTransfer(np, alt0, masseLocale0, sIntMax, sqrt2);
                }
            }
        }
    }

    private void doMassTransfer1(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float nalt;
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue && (nalt = this.altitudeDatas[np]) <= alt) {
            float masseLocale1;
            if (sIntMax == 0.0f) {
                masseLocale1 = masseLocale0;
            } else {
                float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
                float coeffRepartition = sIntLocal / sIntMax;
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer2(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue) {
            float masseLocale1;
            float nalt = this.altitudeDatas[np];
            if (sIntMax < 0.0f) {
                masseLocale1 = 0.0f;
            } else {
                float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
                float coeffRepartition = (1.0f + sIntLocal) / (1.0f + sIntMax);
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer3(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float nalt;
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue && (nalt = this.altitudeDatas[np]) <= alt) {
            float masseLocale1;
            if (sIntMax == 0.0f) {
                masseLocale1 = masseLocale0;
            } else {
                float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
                float coeffRepartition = (1.0f + sIntLocal) / (1.0f + sIntMax);
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer4(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float nalt;
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue && (nalt = this.altitudeDatas[np]) <= alt) {
            float masseLocale1 = 0.0f;
            if (sIntMax == 0.0f) {
                masseLocale1 = masseLocale0;
            } else {
                float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
                if ((double)(sIntMax - sIntLocal) < 0.1) {
                    masseLocale1 = masseLocale0;
                }
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer5(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue) {
            float nalt = this.altitudeDatas[np];
            float masseLocale1 = 0.0f;
            float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
            if ((double)(sIntMax - sIntLocal) < 0.1) {
                masseLocale1 = masseLocale0;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer7(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue) {
            float nalt = this.altitudeDatas[np];
            float masseLocale1 = 0.0f;
            float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
            if ((double)(sIntMax - sIntLocal) < 0.05) {
                float coeffRepartition = (1.0f + sIntLocal) / (1.0f + sIntMax);
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransferGood(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue) {
            float nalt = this.altitudeDatas[np];
            float masseLocale1 = 0.0f;
            float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
            if ((double)(sIntMax - sIntLocal) < 0.1) {
                float coeffRepartition = (1.0f + sIntLocal) / (1.0f + sIntMax);
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private void doMassTransfer(int np, float alt, float masseLocale0, float sIntMax, float ld) {
        float nalt;
        float m = this.outDatas[np];
        if (m != (float)this.noDataValue && (nalt = this.altitudeDatas[np]) <= alt) {
            float masseLocale1 = 0.0f;
            float sIntLocal = TabMassCumulAnalysis.getSlopeIntensity(alt, nalt, ld * this.cellSize);
            if ((double)(sIntMax - sIntLocal) < 0.1) {
                float coeffRepartition = (1.0f + sIntLocal) / (1.0f + sIntMax);
                masseLocale1 = masseLocale0 * coeffRepartition;
            }
            if (m == -2.0f || masseLocale1 > m) {
                this.outDatas[np] = masseLocale1;
                this.setPixelAndValue(np, masseLocale1);
            }
        }
    }

    private float friction(float infiltration) {
        float friction = 1.0f + (float)(9.0 * Math.pow(infiltration, 5.0));
        return friction;
    }

    private static float getSlopeIntensity(float alt, float nalt, float cote_adjacent) {
        if (alt == nalt) {
            return 0.0f;
        }
        float cote_oppose = alt - nalt;
        float tangente = cote_oppose / cote_adjacent;
        double arctangente = Math.atan(tangente);
        double angle = Math.toDegrees(arctangente);
        return TabMassCumulAnalysis.getSlopeIntensity((float)((90.0 - angle) % 180.0));
    }

    private static float getSlopeIntensity(float angle) {
        if (angle <= 45.0f) {
            return 1.0f;
        }
        if (angle >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - angle) / 45.0);
    }

    @Override
    protected void doClose() {
        this.waits = null;
        this.inDatas = null;
        this.infiltrationDatas = null;
        this.altitudeDatas = null;
        this.slopeIntensityDatas = null;
        this.everDatas = null;
    }
}

