/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.slope;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import java.util.ArrayList;
import java.util.List;

public class TabInverseAltitudeRCMDistanceAnalysis
extends Analysis {
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private static final float coeffReg = 314.0f;
    private float[] outDatas;
    private float[] inDatas;
    private float[] frictionDatas;
    private float[] altitudeDatas;
    private float[] everDatas;
    private int[] codes;
    private float threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private boolean hasValue;
    private List<Integer>[] waits;

    public TabInverseAltitudeRCMDistanceAnalysis(float[] outDatas, float[] inDatas, float[] frictionDatas, float[] altitudeDatas, int width, int height, float cellSize, int noDataValue, int[] codes) {
        this(outDatas, inDatas, frictionDatas, altitudeDatas, width, height, cellSize, noDataValue, codes, noDataValue);
    }

    public TabInverseAltitudeRCMDistanceAnalysis(float[] outDatas, float[] inDatas, float[] frictionDatas, float[] altitudeDatas, int width, int height, float cellSize, int noDataValue, int[] codes, int threshold) {
        this.outDatas = outDatas;
        this.inDatas = inDatas;
        this.frictionDatas = frictionDatas;
        this.altitudeDatas = altitudeDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.codes = codes;
        this.threshold = threshold == noDataValue ? 2.1474836E9f : (float)threshold;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    protected void doInit() {
        block12: {
            block11: {
                this.everDatas = new float[this.outDatas.length];
                this.waits = new ArrayList[(int)(this.threshold * 314.0f / this.cellSize)];
                this.waits[0] = new ArrayList<Integer>();
                this.hasValue = false;
                if (this.inDatas != null) break block11;
                for (int ind = 0; ind < this.frictionDatas.length; ++ind) {
                    if (this.frictionDatas[ind] == (float)this.noDataValue) {
                        this.outDatas[ind] = this.noDataValue;
                        continue;
                    }
                    if (ind == (this.width * this.width - 1) / 2) {
                        this.hasValue = true;
                        this.outDatas[ind] = 0.0f;
                        this.waits[0].add(ind);
                        continue;
                    }
                    this.outDatas[ind] = -2.0f;
                }
                break block12;
            }
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    float v = this.inDatas[yt * this.width + xt];
                    boolean ok = false;
                    if (v != (float)this.noDataValue) {
                        for (int c : this.codes) {
                            if ((float)c != v) continue;
                            ok = true;
                            this.hasValue = true;
                            break;
                        }
                        if (ok) {
                            this.outDatas[yt * this.width + xt] = 0.0f;
                            continue;
                        }
                        this.outDatas[yt * this.width + xt] = -2.0f;
                        continue;
                    }
                    this.outDatas[yt * this.width + xt] = this.noDataValue;
                }
            }
            this.inDatas = null;
            if (!this.hasValue) break block12;
            for (int yt = 0; yt < this.height; ++yt) {
                for (int xt = 0; xt < this.width; ++xt) {
                    if (this.outDatas[yt * this.width + xt] != 0.0f) continue;
                    boolean maj = true;
                    if (!(xt != 0 && this.outDatas[xt - 1 + yt * this.width] != 0.0f || xt != 0 && yt != 0 && this.outDatas[xt - 1 + (yt - 1) * this.width] != 0.0f || yt != 0 && this.outDatas[xt + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && yt != 0 && this.outDatas[xt + 1 + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && this.outDatas[xt + 1 + yt * this.width] != 0.0f || xt != this.width - 1 && yt != this.height - 1 && this.outDatas[xt + 1 + (yt + 1) * this.width] != 0.0f || yt != this.height - 1 && this.outDatas[xt + (yt + 1) * this.width] != 0.0f || xt != 0 && yt != this.height - 1 && this.outDatas[xt - 1 + (yt + 1) * this.width] != 0.0f)) {
                        maj = false;
                    }
                    if (!maj) continue;
                    this.setPixelAndValue(yt * this.width + xt, 0.0f);
                }
            }
        }
    }

    @Override
    public void doRun() {
        if (this.hasValue) {
            int d = 0;
            while ((float)d < this.threshold * 314.0f / this.cellSize) {
                List<Integer> wait = this.waits[d];
                if (wait != null) {
                    this.waits[d] = null;
                    this.diffusionPaquet(d, wait);
                    --d;
                }
                ++d;
            }
        }
        this.setResult(this.outDatas);
    }

    private void diffusionPaquet(int dd, List<Integer> wait) {
        for (int p : wait) {
            this.diffusion(p, (float)dd / 314.0f);
        }
    }

    public void setPixelAndValue(int pixel, float dist) {
        if (dist < this.threshold / this.cellSize) {
            if (this.waits[(int)(dist * 314.0f)] == null) {
                this.waits[(int)(dist * 314.0f)] = new ArrayList<Integer>();
            }
            this.waits[(int)(dist * 314.0f)].add(pixel);
        }
    }

    private void diffusion(int p, double dd) {
        if (this.everDatas[p] != 1.0f && (double)(this.threshold / this.cellSize) > dd) {
            this.everDatas[p] = 1.0f;
            if (this.outDatas[p] != (float)this.noDataValue) {
                float d;
                float fc;
                float v;
                float fd = this.frictionDatas[p];
                float alt = this.altitudeDatas[p];
                int x = p % this.width;
                int y = p / this.width;
                int np = p - this.width - 1;
                float nalt = this.altitudeDatas[np];
                if (alt <= nalt && x > 0 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p - this.width]) && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p - this.width + 1]) && x < this.width - 1 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p - 1]) && x > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p + 1]) && x < this.width - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p + this.width - 1]) && x > 0 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p + this.width]) && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                if (alt <= (nalt = this.altitudeDatas[np = p + this.width + 1]) && x < this.width - 1 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() {
        this.waits = null;
        this.inDatas = null;
        this.frictionDatas = null;
        this.altitudeDatas = null;
        this.everDatas = null;
    }
}

